/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;

public abstract class LuceneIndexPopulator
implements IndexPopulator {
    protected SchemaIndex luceneIndex;
    protected LuceneIndexWriter writer;

    LuceneIndexPopulator(SchemaIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    public void create() throws IOException {
        this.luceneIndex.create();
        this.luceneIndex.open();
        this.writer = this.luceneIndex.getIndexWriter();
    }

    public void drop() {
        this.luceneIndex.drop();
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IOException {
        assert (this.updatesForCorrectIndex(updates));
        this.writer.addDocuments(updates.size(), () -> updates.stream().map(LuceneIndexPopulator::updateAsDocument).iterator());
    }

    public void close(boolean populationCompletedSuccessfully) throws IOException {
        try {
            if (populationCompletedSuccessfully) {
                this.luceneIndex.markAsOnline();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new SchemaIndex[]{this.luceneIndex});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new SchemaIndex[]{this.luceneIndex});
    }

    public void markAsFailed(String failure) throws IOException {
        this.luceneIndex.markAsFailed(failure);
    }

    private boolean updatesForCorrectIndex(Collection<? extends IndexEntryUpdate<?>> updates) {
        for (IndexEntryUpdate<?> update : updates) {
            if (update.indexKey().schema().equals(this.luceneIndex.getDescriptor().schema())) continue;
            return false;
        }
        return true;
    }

    private static Document updateAsDocument(IndexEntryUpdate<?> update) {
        return LuceneDocumentStructure.documentRepresentingProperties(update.getEntityId(), update.values());
    }
}

