/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.schema.IndexProviderFactoryUtil;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSlotSelector00;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;

public class LuceneIndexProviderFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String KEY = "lucene";
    public static final IndexProvider.Descriptor PROVIDER_DESCRIPTOR = new IndexProvider.Descriptor("lucene", "1.0");

    public LuceneIndexProviderFactory() {
        super(KEY);
    }

    public IndexProvider newInstance(KernelContext context, Dependencies dependencies) {
        PageCache pageCache = dependencies.pageCache();
        File storeDir = context.storeDir();
        FileSystemAbstraction fs = dependencies.fileSystem();
        Monitors monitors = dependencies.monitors();
        Log log = dependencies.getLogService().getInternalLogProvider().getLog(LuceneIndexProvider.class);
        monitors.addMonitorListener((Object)new LoggingMonitor(log), new String[]{PROVIDER_DESCRIPTOR.toString()});
        IndexProvider.Monitor monitor = (IndexProvider.Monitor)monitors.newMonitor(IndexProvider.Monitor.class, new String[]{KEY});
        Config config = dependencies.getConfig();
        OperationalMode operationalMode = context.databaseInfo().operationalMode;
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = dependencies.recoveryCleanupWorkCollector();
        return LuceneIndexProviderFactory.newInstance(pageCache, storeDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    public static FusionIndexProvider newInstance(PageCache pageCache, File storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        boolean readOnly = IndexProviderFactoryUtil.isReadOnly(config, operationalMode);
        boolean archiveFailedIndex = (Boolean)config.get(GraphDatabaseSettings.archive_failed_index);
        IndexDirectoryStructure.Factory luceneDirStructure = IndexDirectoryStructure.directoriesByProviderKey((File)storeDir);
        IndexDirectoryStructure.Factory childDirectoryStructure = LuceneIndexProviderFactory.subProviderDirectoryStructure(storeDir);
        LuceneIndexProvider lucene = IndexProviderFactoryUtil.luceneProvider(fs, luceneDirStructure, monitor, config, operationalMode);
        TemporalIndexProvider temporal = IndexProviderFactoryUtil.temporalProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly);
        SpatialIndexProvider spatial = IndexProviderFactoryUtil.spatialProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly, config);
        String defaultSchemaProvider = (String)config.get(GraphDatabaseSettings.default_schema_provider);
        int priority = 1;
        if (GraphDatabaseSettings.SchemaIndex.LUCENE10.providerName().equals(defaultSchemaProvider)) {
            priority = 100;
        }
        return new FusionIndexProvider(IndexProvider.EMPTY, IndexProvider.EMPTY, (IndexProvider)spatial, (IndexProvider)temporal, (IndexProvider)lucene, (SlotSelector)new FusionSlotSelector00(), PROVIDER_DESCRIPTOR, priority, IndexDirectoryStructure.directoriesByProvider((File)storeDir), fs, archiveFailedIndex);
    }

    private static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File storeDir) {
        return NativeLuceneFusionIndexProviderFactory.subProviderDirectoryStructure(storeDir, PROVIDER_DESCRIPTOR);
    }

    public static interface Dependencies {
        public PageCache pageCache();

        public RecoveryCleanupWorkCollector recoveryCleanupWorkCollector();

        public Config getConfig();

        public Monitors monitors();

        public LogService getLogService();

        public FileSystemAbstraction fileSystem();
    }
}

