/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexType;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.index.impl.lucene.explicit.LuceneExplicitIndex;
import org.neo4j.index.impl.lucene.explicit.LuceneTransactionState;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.spi.explicitindex.ExplicitIndexProviderTransaction;
import org.neo4j.kernel.spi.explicitindex.IndexCommandFactory;

public class LuceneExplicitIndexTransaction
implements ExplicitIndexProviderTransaction {
    private final LuceneDataSource dataSource;
    private final Map<String, LuceneExplicitIndex> nodeIndexes = new HashMap<String, LuceneExplicitIndex>();
    private final Map<String, LuceneExplicitIndex> relationshipIndexes = new HashMap<String, LuceneExplicitIndex>();
    private final LuceneTransactionState luceneTransaction;
    private final IndexCommandFactory commandFactory;

    public LuceneExplicitIndexTransaction(LuceneDataSource dataSource, IndexCommandFactory commandFactory) {
        this.dataSource = dataSource;
        this.commandFactory = commandFactory;
        this.luceneTransaction = new LuceneTransactionState();
    }

    public ExplicitIndex nodeIndex(String indexName, Map<String, String> configuration) {
        LuceneExplicitIndex index = this.nodeIndexes.get(indexName);
        if (index == null) {
            IndexIdentifier identifier = new IndexIdentifier(IndexEntityType.Node, indexName);
            index = new LuceneExplicitIndex.NodeExplicitIndex(this.dataSource, identifier, this.luceneTransaction, IndexType.getIndexType(configuration), this.commandFactory);
            this.nodeIndexes.put(indexName, index);
        }
        return index;
    }

    public ExplicitIndex relationshipIndex(String indexName, Map<String, String> configuration) {
        LuceneExplicitIndex index = this.relationshipIndexes.get(indexName);
        if (index == null) {
            IndexIdentifier identifier = new IndexIdentifier(IndexEntityType.Relationship, indexName);
            index = new LuceneExplicitIndex.RelationshipExplicitIndex(this.dataSource, identifier, this.luceneTransaction, IndexType.getIndexType(configuration), this.commandFactory);
            this.relationshipIndexes.put(indexName, index);
        }
        return index;
    }

    public void close() {
        this.luceneTransaction.close();
    }
}

