/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.index.impl.lucene.explicit.EntityId;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexReference;
import org.neo4j.index.impl.lucene.explicit.IndexType;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;

class CommitContext
implements Closeable {
    final LuceneDataSource dataSource;
    final IndexIdentifier identifier;
    final IndexType indexType;
    final MutableLongObjectMap<DocumentContext> documents = new LongObjectHashMap();
    final boolean recovery;
    IndexReference searcher;
    IndexWriter writer;

    CommitContext(LuceneDataSource dataSource, IndexIdentifier identifier, IndexType indexType, boolean isRecovery) {
        this.dataSource = dataSource;
        this.identifier = identifier;
        this.indexType = indexType;
        this.recovery = isRecovery;
    }

    void ensureWriterInstantiated() throws ExplicitIndexNotFoundKernelException {
        if (this.searcher == null) {
            this.searcher = this.dataSource.getIndexSearcher(this.identifier);
            this.writer = this.searcher.getWriter();
        }
    }

    DocumentContext getDocument(EntityId entityId, boolean allowCreate) {
        long id = entityId.id();
        DocumentContext context = (DocumentContext)this.documents.get(id);
        if (context != null) {
            return context;
        }
        Document document = LuceneDataSource.findDocument(this.indexType, this.searcher.getSearcher(), id);
        if (document != null) {
            context = new DocumentContext(document, true, id);
            this.documents.put(id, (Object)context);
        } else if (allowCreate) {
            context = new DocumentContext(IndexType.newDocument(entityId), false, id);
            this.documents.put(id, (Object)context);
        }
        return context;
    }

    private void applyDocuments(IndexWriter writer, IndexType type, LongObjectMap<DocumentContext> documents) throws IOException {
        for (DocumentContext context : documents) {
            if (context.exists) {
                if (LuceneDataSource.documentIsEmpty(context.document)) {
                    writer.deleteDocuments(new Term[]{type.idTerm(context.entityId)});
                    continue;
                }
                writer.updateDocument(type.idTerm(context.entityId), (Iterable)context.document);
                continue;
            }
            writer.addDocument((Iterable)context.document);
        }
    }

    @Override
    public void close() throws IOException {
        this.applyDocuments(this.writer, this.indexType, (LongObjectMap<DocumentContext>)this.documents);
        if (this.writer != null) {
            this.dataSource.invalidateIndexSearcher(this.identifier);
        }
        if (this.searcher != null) {
            this.searcher.close();
        }
    }

    static class DocumentContext {
        final Document document;
        final boolean exists;
        final long entityId;

        DocumentContext(Document document, boolean exists, long entityId) {
            this.document = document;
            this.exists = exists;
            this.entityId = entityId;
        }

        public String toString() {
            return "DocumentContext[document=" + this.document + ", exists=" + this.exists + ", entityId=" + this.entityId + "]";
        }
    }
}

