/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.store.DefaultIndexReference;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

@RunWith(value=Parameterized.class)
public class MultipleOpenCursorsTest {
    private final DatabaseRule db = new EmbeddedDatabaseRule();
    private static final RandomRule rnd = new RandomRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)rnd).around((TestRule)this.db);
    private static final Label indexLabel = Label.label((String)"IndexLabel");
    private static final String numberProp1 = "numberProp1";
    private static final String numberProp2 = "numberProp2";
    private static final String stringProp1 = "stringProp1";
    private static final String stringProp2 = "stringProp2";
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public IndexCoordinatorFactory indexCoordinatorFactory;
    private IndexCoordinator indexCoordinator;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"Single number non unique", NumberIndexCoordinator::new}, {"Single string non unique", StringIndexCoordinator::new}, {"Composite number non unique", NumberCompositeIndexCoordinator::new}, {"Composite string non unique", StringCompositeIndexCoordinator::new});
    }

    @Before
    public void setupDb() throws InvalidTransactionTypeKernelException, RepeatedPropertyInCompositeSchemaException, AlreadyIndexedException, AlreadyConstrainedException, IndexNotFoundKernelException, InterruptedException {
        this.indexCoordinator = this.indexCoordinatorFactory.create(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        this.indexCoordinator.init(this.db);
        this.indexCoordinator.createIndex(this.db);
    }

    @Test
    public void multipleCursorsNotNestedExists() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryExists(ktx);
                 NodeValueIndexCursor cursor2 = this.indexCoordinator.queryExists(ktx);){
                List<Long> actual1 = this.asList(cursor1);
                List<Long> actual2 = this.asList(cursor2);
                this.indexCoordinator.assertExistsResult(actual1);
                this.indexCoordinator.assertExistsResult(actual2);
            }
            tx.success();
        }
    }

    private List<Long> asList(NodeValueIndexCursor cursor) {
        ArrayList<Long> list = new ArrayList<Long>();
        while (cursor.next()) {
            list.add(cursor.nodeReference());
        }
        return list;
    }

    @Test
    public void multipleCursorsNotNestedExact() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryExact(ktx);
                 NodeValueIndexCursor cursor2 = this.indexCoordinator.queryExact(ktx);){
                List<Long> actual1 = this.asList(cursor1);
                List<Long> actual2 = this.asList(cursor2);
                this.indexCoordinator.assertExactResult(actual1);
                this.indexCoordinator.assertExactResult(actual2);
            }
            tx.success();
        }
    }

    @Test
    public void multipleIteratorsNotNestedRange() throws KernelException {
        Assume.assumeTrue((boolean)this.indexCoordinator.supportRangeQuery());
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryRange(ktx);
                 NodeValueIndexCursor cursor2 = this.indexCoordinator.queryRange(ktx);){
                List<Long> actual1 = this.asList(cursor1);
                List<Long> actual2 = this.asList(cursor2);
                this.indexCoordinator.assertRangeResult(actual1);
                this.indexCoordinator.assertRangeResult(actual2);
            }
            tx.success();
        }
    }

    @Test
    public void multipleIteratorsNestedInnerNewExists() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryExists(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                while (cursor1.next()) {
                    actual1.add(cursor1.nodeReference());
                    NodeValueIndexCursor cursor2 = this.indexCoordinator.queryExists(ktx);
                    Throwable throwable = null;
                    try {
                        List<Long> actual2 = this.asList(cursor2);
                        this.indexCoordinator.assertExistsResult(actual2);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cursor2 == null) continue;
                        if (throwable != null) {
                            try {
                                cursor2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        cursor2.close();
                    }
                }
                this.indexCoordinator.assertExistsResult(actual1);
            }
            tx.success();
        }
    }

    @Test
    public void multipleIteratorsNestedInnerNewExact() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryExact(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                while (cursor1.next()) {
                    actual1.add(cursor1.nodeReference());
                    NodeValueIndexCursor cursor2 = this.indexCoordinator.queryExact(ktx);
                    Throwable throwable = null;
                    try {
                        List<Long> actual2 = this.asList(cursor2);
                        this.indexCoordinator.assertExactResult(actual2);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cursor2 == null) continue;
                        if (throwable != null) {
                            try {
                                cursor2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        cursor2.close();
                    }
                }
                this.indexCoordinator.assertExactResult(actual1);
            }
            tx.success();
        }
    }

    @Test
    public void multipleIteratorsNestedInnerNewRange() throws Exception {
        Assume.assumeTrue((boolean)this.indexCoordinator.supportRangeQuery());
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryRange(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                while (cursor1.next()) {
                    actual1.add(cursor1.nodeReference());
                    NodeValueIndexCursor cursor2 = this.indexCoordinator.queryRange(ktx);
                    Throwable throwable = null;
                    try {
                        List<Long> actual2 = this.asList(cursor2);
                        this.indexCoordinator.assertRangeResult(actual2);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cursor2 == null) continue;
                        if (throwable != null) {
                            try {
                                cursor2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        cursor2.close();
                    }
                }
                this.indexCoordinator.assertRangeResult(actual1);
            }
            tx.success();
        }
    }

    @Test
    public void multipleIteratorsNestedInterleavedExists() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryExists(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                try (NodeValueIndexCursor cursor2 = this.indexCoordinator.queryExists(ktx);){
                    ArrayList<Long> actual2 = new ArrayList<Long>();
                    this.exhaustInterleaved(cursor1, actual1, cursor2, actual2);
                    this.indexCoordinator.assertExistsResult(actual1);
                    this.indexCoordinator.assertExistsResult(actual2);
                }
            }
            tx.success();
        }
    }

    @Test
    public void multipleIteratorsNestedInterleavedExact() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryExact(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                try (NodeValueIndexCursor cursor2 = this.indexCoordinator.queryExact(ktx);){
                    ArrayList<Long> actual2 = new ArrayList<Long>();
                    this.exhaustInterleaved(cursor1, actual1, cursor2, actual2);
                    this.indexCoordinator.assertExactResult(actual1);
                    this.indexCoordinator.assertExactResult(actual2);
                }
            }
            tx.success();
        }
    }

    @Test
    public void multipleIteratorsNestedInterleavedRange() throws Exception {
        Assume.assumeTrue((boolean)this.indexCoordinator.supportRangeQuery());
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.db.transaction();
            try (NodeValueIndexCursor cursor1 = this.indexCoordinator.queryRange(ktx);
                 NodeValueIndexCursor cursor2 = this.indexCoordinator.queryRange(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                ArrayList<Long> actual2 = new ArrayList<Long>();
                this.exhaustInterleaved(cursor1, actual1, cursor2, actual2);
                this.indexCoordinator.assertRangeResult(actual1);
                this.indexCoordinator.assertRangeResult(actual2);
            }
            tx.success();
        }
    }

    private void exhaustInterleaved(NodeValueIndexCursor source1, List<Long> target1, NodeValueIndexCursor source2, List<Long> target2) {
        boolean source1HasNext = true;
        boolean source2HasNext = true;
        while (source1HasNext && source2HasNext) {
            if (rnd.nextBoolean()) {
                source1HasNext = source1.next();
                if (!source1HasNext) continue;
                target1.add(source1.nodeReference());
                continue;
            }
            source2HasNext = source2.next();
            if (!source2HasNext) continue;
            target2.add(source2.nodeReference());
        }
        while (source1.next()) {
            target1.add(source1.nodeReference());
        }
        while (source2.next()) {
            target2.add(source2.nodeReference());
        }
    }

    private static abstract class IndexCoordinator {
        final int numberOfNodes = 100;
        final Label indexLabel;
        final String numberProp1;
        final String numberProp2;
        final String stringProp1;
        final String stringProp2;
        Number[] numberProp1Values;
        Number[] numberProp2Values;
        String[] stringProp1Values;
        String[] stringProp2Values;
        int indexedLabelId;
        int numberPropId1;
        int numberPropId2;
        int stringPropId1;
        int stringPropId2;
        SchemaIndexDescriptor indexDescriptor;

        IndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            this.indexLabel = indexLabel;
            this.numberProp1 = numberProp1;
            this.numberProp2 = numberProp2;
            this.stringProp1 = stringProp1;
            this.stringProp2 = stringProp2;
            this.numberProp1Values = new Number[100];
            this.numberProp2Values = new Number[100];
            this.stringProp1Values = new String[100];
            this.stringProp2Values = new String[100];
            for (int i = 0; i < 100; ++i) {
                this.numberProp1Values[i] = i;
                this.numberProp2Values[i] = i;
                this.stringProp1Values[i] = "string-" + String.format("%02d", i);
                this.stringProp2Values[i] = "string-" + String.format("%02d", i);
            }
        }

        void init(DatabaseRule db) {
            try (Transaction tx = db.beginTx();){
                for (int i = 0; i < 100; ++i) {
                    Node node = db.createNode(new Label[]{this.indexLabel});
                    node.setProperty(this.numberProp1, (Object)this.numberProp1Values[i]);
                    node.setProperty(this.numberProp2, (Object)this.numberProp2Values[i]);
                    node.setProperty(this.stringProp1, (Object)this.stringProp1Values[i]);
                    node.setProperty(this.stringProp2, (Object)this.stringProp2Values[i]);
                }
                tx.success();
            }
            tx = db.beginTx();
            var3_3 = null;
            try {
                TokenRead tokenRead = db.transaction().tokenRead();
                this.indexedLabelId = tokenRead.nodeLabel(this.indexLabel.name());
                this.numberPropId1 = tokenRead.propertyKey(this.numberProp1);
                this.numberPropId2 = tokenRead.propertyKey(this.numberProp2);
                this.stringPropId1 = tokenRead.propertyKey(this.stringProp1);
                this.stringPropId2 = tokenRead.propertyKey(this.stringProp2);
                tx.success();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var3_3 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            this.indexDescriptor = this.extractIndexDescriptor();
        }

        protected abstract SchemaIndexDescriptor extractIndexDescriptor();

        void createIndex(DatabaseRule db) {
            try (Transaction tx = db.beginTx();){
                this.doCreateIndex(db);
                tx.success();
            }
            tx = db.beginTx();
            var3_3 = null;
            try {
                db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.success();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var3_3 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }

        abstract boolean supportRangeQuery();

        abstract NodeValueIndexCursor queryRange(KernelTransaction var1) throws KernelException;

        abstract NodeValueIndexCursor queryExists(KernelTransaction var1) throws KernelException;

        abstract NodeValueIndexCursor queryExact(KernelTransaction var1) throws KernelException;

        abstract void assertRangeResult(List<Long> var1);

        void assertExistsResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            for (long i = 0L; i < 100L; ++i) {
                expected.add(i);
            }
            this.assertSameContent(actual, expected);
        }

        void assertSameContent(List<Long> actual, List<Long> expected) {
            Assert.assertThat(actual, (Matcher)CoreMatchers.is((Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expected.toArray())));
        }

        abstract void assertExactResult(List<Long> var1);

        abstract void doCreateIndex(DatabaseRule var1);

        NodeValueIndexCursor indexQuery(KernelTransaction ktx, SchemaIndexDescriptor indexDescriptor, IndexQuery ... indexQueries) throws KernelException {
            NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor();
            ktx.dataRead().nodeIndexSeek(DefaultIndexReference.fromDescriptor((SchemaIndexDescriptor)indexDescriptor), cursor, IndexOrder.NONE, indexQueries);
            return cursor;
        }
    }

    private static class NumberIndexCoordinator
    extends IndexCoordinator {
        NumberIndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            super(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        }

        @Override
        protected SchemaIndexDescriptor extractIndexDescriptor() {
            return SchemaIndexDescriptorFactory.forLabel((int)this.indexedLabelId, (int[])new int[]{this.numberPropId1});
        }

        @Override
        boolean supportRangeQuery() {
            return true;
        }

        @Override
        NodeValueIndexCursor queryRange(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.range((int)this.numberPropId1, (Number)this.numberProp1Values[0], (boolean)true, (Number)this.numberProp1Values[50], (boolean)false)});
        }

        @Override
        NodeValueIndexCursor queryExists(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.exists((int)this.numberPropId1)});
        }

        @Override
        NodeValueIndexCursor queryExact(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.exact((int)this.numberPropId1, (Object)this.numberProp1Values[0])});
        }

        @Override
        void assertRangeResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            for (long i = 0L; i < 50L; ++i) {
                expected.add(i);
            }
            this.assertSameContent(actual, expected);
        }

        @Override
        void assertExactResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            expected.add(0L);
            this.assertSameContent(actual, expected);
        }

        @Override
        void doCreateIndex(DatabaseRule db) {
            db.schema().indexFor(this.indexLabel).on(this.numberProp1).create();
        }
    }

    private static class StringIndexCoordinator
    extends IndexCoordinator {
        StringIndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            super(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        }

        @Override
        protected SchemaIndexDescriptor extractIndexDescriptor() {
            return SchemaIndexDescriptorFactory.forLabel((int)this.indexedLabelId, (int[])new int[]{this.stringPropId1});
        }

        @Override
        boolean supportRangeQuery() {
            return true;
        }

        @Override
        NodeValueIndexCursor queryRange(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.range((int)this.numberPropId1, (String)this.stringProp1Values[0], (boolean)true, (String)this.stringProp1Values[50], (boolean)false)});
        }

        @Override
        NodeValueIndexCursor queryExists(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.exists((int)this.stringPropId1)});
        }

        @Override
        NodeValueIndexCursor queryExact(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.exact((int)this.stringPropId1, (Object)this.stringProp1Values[0])});
        }

        @Override
        void assertRangeResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            for (long i = 0L; i < 50L; ++i) {
                expected.add(i);
            }
            this.assertSameContent(actual, expected);
        }

        @Override
        void assertExactResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            expected.add(0L);
            this.assertSameContent(actual, expected);
        }

        @Override
        void doCreateIndex(DatabaseRule db) {
            db.schema().indexFor(this.indexLabel).on(this.stringProp1).create();
        }
    }

    private static class NumberCompositeIndexCoordinator
    extends IndexCoordinator {
        NumberCompositeIndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            super(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        }

        @Override
        protected SchemaIndexDescriptor extractIndexDescriptor() {
            return SchemaIndexDescriptorFactory.forLabel((int)this.indexedLabelId, (int[])new int[]{this.numberPropId1, this.numberPropId2});
        }

        @Override
        boolean supportRangeQuery() {
            return false;
        }

        @Override
        NodeValueIndexCursor queryRange(KernelTransaction ktx) throws IndexNotApplicableKernelException, IndexNotFoundKernelException {
            throw new UnsupportedOperationException();
        }

        @Override
        NodeValueIndexCursor queryExists(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.exists((int)this.numberPropId1), IndexQuery.exists((int)this.numberPropId2)});
        }

        @Override
        NodeValueIndexCursor queryExact(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.exact((int)this.numberPropId1, (Object)this.numberProp1Values[0]), IndexQuery.exact((int)this.numberPropId2, (Object)this.numberProp2Values[0])});
        }

        @Override
        void assertRangeResult(List<Long> actual) {
            throw new UnsupportedOperationException();
        }

        @Override
        void assertExactResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            expected.add(0L);
            this.assertSameContent(actual, expected);
        }

        @Override
        void doCreateIndex(DatabaseRule db) {
            db.schema().indexFor(this.indexLabel).on(this.numberProp1).on(this.numberProp2).create();
        }
    }

    private static class StringCompositeIndexCoordinator
    extends IndexCoordinator {
        StringCompositeIndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            super(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        }

        @Override
        protected SchemaIndexDescriptor extractIndexDescriptor() {
            return SchemaIndexDescriptorFactory.forLabel((int)this.indexedLabelId, (int[])new int[]{this.stringPropId1, this.stringPropId2});
        }

        @Override
        boolean supportRangeQuery() {
            return false;
        }

        @Override
        NodeValueIndexCursor queryRange(KernelTransaction ktx) throws IndexNotApplicableKernelException, IndexNotFoundKernelException {
            throw new UnsupportedOperationException();
        }

        @Override
        NodeValueIndexCursor queryExists(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.exists((int)this.stringPropId1), IndexQuery.exists((int)this.stringPropId2)});
        }

        @Override
        NodeValueIndexCursor queryExact(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new IndexQuery[]{IndexQuery.exact((int)this.stringPropId1, (Object)this.stringProp1Values[0]), IndexQuery.exact((int)this.stringPropId2, (Object)this.stringProp2Values[0])});
        }

        @Override
        void assertRangeResult(List<Long> result) {
            throw new UnsupportedOperationException();
        }

        @Override
        void assertExactResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            expected.add(0L);
            this.assertSameContent(actual, expected);
        }

        @Override
        void doCreateIndex(DatabaseRule db) {
            db.schema().indexFor(this.indexLabel).on(this.stringProp1).on(this.stringProp2).create();
        }
    }

    private static interface IndexCoordinatorFactory {
        public IndexCoordinator create(Label var1, String var2, String var3, String var4, String var5);
    }
}

