/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.impl.api.LuceneIndexValueValidator;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.storable.Values;

public class LuceneIndexValueValidatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void tooLongArrayIsNotAllowed() {
        int length = Short.MAX_VALUE;
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"is longer than 32766"));
        this.getValidator().validate((Object)RandomUtils.nextBytes((int)length));
    }

    @Test
    public void stringOverExceedLimitNotAllowed() {
        int length = 65532;
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)(length + " is longer than " + 32766)));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)length));
    }

    @Test
    public void nullIsNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Null value");
        this.getValidator().validate(null);
    }

    @Test
    public void numberIsValidValue() {
        this.getValidator().validate((Object)5);
        this.getValidator().validate((Object)5.0);
        this.getValidator().validate((Object)Float.valueOf(5.0f));
        this.getValidator().validate((Object)5L);
    }

    @Test
    public void shortArrayIsValidValue() {
        this.getValidator().validate((Object)new long[]{1L, 2L, 3L});
        this.getValidator().validate((Object)RandomUtils.nextBytes((int)200));
    }

    @Test
    public void shortStringIsValidValue() {
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)5));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)10));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)250));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)450));
        this.getValidator().validate((Object)RandomStringUtils.randomAlphabetic((int)32766));
    }

    protected Validator<Object> getValidator() {
        return object -> LuceneIndexValueValidator.INSTANCE.validate(Values.of((Object)object));
    }
}

