/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.ExplicitIndexValueValidator;

public class ExplicitIndexValueValidatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void nullIsNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Null value");
        ExplicitIndexValueValidator.INSTANCE.validate(null);
    }

    @Test
    public void stringOverExceedLimitNotAllowed() {
        int length = 65532;
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)(length + " is longer than " + 32766)));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)length));
    }

    @Test
    public void nullToStringIsNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("has null toString");
        Object testValue = Mockito.mock(Object.class);
        Mockito.when((Object)testValue.toString()).thenReturn(null);
        ExplicitIndexValueValidator.INSTANCE.validate(testValue);
    }

    @Test
    public void numberIsValidValue() {
        ExplicitIndexValueValidator.INSTANCE.validate((Object)5);
        ExplicitIndexValueValidator.INSTANCE.validate((Object)5.0);
        ExplicitIndexValueValidator.INSTANCE.validate((Object)Float.valueOf(5.0f));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)5L);
    }

    @Test
    public void shortStringIsValidValue() {
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)5));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)10));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)250));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)450));
        ExplicitIndexValueValidator.INSTANCE.validate((Object)RandomStringUtils.randomAlphabetic((int)32766));
    }
}

