/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.ReadOnlyDatabaseSchemaIndex;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ReadOnlyLuceneSchemaIndexTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expectedException = ExpectedException.none();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.expectedException).around((TestRule)this.fileSystemRule);
    private ReadOnlyDatabaseSchemaIndex luceneSchemaIndex;

    @Before
    public void setUp() {
        PartitionedIndexStorage indexStorage = new PartitionedIndexStorage(DirectoryFactory.PERSISTENT, this.fileSystemRule.get(), this.testDirectory.directory());
        Config config = Config.defaults();
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(config);
        this.luceneSchemaIndex = new ReadOnlyDatabaseSchemaIndex(indexStorage, SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), samplingConfig, new ReadOnlyIndexPartitionFactory());
    }

    @After
    public void tearDown() throws IOException {
        this.luceneSchemaIndex.close();
    }

    @Test
    public void indexDeletionIndReadOnlyModeIsNotSupported() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.luceneSchemaIndex.drop();
    }

    @Test
    public void indexCreationInReadOnlyModeIsNotSupported() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.luceneSchemaIndex.create();
    }

    @Test
    public void readOnlyIndexMarkingIsNotSupported() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.luceneSchemaIndex.markAsOnline();
    }

    @Test
    public void readOnlyIndexMode() {
        Assert.assertTrue((boolean)this.luceneSchemaIndex.isReadOnly());
    }

    @Test
    public void writerIsNotAccessibleInReadOnlyMode() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.luceneSchemaIndex.getIndexWriter();
    }
}

