/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LuceneSchemaIndexPopulatorTest {
    @Rule
    public final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    private IndexStoreView indexStoreView;
    private LuceneIndexProvider provider;
    private Directory directory;
    private IndexPopulator indexPopulator;
    private IndexReader reader;
    private IndexSearcher searcher;
    private final long indexId = 0L;
    private static final int propertyKeyId = 666;
    private static final SchemaIndexDescriptor index = SchemaIndexDescriptorFactory.forLabel((int)42, (int[])new int[]{666});

    @Before
    public void before() throws Exception {
        this.directory = new RAMDirectory();
        DirectoryFactory.Single directoryFactory = new DirectoryFactory.Single((Directory)new DirectoryFactory.UncloseableDirectory(this.directory));
        this.provider = new LuceneIndexProvider(this.fs.get(), (DirectoryFactory)directoryFactory, LuceneIndexProvider.defaultDirectoryStructure((File)this.testDir.directory("folder")), IndexProvider.Monitor.EMPTY, Config.defaults(), OperationalMode.single);
        this.indexStoreView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        this.indexPopulator = this.provider.getPopulator(0L, index, samplingConfig);
        this.indexPopulator.create();
    }

    @After
    public void after() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
        this.directory.close();
    }

    @Test
    public void addingValuesShouldPersistThem() throws Exception {
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 1L, "First");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 2L, "Second");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 3L, (byte)1);
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 4L, (short)2);
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 5L, 3);
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 6L, 4L);
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 7L, Float.valueOf(5.0f));
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 8L, 6.0);
        this.assertIndexedValues(this.hit((Object)"First", 1L), this.hit((Object)"Second", 2L), this.hit((Object)1, 3L), this.hit((Object)2, 4L), this.hit((Object)3, 5L), this.hit((Object)4L, 6L), this.hit((Object)Float.valueOf(5.0f), 7L), this.hit((Object)6.0, 8L));
    }

    @Test
    public void multipleEqualValues() throws Exception {
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 1L, "value");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 2L, "value");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 3L, "value");
        this.assertIndexedValues(this.hit((Object)"value", 1L, 2L, 3L));
    }

    @Test
    public void multipleEqualValuesWithUpdateThatRemovesOne() throws Exception {
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 1L, "value");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 2L, "value");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 3L, "value");
        LuceneSchemaIndexPopulatorTest.updatePopulator(this.indexPopulator, Collections.singletonList(this.remove(2L, "value")), (PropertyAccessor)this.indexStoreView);
        this.assertIndexedValues(this.hit((Object)"value", 1L, 3L));
    }

    @Test
    public void changeUpdatesInterleavedWithAdds() throws Exception {
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 1L, "1");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 2L, "2");
        LuceneSchemaIndexPopulatorTest.updatePopulator(this.indexPopulator, Collections.singletonList(this.change(1L, "1", "1a")), (PropertyAccessor)this.indexStoreView);
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 3L, "3");
        this.assertIndexedValues(this.no("1"), this.hit((Object)"1a", 1L), this.hit((Object)"2", 2L), this.hit((Object)"3", 3L));
    }

    @Test
    public void addUpdatesInterleavedWithAdds() throws Exception {
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 1L, "1");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 2L, "2");
        LuceneSchemaIndexPopulatorTest.updatePopulator(this.indexPopulator, Arrays.asList(this.remove(1L, "1"), this.add(1L, "1a")), (PropertyAccessor)this.indexStoreView);
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 3L, "3");
        this.assertIndexedValues(this.hit((Object)"1a", 1L), this.hit((Object)"2", 2L), this.hit((Object)"3", 3L), this.no("1"));
    }

    @Test
    public void removeUpdatesInterleavedWithAdds() throws Exception {
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 1L, "1");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 2L, "2");
        LuceneSchemaIndexPopulatorTest.updatePopulator(this.indexPopulator, Collections.singletonList(this.remove(2L, "2")), (PropertyAccessor)this.indexStoreView);
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 3L, "3");
        this.assertIndexedValues(this.hit((Object)"1", 1L), this.no("2"), this.hit((Object)"3", 3L));
    }

    @Test
    public void multipleInterleaves() throws Exception {
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 1L, "1");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 2L, "2");
        LuceneSchemaIndexPopulatorTest.updatePopulator(this.indexPopulator, Arrays.asList(this.change(1L, "1", "1a"), this.change(2L, "2", "2a")), (PropertyAccessor)this.indexStoreView);
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 3L, "3");
        LuceneSchemaIndexPopulatorTest.addUpdate(this.indexPopulator, 4L, "4");
        LuceneSchemaIndexPopulatorTest.updatePopulator(this.indexPopulator, Arrays.asList(this.change(1L, "1a", "1b"), this.change(4L, "4", "4a")), (PropertyAccessor)this.indexStoreView);
        this.assertIndexedValues(this.no("1"), this.no("1a"), this.hit((Object)"1b", 1L), this.no("2"), this.hit((Object)"2a", 2L), this.hit((Object)"3", 3L), this.no("4"), this.hit((Object)"4a", 4L));
    }

    private Hit hit(Object value, Long ... nodeIds) {
        return new Hit(value, nodeIds);
    }

    private Hit hit(Object value, long nodeId) {
        return new Hit(value, nodeId);
    }

    private Hit no(Object value) {
        return new Hit(value, new Long[0]);
    }

    private IndexEntryUpdate<?> add(long nodeId, Object value) {
        return IndexQueryHelper.add((long)nodeId, (SchemaDescriptor)index.schema(), (Object[])new Object[]{value});
    }

    private IndexEntryUpdate<?> change(long nodeId, Object valueBefore, Object valueAfter) {
        return IndexQueryHelper.change((long)nodeId, (SchemaDescriptor)index.schema(), (Object)valueBefore, (Object)valueAfter);
    }

    private IndexEntryUpdate<?> remove(long nodeId, Object removedValue) {
        return IndexQueryHelper.remove((long)nodeId, (SchemaDescriptor)index.schema(), (Object[])new Object[]{removedValue});
    }

    private void assertIndexedValues(Hit ... expectedHits) throws IOException {
        this.switchToVerification();
        for (Hit hit : expectedHits) {
            TopDocs hits = this.searcher.search(LuceneDocumentStructure.newSeekQuery((Value[])new Value[]{hit.value}), 10);
            Assert.assertEquals((String)("Unexpected number of index results from " + hit.value), (long)hit.nodeIds.length, (long)hits.totalHits);
            HashSet<Long> foundNodeIds = new HashSet<Long>();
            for (int i = 0; i < hits.totalHits; ++i) {
                Document document = this.searcher.doc(hits.scoreDocs[i].doc);
                foundNodeIds.add(Long.parseLong(document.get("id")));
            }
            Assert.assertEquals((Object)Iterators.asSet((Object[])hit.nodeIds), foundNodeIds);
        }
    }

    private void switchToVerification() throws IOException {
        this.indexPopulator.close(true);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)this.provider.getInitialState(0L, index));
        this.reader = DirectoryReader.open((Directory)this.directory);
        this.searcher = new IndexSearcher(this.reader);
    }

    private static void addUpdate(IndexPopulator populator, long nodeId, Object value) throws IOException, IndexEntryConflictException {
        populator.add(Collections.singletonList(IndexQueryHelper.add((long)nodeId, (SchemaDescriptor)index.schema(), (Object[])new Object[]{value})));
    }

    private static void updatePopulator(IndexPopulator populator, Iterable<IndexEntryUpdate<?>> updates, PropertyAccessor accessor) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = populator.newPopulatingUpdater(accessor);){
            for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
        }
    }

    private static class Hit {
        private final Value value;
        private final Long[] nodeIds;

        Hit(Object value, Long ... nodeIds) {
            this.value = Values.of((Object)value);
            this.nodeIds = nodeIds;
        }
    }
}

