/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.index.CorruptIndexException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LuceneSchemaIndexCorruptionTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final IndexProvider.Monitor monitor = new LoggingMonitor(this.logProvider.getLog("test"));

    @Test
    public void shouldRequestIndexPopulationIfTheIndexIsCorrupt() {
        long faultyIndexId = 1L;
        CorruptIndexException error = new CorruptIndexException("It's broken.", "");
        LuceneIndexProvider provider = this.newFaultyIndexProvider(faultyIndexId, (Exception)error);
        SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        InternalIndexState initialState = provider.getInitialState(faultyIndexId, descriptor);
        Assert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException((Throwable)error)});
    }

    @Test
    public void shouldRequestIndexPopulationFailingWithFileNotFoundException() {
        long faultyIndexId = 1L;
        FileNotFoundException error = new FileNotFoundException("/some/path/somewhere");
        LuceneIndexProvider provider = this.newFaultyIndexProvider(faultyIndexId, error);
        SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        InternalIndexState initialState = provider.getInitialState(faultyIndexId, descriptor);
        Assert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException(error)});
    }

    @Test
    public void shouldRequestIndexPopulationWhenFailingWithEOFException() {
        long faultyIndexId = 1L;
        EOFException error = new EOFException("/some/path/somewhere");
        LuceneIndexProvider provider = this.newFaultyIndexProvider(faultyIndexId, error);
        SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        InternalIndexState initialState = provider.getInitialState(faultyIndexId, descriptor);
        Assert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException(error)});
    }

    private LuceneIndexProvider newFaultyIndexProvider(final long faultyIndexId, final Exception error) {
        DirectoryFactory directoryFactory = (DirectoryFactory)Mockito.mock(DirectoryFactory.class);
        File indexRootFolder = this.testDirectory.graphDbDir();
        final AtomicReference reference = new AtomicReference();
        return new LuceneIndexProvider(this.fs.get(), directoryFactory, LuceneIndexProvider.defaultDirectoryStructure((File)indexRootFolder), this.monitor, Config.defaults(), OperationalMode.single){

            protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
                FaultyIndexStorageFactory storageFactory = new FaultyIndexStorageFactory(faultyIndexId, error, directoryFactory, this.directoryStructure());
                reference.set(storageFactory);
                return storageFactory;
            }
        };
    }

    private static AssertableLogProvider.LogMatcher loggedException(Throwable exception) {
        return AssertableLogProvider.inLog((Matcher)CoreMatchers.any(String.class)).error(CoreMatchers.any(String.class), CoreMatchers.sameInstance((Object)exception));
    }

    private class FaultyIndexStorageFactory
    extends IndexStorageFactory {
        final long faultyIndexId;
        final Exception error;

        FaultyIndexStorageFactory(long faultyIndexId, Exception error, DirectoryFactory directoryFactory, IndexDirectoryStructure directoryStructure) {
            super(directoryFactory, LuceneSchemaIndexCorruptionTest.this.fs.get(), directoryStructure);
            this.faultyIndexId = faultyIndexId;
            this.error = error;
        }

        public PartitionedIndexStorage indexStorageOf(long indexId) {
            return indexId == this.faultyIndexId ? this.newFaultyPartitionedIndexStorage() : super.indexStorageOf(indexId);
        }

        PartitionedIndexStorage newFaultyPartitionedIndexStorage() {
            try {
                PartitionedIndexStorage storage = (PartitionedIndexStorage)Mockito.mock(PartitionedIndexStorage.class);
                Mockito.when((Object)storage.listFolders()).thenReturn(Collections.singletonList(new File("/some/path/somewhere/1")));
                Mockito.when((Object)storage.openDirectory((File)ArgumentMatchers.any())).thenThrow(new Throwable[]{this.error});
                return storage;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

