/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneSchemaIndexBuilderTest {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});

    @Test
    public void readOnlyIndexCreation() throws Exception {
        try (SchemaIndex schemaIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((SchemaIndexDescriptor)this.descriptor, (Config)this.getReadOnlyConfig()).withFileSystem(this.fileSystemRule.get())).withOperationalMode(OperationalMode.single)).withIndexRootFolder(this.testDir.directory("a"))).build();){
            Assert.assertTrue((String)"Builder should construct read only index.", (boolean)schemaIndex.isReadOnly());
        }
    }

    @Test
    public void writableIndexCreation() throws Exception {
        try (SchemaIndex schemaIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((SchemaIndexDescriptor)this.descriptor, (Config)this.getDefaultConfig()).withFileSystem(this.fileSystemRule.get())).withOperationalMode(OperationalMode.single)).withIndexRootFolder(this.testDir.directory("b"))).build();){
            Assert.assertFalse((String)"Builder should construct writable index.", (boolean)schemaIndex.isReadOnly());
        }
    }

    private Config getDefaultConfig() {
        return Config.defaults();
    }

    private Config getReadOnlyConfig() {
        return Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
    }
}

