/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneIndexProviderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory(this.getClass());
    private File graphDbDir;
    private FileSystemAbstraction fs;
    private static final SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});

    @Before
    public void setup() {
        this.fs = this.fileSystemRule.get();
        this.graphDbDir = this.testDir.graphDbDir();
    }

    @Test
    public void shouldFailToInvokePopulatorInReadOnlyMode() {
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
        LuceneIndexProvider readOnlyIndexProvider = this.getLuceneIndexProvider(readOnlyConfig, (DirectoryFactory)new DirectoryFactory.InMemoryDirectoryFactory(), this.fs, this.graphDbDir);
        this.expectedException.expect(UnsupportedOperationException.class);
        readOnlyIndexProvider.getPopulator(1L, descriptor, new IndexSamplingConfig(readOnlyConfig));
    }

    @Test
    public void shouldCreateReadOnlyAccessorInReadOnlyMode() throws Exception {
        DirectoryFactory directoryFactory = DirectoryFactory.PERSISTENT;
        this.createEmptySchemaIndex(directoryFactory);
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
        LuceneIndexProvider readOnlyIndexProvider = this.getLuceneIndexProvider(readOnlyConfig, directoryFactory, this.fs, this.graphDbDir);
        IndexAccessor onlineAccessor = this.getIndexAccessor(readOnlyConfig, readOnlyIndexProvider);
        this.expectedException.expect(UnsupportedOperationException.class);
        onlineAccessor.drop();
    }

    @Test
    public void indexUpdateNotAllowedInReadOnlyMode() throws Exception {
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
        LuceneIndexProvider readOnlyIndexProvider = this.getLuceneIndexProvider(readOnlyConfig, (DirectoryFactory)new DirectoryFactory.InMemoryDirectoryFactory(), this.fs, this.graphDbDir);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.getIndexAccessor(readOnlyConfig, readOnlyIndexProvider).newUpdater(IndexUpdateMode.ONLINE);
    }

    @Test
    public void indexForceMustBeAllowedInReadOnlyMode() throws Exception {
        Config readOnlyConfig = Config.defaults((Setting)GraphDatabaseSettings.read_only, (String)"true");
        LuceneIndexProvider readOnlyIndexProvider = this.getLuceneIndexProvider(readOnlyConfig, (DirectoryFactory)new DirectoryFactory.InMemoryDirectoryFactory(), this.fs, this.graphDbDir);
        this.getIndexAccessor(readOnlyConfig, readOnlyIndexProvider).force(IOLimiter.unlimited());
    }

    private void createEmptySchemaIndex(DirectoryFactory directoryFactory) throws IOException {
        Config config = Config.defaults();
        LuceneIndexProvider indexProvider = this.getLuceneIndexProvider(config, directoryFactory, this.fs, this.graphDbDir);
        IndexAccessor onlineAccessor = this.getIndexAccessor(config, indexProvider);
        onlineAccessor.close();
    }

    private IndexAccessor getIndexAccessor(Config readOnlyConfig, LuceneIndexProvider indexProvider) throws IOException {
        return indexProvider.getOnlineAccessor(1L, descriptor, new IndexSamplingConfig(readOnlyConfig));
    }

    private LuceneIndexProvider getLuceneIndexProvider(Config config, DirectoryFactory directoryFactory, FileSystemAbstraction fs, File graphDbDir) {
        return new LuceneIndexProvider(fs, directoryFactory, LuceneIndexProvider.defaultDirectoryStructure((File)graphDbDir), IndexProvider.Monitor.EMPTY, config, OperationalMode.single);
    }
}

