/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.api.impl.LuceneTestUtil;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.ValueEncoding;

public class LuceneDocumentStructureTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void stringWithMaximumLengthShouldBeAllowed() {
        String longestString = RandomStringUtils.randomAscii((int)32766);
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, longestString);
        Assert.assertEquals((Object)longestString, (Object)document.getField(ValueEncoding.String.key(0)).stringValue());
    }

    @Test
    public void shouldBuildDocumentRepresentingStringProperty() {
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, "hello");
        Assert.assertEquals((Object)"123", (Object)document.get("id"));
        Assert.assertEquals((Object)"hello", (Object)document.get(ValueEncoding.String.key(0)));
    }

    @Test
    public void shouldBuildDocumentRepresentingMultipleStringProperties() {
        Object[] values = new String[]{"hello", "world"};
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, values);
        Assert.assertEquals((Object)"123", (Object)document.get("id"));
        Assert.assertThat((Object)document.get(ValueEncoding.String.key(0)), (Matcher)CoreMatchers.equalTo((Object)values[0]));
        Assert.assertThat((Object)document.get(ValueEncoding.String.key(1)), (Matcher)CoreMatchers.equalTo((Object)values[1]));
    }

    @Test
    public void shouldBuildDocumentRepresentingMultiplePropertiesOfDifferentTypes() {
        Object[] values = new Object[]{"hello", 789};
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, values);
        Assert.assertEquals((Object)"123", (Object)document.get("id"));
        Assert.assertThat((Object)document.get(ValueEncoding.String.key(0)), (Matcher)CoreMatchers.equalTo((Object)"hello"));
        Assert.assertThat((Object)document.get(ValueEncoding.Number.key(1)), (Matcher)CoreMatchers.equalTo((Object)"789.0"));
    }

    @Test
    public void shouldBuildDocumentRepresentingBoolProperty() {
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, true);
        Assert.assertEquals((Object)"123", (Object)document.get("id"));
        Assert.assertEquals((Object)"true", (Object)document.get(ValueEncoding.Bool.key(0)));
    }

    @Test
    public void shouldBuildDocumentRepresentingNumberProperty() {
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, 12);
        Assert.assertEquals((Object)"123", (Object)document.get("id"));
        Assert.assertEquals((double)12.0, (double)document.getField(ValueEncoding.Number.key(0)).numericValue().doubleValue(), (double)0.001);
    }

    @Test
    public void shouldBuildDocumentRepresentingArrayProperty() {
        Document document = LuceneTestUtil.documentRepresentingProperties(123L, new Object[]{new Integer[]{1, 2, 3}});
        Assert.assertEquals((Object)"123", (Object)document.get("id"));
        Assert.assertEquals((Object)"D1.0|2.0|3.0|", (Object)document.get(ValueEncoding.Array.key(0)));
    }

    @Test
    public void shouldBuildQueryRepresentingBoolProperty() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery(true);
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery query = (TermQuery)constantScoreQuery.getQuery();
        Assert.assertEquals((Object)"true", (Object)query.getTerm().text());
    }

    @Test
    public void shouldBuildQueryRepresentingStringProperty() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery("Characters");
        ConstantScoreQuery query = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        Assert.assertEquals((Object)"Characters", (Object)((TermQuery)query.getQuery()).getTerm().text());
    }

    @Test
    public void shouldBuildQueryRepresentingNumberProperty() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery(12);
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        NumericRangeQuery query = (NumericRangeQuery)constantScoreQuery.getQuery();
        Assert.assertEquals((double)12.0, (double)((Double)query.getMin()), (double)0.001);
        Assert.assertEquals((double)12.0, (double)((Double)query.getMax()), (double)0.001);
    }

    @Test
    public void shouldBuildQueryRepresentingArrayProperty() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery(new Object[]{new Integer[]{1, 2, 3}});
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery query = (TermQuery)constantScoreQuery.getQuery();
        Assert.assertEquals((Object)"D1.0|2.0|3.0|", (Object)query.getTerm().text());
    }

    @Test
    public void shouldBuildQueryRepresentingMultipleProperties() {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneTestUtil.newSeekQuery(true, "Characters", 12, new Integer[]{1, 2, 3});
        ConstantScoreQuery boolScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery boolTermQuery = (TermQuery)boolScoreQuery.getQuery();
        ConstantScoreQuery stringScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(1)).getQuery();
        TermQuery stringTermQuery = (TermQuery)stringScoreQuery.getQuery();
        ConstantScoreQuery numberScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(2)).getQuery();
        NumericRangeQuery numericRangeQuery = (NumericRangeQuery)numberScoreQuery.getQuery();
        ConstantScoreQuery arrayScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(3)).getQuery();
        TermQuery arrayTermQuery = (TermQuery)arrayScoreQuery.getQuery();
        Assert.assertEquals((Object)"true", (Object)boolTermQuery.getTerm().text());
        Assert.assertEquals((Object)"Characters", (Object)stringTermQuery.getTerm().text());
        Assert.assertEquals((double)12.0, (double)((Double)numericRangeQuery.getMin()), (double)0.001);
        Assert.assertEquals((double)12.0, (double)((Double)numericRangeQuery.getMax()), (double)0.001);
        Assert.assertEquals((Object)"D1.0|2.0|3.0|", (Object)arrayTermQuery.getTerm().text());
    }

    @Test
    public void shouldBuildRangeSeekByNumberQueryForStrings() {
        NumericRangeQuery query = LuceneDocumentStructure.newInclusiveNumericRangeSeekQuery((Number)12.0, null);
        Assert.assertEquals((Object)"number", (Object)query.getField());
        Assert.assertEquals((double)12.0, (double)((Double)query.getMin()), (double)0.001);
        Assert.assertEquals((Object)true, (Object)query.includesMin());
        Assert.assertEquals(null, (Object)query.getMax());
        Assert.assertEquals((Object)true, (Object)query.includesMax());
    }

    @Test
    public void shouldBuildRangeSeekByStringQueryForStrings() {
        TermRangeQuery query = (TermRangeQuery)LuceneDocumentStructure.newRangeSeekByStringQuery((String)"foo", (boolean)false, null, (boolean)true);
        Assert.assertEquals((Object)"string", (Object)query.getField());
        Assert.assertEquals((Object)"foo", (Object)query.getLowerTerm().utf8ToString());
        Assert.assertEquals((Object)false, (Object)query.includesLower());
        Assert.assertEquals(null, (Object)query.getUpperTerm());
        Assert.assertEquals((Object)true, (Object)query.includesUpper());
    }

    @Test
    public void shouldBuildWildcardQueries() {
        WildcardQuery query = (WildcardQuery)LuceneDocumentStructure.newWildCardStringQuery((String)"foo");
        Assert.assertEquals((Object)"string", (Object)query.getField());
    }

    @Test
    public void shouldBuildRangeSeekByPrefixQueryForStrings() {
        MultiTermQuery prefixQuery = (MultiTermQuery)LuceneDocumentStructure.newRangeSeekByPrefixQuery((String)"Prefix");
        Assert.assertThat((String)"Should contain term value", (Object)prefixQuery.toString(), (Matcher)Matchers.containsString((String)"Prefix"));
    }

    @Test
    public void checkFieldUsageForUniquenessVerification() {
        Assert.assertFalse((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"id"));
        Assert.assertFalse((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"1number"));
        Assert.assertTrue((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"number"));
        Assert.assertFalse((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"1string"));
        Assert.assertFalse((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"10string"));
        Assert.assertTrue((boolean)LuceneDocumentStructure.useFieldForUniquenessVerification((String)"string"));
    }
}

