/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory10;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;

public class DefaultSchemaIndexConfigTest {
    private static final String KEY = "key";
    private static final TestLabels LABEL = TestLabels.LABEL_ONE;
    private static final GraphDatabaseBuilder dbBuilder = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder();

    @Test
    public void shouldUseConfiguredIndexProviderNull() throws IndexNotFoundKernelException {
        GraphDatabaseService db = dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, null).newGraphDatabase();
        this.createIndex(db);
        this.assertIndexProvider(db, NativeLuceneFusionIndexProviderFactory20.DESCRIPTOR);
    }

    @Test
    public void shouldUseConfiguredIndexProviderLucene() throws IndexNotFoundKernelException {
        GraphDatabaseService db = dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.LUCENE10.providerName()).newGraphDatabase();
        this.createIndex(db);
        this.assertIndexProvider(db, LuceneIndexProviderFactory.PROVIDER_DESCRIPTOR);
    }

    @Test
    public void shouldUseConfiguredIndexProviderNative10() throws IndexNotFoundKernelException {
        GraphDatabaseService db = dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE10.providerName()).newGraphDatabase();
        this.createIndex(db);
        this.assertIndexProvider(db, NativeLuceneFusionIndexProviderFactory10.DESCRIPTOR);
    }

    @Test
    public void shouldUseConfiguredIndexProviderNative20() throws IndexNotFoundKernelException {
        GraphDatabaseService db = dbBuilder.setConfig(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName()).newGraphDatabase();
        this.createIndex(db);
        this.assertIndexProvider(db, NativeLuceneFusionIndexProviderFactory20.DESCRIPTOR);
    }

    private void assertIndexProvider(GraphDatabaseService db, IndexProvider.Descriptor expected) throws IndexNotFoundKernelException {
        GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)db;
        try (Transaction tx = graphDatabaseAPI.beginTx();){
            KernelTransaction ktx = ((ThreadToStatementContextBridge)graphDatabaseAPI.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            TokenRead tokenRead = ktx.tokenRead();
            int labelId = tokenRead.nodeLabel(LABEL.name());
            int propertyId = tokenRead.propertyKey(KEY);
            CapableIndexReference index = ktx.schemaRead().index(labelId, new int[]{propertyId});
            Assert.assertEquals((String)"expected IndexProvider.Descriptor", (Object)expected, (Object)new IndexProvider.Descriptor(index.providerKey(), index.providerVersion()));
            tx.success();
        }
    }

    private void createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor((Label)LABEL).on(KEY).create();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

