/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.values.storable.Value;

public class AllNodesCollector
extends SimpleCollector {
    private final List<Long> nodeIds = new ArrayList<Long>();
    private LeafReader reader;

    public static List<Long> getAllNodes(Directory directory, Value propertyValue) throws IOException {
        try (SearcherManager manager = new SearcherManager(directory, new SearcherFactory());){
            IndexSearcher searcher = (IndexSearcher)manager.acquire();
            Query query = LuceneDocumentStructure.newSeekQuery((Value[])new Value[]{propertyValue});
            AllNodesCollector collector = new AllNodesCollector();
            searcher.search(query, (Collector)collector);
            List<Long> list = collector.nodeIds;
            return list;
        }
    }

    public void collect(int doc) throws IOException {
        this.nodeIds.add(LuceneDocumentStructure.getNodeId((Document)this.reader.document(doc)));
    }

    public boolean needsScores() {
        return false;
    }

    protected void doSetNextReader(LeafReaderContext context) {
        this.reader = context.reader();
    }
}

