/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage.layout;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;

public class IndexFolderLayoutTest {
    private final File indexRoot = new File("indexRoot");

    @Test
    public void testIndexFolder() {
        IndexFolderLayout indexLayout = this.createTestIndex();
        File indexFolder = indexLayout.getIndexFolder();
        Assert.assertEquals((Object)this.indexRoot, (Object)indexFolder);
    }

    @Test
    public void testIndexPartitionFolder() {
        IndexFolderLayout indexLayout = this.createTestIndex();
        File indexFolder = indexLayout.getIndexFolder();
        File partitionFolder1 = indexLayout.getPartitionFolder(1);
        File partitionFolder3 = indexLayout.getPartitionFolder(3);
        Assert.assertEquals((Object)partitionFolder1.getParentFile(), (Object)partitionFolder3.getParentFile());
        Assert.assertEquals((Object)indexFolder, (Object)partitionFolder1.getParentFile());
        Assert.assertEquals((Object)"1", (Object)partitionFolder1.getName());
        Assert.assertEquals((Object)"3", (Object)partitionFolder3.getName());
    }

    private IndexFolderLayout createTestIndex() {
        return new IndexFolderLayout(this.indexRoot);
    }
}

