/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.FailureStorage;
import org.neo4j.kernel.api.impl.index.storage.layout.FolderLayout;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class FailureStorageTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private IndexFolderLayout indexFolderLayout;

    @Before
    public void before() {
        File rootDirectory = new File("dir");
        ((EphemeralFileSystemAbstraction)this.fs.get()).mkdirs(rootDirectory);
        this.indexFolderLayout = new IndexFolderLayout(rootDirectory);
    }

    @Test
    public void shouldReserveFailureFile() throws Exception {
        FailureStorage storage = new FailureStorage(this.fs.get(), (FolderLayout)this.indexFolderLayout);
        storage.reserveForIndex();
        File failureFile = storage.failureFile();
        Assert.assertTrue((boolean)((EphemeralFileSystemAbstraction)this.fs.get()).fileExists(failureFile));
        Assert.assertTrue((((EphemeralFileSystemAbstraction)this.fs.get()).getFileSize(failureFile) > 100L ? 1 : 0) != 0);
    }

    @Test
    public void shouldStoreFailure() throws Exception {
        FailureStorage storage = new FailureStorage(this.fs.get(), (FolderLayout)this.indexFolderLayout);
        storage.reserveForIndex();
        String failure = String.format("A failure message%nspanning%nmultiple lines.", new Object[0]);
        storage.storeIndexFailure(failure);
        File failureFile = storage.failureFile();
        Assert.assertTrue((boolean)((EphemeralFileSystemAbstraction)this.fs.get()).fileExists(failureFile));
        Assert.assertTrue((((EphemeralFileSystemAbstraction)this.fs.get()).getFileSize(failureFile) > 100L ? 1 : 0) != 0);
        Assert.assertEquals((Object)failure, (Object)storage.loadIndexFailure());
    }

    @Test
    public void shouldClearFailure() throws Exception {
        FailureStorage storage = new FailureStorage(this.fs.get(), (FolderLayout)this.indexFolderLayout);
        storage.reserveForIndex();
        String failure = String.format("A failure message%nspanning%nmultiple lines.", new Object[0]);
        storage.storeIndexFailure(failure);
        File failureFile = storage.failureFile();
        Assert.assertTrue((boolean)((EphemeralFileSystemAbstraction)this.fs.get()).fileExists(failureFile));
        Assert.assertTrue((((EphemeralFileSystemAbstraction)this.fs.get()).getFileSize(failureFile) > 100L ? 1 : 0) != 0);
        storage.clearForIndex();
        Assert.assertFalse((boolean)((EphemeralFileSystemAbstraction)this.fs.get()).fileExists(failureFile));
    }

    @Test
    public void shouldAppendFailureIfAlreadyExists() throws Exception {
        FailureStorage storage = new FailureStorage(this.fs.get(), (FolderLayout)this.indexFolderLayout);
        storage.reserveForIndex();
        String failure1 = "Once upon a time there was a first failure";
        String failure2 = "Then there was another";
        storage.storeIndexFailure(failure1);
        storage.storeIndexFailure(failure2);
        String allFailures = storage.loadIndexFailure();
        Assert.assertThat((Object)allFailures, (Matcher)CoreMatchers.containsString((String)failure1));
        Assert.assertThat((Object)allFailures, (Matcher)CoreMatchers.containsString((String)failure2));
    }
}

