/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.sampler;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.impl.index.sampler.AggregatingIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class AggregatingIndexSamplerTest {
    @Test
    public void samplePartitionedIndex() {
        List<IndexSampler> samplers = Arrays.asList(this.createSampler(1L), this.createSampler(2L));
        AggregatingIndexSampler partitionedSampler = new AggregatingIndexSampler(samplers);
        IndexSample sample = partitionedSampler.sampleIndex();
        Assert.assertEquals((Object)new IndexSample(3L, 3L, 6L), (Object)sample);
    }

    private IndexSampler createSampler(long value) {
        return new TestIndexSampler(value);
    }

    private static class TestIndexSampler
    implements IndexSampler {
        private final long value;

        TestIndexSampler(long value) {
            this.value = value;
        }

        public IndexSample sampleIndex() {
            return new IndexSample(this.value, this.value, this.value * 2L);
        }
    }
}

