/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.collector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.kernel.api.impl.index.IndexReaderStub;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;

public final class DocValuesCollectorTest {
    @Test
    public void shouldStartWithEmptyMatchingDocs() {
        DocValuesCollector collector = new DocValuesCollector();
        Assert.assertEquals(Collections.emptyList(), (Object)collector.getMatchingDocs());
    }

    @Test
    public void shouldCollectAllHitsPerSegment() throws Exception {
        DocValuesCollector collector = new DocValuesCollector();
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(3);
        collector.collect(5);
        collector.collect(9);
        Assert.assertEquals((long)4L, (long)collector.getTotalHits());
        List allMatchingDocs = collector.getMatchingDocs();
        Assert.assertEquals((long)1L, (long)allMatchingDocs.size());
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)allMatchingDocs.get(0);
        Assert.assertSame((Object)readerStub.getContext(), (Object)matchingDocs.context);
        Assert.assertEquals((long)4L, (long)matchingDocs.totalHits);
        DocIdSetIterator idIterator = matchingDocs.docIdSet.iterator();
        Assert.assertEquals((long)1L, (long)idIterator.nextDoc());
        Assert.assertEquals((long)3L, (long)idIterator.nextDoc());
        Assert.assertEquals((long)5L, (long)idIterator.nextDoc());
        Assert.assertEquals((long)9L, (long)idIterator.nextDoc());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)idIterator.nextDoc());
    }

    @Test
    public void shouldCollectOneMatchingDocsPerSegment() throws Exception {
        DocValuesCollector collector = new DocValuesCollector();
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(3);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(5);
        collector.collect(9);
        Assert.assertEquals((long)4L, (long)collector.getTotalHits());
        List allMatchingDocs = collector.getMatchingDocs();
        Assert.assertEquals((long)2L, (long)allMatchingDocs.size());
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)allMatchingDocs.get(0);
        Assert.assertSame((Object)readerStub.getContext(), (Object)matchingDocs.context);
        Assert.assertEquals((long)2L, (long)matchingDocs.totalHits);
        DocIdSetIterator idIterator = matchingDocs.docIdSet.iterator();
        Assert.assertEquals((long)1L, (long)idIterator.nextDoc());
        Assert.assertEquals((long)3L, (long)idIterator.nextDoc());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)idIterator.nextDoc());
        matchingDocs = (DocValuesCollector.MatchingDocs)allMatchingDocs.get(1);
        Assert.assertSame((Object)readerStub.getContext(), (Object)matchingDocs.context);
        Assert.assertEquals((long)2L, (long)matchingDocs.totalHits);
        idIterator = matchingDocs.docIdSet.iterator();
        Assert.assertEquals((long)5L, (long)idIterator.nextDoc());
        Assert.assertEquals((long)9L, (long)idIterator.nextDoc());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)idIterator.nextDoc());
    }

    @Test
    public void shouldNotSaveScoresWhenNotRequired() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)collector.getMatchingDocs().get(0);
        Assert.assertNull((Object)matchingDocs.scores);
    }

    @Test
    public void shouldSaveScoresWhenRequired() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(this.constantScorer(13.42f));
        collector.collect(1);
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)collector.getMatchingDocs().get(0);
        Assert.assertArrayEquals((float[])new float[]{13.42f}, (float[])matchingDocs.scores, (float)0.0f);
    }

    @Test
    public void shouldSaveScoresInADenseArray() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(this.constantScorer(1.0f));
        collector.collect(1);
        collector.setScorer(this.constantScorer(41.0f));
        collector.collect(41);
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)collector.getMatchingDocs().get(0);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 41.0f}, (float[])matchingDocs.scores, (float)0.0f);
    }

    @Test
    public void shouldDynamicallyResizeScoresArray() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(this.constantScorer(1.0f));
        for (int i = 0; i < 42; ++i) {
            collector.collect(i);
        }
        DocValuesCollector.MatchingDocs matchingDocs = (DocValuesCollector.MatchingDocs)collector.getMatchingDocs().get(0);
        float[] scores = new float[42];
        Arrays.fill(scores, 1.0f);
        Assert.assertArrayEquals((float[])scores, (float[])matchingDocs.scores, (float)0.0f);
    }

    @Test
    public void shouldReturnIndexHitsInIndexOrderWhenNoSortIsGiven() throws Exception {
        DocValuesCollector collector = new DocValuesCollector();
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(2);
        IndexHits indexHits = collector.getIndexHits(null);
        Assert.assertEquals((long)2L, (long)indexHits.size());
        Assert.assertEquals((Object)"1", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertEquals((Object)"2", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    public void shouldReturnIndexHitsOrderedByRelevance() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(this.constantScorer(1.0f));
        collector.collect(1);
        collector.setScorer(this.constantScorer(2.0f));
        collector.collect(2);
        IndexHits indexHits = collector.getIndexHits(Sort.RELEVANCE);
        Assert.assertEquals((long)2L, (long)indexHits.size());
        Assert.assertEquals((Object)"2", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertEquals((float)2.0f, (float)indexHits.currentScore(), (float)0.0f);
        Assert.assertEquals((Object)"1", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertEquals((float)1.0f, (float)indexHits.currentScore(), (float)0.0f);
        Assert.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    public void shouldReturnIndexHitsInGivenSortOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(43);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(3);
        collector.collect(37);
        collector.collect(42);
        Sort byIdDescending = new Sort(new SortField("id", SortField.Type.LONG, true));
        IndexHits indexHits = collector.getIndexHits(byIdDescending);
        Assert.assertEquals((long)4L, (long)indexHits.size());
        Assert.assertEquals((Object)"42", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertEquals((Object)"37", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertEquals((Object)"3", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertEquals((Object)"1", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    public void shouldSilentlyMergeAllSegments() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(2);
        IndexHits indexHits = collector.getIndexHits(null);
        Assert.assertEquals((long)2L, (long)indexHits.size());
        Assert.assertEquals((Object)"1", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertEquals((Object)"2", (Object)((Document)indexHits.next()).get("id"));
        Assert.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    public void shouldReturnEmptyIteratorWhenNoHits() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        IndexHits indexHits = collector.getIndexHits(null);
        Assert.assertEquals((long)0L, (long)indexHits.size());
        Assert.assertEquals((float)Float.NaN, (float)indexHits.currentScore(), (float)0.0f);
        Assert.assertFalse((boolean)indexHits.hasNext());
    }

    @Test
    public void shouldReadDocValuesInIndexOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(2);
        DocValuesCollector.LongValuesIterator valuesIterator = collector.getValuesIterator("id");
        Assert.assertEquals((long)2L, (long)valuesIterator.remaining());
        Assert.assertEquals((long)1L, (long)valuesIterator.next());
        Assert.assertEquals((long)2L, (long)valuesIterator.next());
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    public void shouldSilentlyMergeSegmentsWhenReadingDocValues() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(2);
        DocValuesCollector.LongValuesIterator valuesIterator = collector.getValuesIterator("id");
        Assert.assertEquals((long)2L, (long)valuesIterator.remaining());
        Assert.assertEquals((long)1L, (long)valuesIterator.next());
        Assert.assertEquals((long)2L, (long)valuesIterator.next());
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    public void shouldReturnEmptyIteratorWhenNoDocValues() {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        DocValuesCollector.LongValuesIterator valuesIterator = collector.getValuesIterator("id");
        Assert.assertEquals((long)0L, (long)valuesIterator.remaining());
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    public void shouldReturnDocValuesInIndexOrderWhenNoSortIsGiven() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(2);
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", null);
        Assert.assertEquals((long)1L, (long)valuesIterator.next());
        Assert.assertEquals((long)2L, (long)valuesIterator.next());
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    public void shouldReturnDocValuesInRelevanceOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(this.constantScorer(1.0f));
        collector.collect(1);
        collector.setScorer(this.constantScorer(2.0f));
        collector.collect(2);
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", Sort.RELEVANCE);
        Assert.assertEquals((long)2L, (long)valuesIterator.next());
        Assert.assertEquals((long)1L, (long)valuesIterator.next());
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    public void shouldReturnDocValuesInGivenOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.collect(1);
        collector.collect(2);
        Sort byIdDescending = new Sort(new SortField("id", SortField.Type.LONG, true));
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", byIdDescending);
        Assert.assertEquals((long)2L, (long)valuesIterator.next());
        Assert.assertEquals((long)1L, (long)valuesIterator.next());
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    public void shouldSilentlyMergeSegmentsWhenReturnDocValuesInOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(true);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(this.constantScorer(1.0f));
        collector.collect(1);
        collector.doSetNextReader(readerStub.getContext());
        collector.setScorer(this.constantScorer(2.0f));
        collector.collect(2);
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", Sort.RELEVANCE);
        Assert.assertEquals((long)2L, (long)valuesIterator.next());
        Assert.assertEquals((long)1L, (long)valuesIterator.next());
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    public void shouldReturnEmptyIteratorWhenNoDocValuesInOrder() throws Exception {
        DocValuesCollector collector = new DocValuesCollector(false);
        IndexReaderStub readerStub = this.indexReaderWithMaxDocs(42);
        collector.doSetNextReader(readerStub.getContext());
        ValuesIterator valuesIterator = collector.getSortedValuesIterator("id", Sort.RELEVANCE);
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    private IndexReaderStub indexReaderWithMaxDocs(int maxDocs) {
        NumericDocValues identityValues = new NumericDocValues(){

            public long get(int docID) {
                return docID;
            }
        };
        IndexReaderStub stub = new IndexReaderStub(identityValues);
        stub.setElements(new String[maxDocs]);
        return stub;
    }

    private Scorer constantScorer(float score) {
        return new ConstantScoreScorer(null, score, (DocIdSetIterator)null);
    }
}

