/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriterConfig;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Factory;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Strings;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.TestPropertyAccessor;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LuceneSchemaIndexUniquenessVerificationIT {
    private static final int DOCS_PER_PARTITION = ThreadLocalRandom.current().nextInt(10, 100);
    private static final int PROPERTY_KEY_ID = 42;
    private static final SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{42});
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final int nodesToCreate = DOCS_PER_PARTITION * 2 + 1;
    private SchemaIndex index;
    private static final long MAX_LONG_VALUE = 0x1FFFFFFFFFFFFFL;
    private static final long MIN_LONG_VALUE = 9007199254740971L;

    @Before
    public void setPartitionSize() throws Exception {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", String.valueOf(DOCS_PER_PARTITION));
        TestConfigFactory configFactory = new TestConfigFactory();
        this.index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((SchemaIndexDescriptor)descriptor, (Config)Config.defaults()).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(new File(this.testDir.directory("uniquenessVerification"), "index"))).withWriterConfig((Factory)configFactory).withDirectoryFactory(DirectoryFactory.PERSISTENT)).build();
        this.index.create();
        this.index.open();
    }

    @After
    public void resetPartitionSize() throws IOException {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "");
        IOUtils.closeAll((AutoCloseable[])new SchemaIndex[]{this.index});
    }

    @Test
    public void stringValuesWithoutDuplicates() throws IOException {
        Set<Value> data = this.randomStrings();
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void stringValuesWithDuplicates() throws IOException {
        List<Value> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomStrings());
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void smallLongValuesWithoutDuplicates() throws IOException {
        long min = LuceneSchemaIndexUniquenessVerificationIT.randomLongInRange(100L, 10000L);
        long max = min + (long)this.nodesToCreate;
        Set<Value> data = this.randomLongs(min, max);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void smallLongValuesWithDuplicates() throws IOException {
        long min = LuceneSchemaIndexUniquenessVerificationIT.randomLongInRange(100L, 10000L);
        long max = min + (long)this.nodesToCreate;
        List<Value> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomLongs(min, max));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void largeLongValuesWithoutDuplicates() throws IOException {
        long max = LuceneSchemaIndexUniquenessVerificationIT.randomLongInRange(9007199254740971L, 0x1FFFFFFFFFFFFFL);
        long min = max - (long)this.nodesToCreate;
        Set<Value> data = this.randomLongs(min, max);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void largeLongValuesWithDuplicates() throws IOException {
        long max = LuceneSchemaIndexUniquenessVerificationIT.randomLongInRange(9007199254740971L, 0x1FFFFFFFFFFFFFL);
        long min = max - (long)this.nodesToCreate;
        List<Value> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomLongs(min, max));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void smallDoubleValuesWithoutDuplicates() throws IOException {
        double min = LuceneSchemaIndexUniquenessVerificationIT.randomDoubleInRange(100.0, 10000.0);
        double max = min + (double)this.nodesToCreate;
        Set<Value> data = this.randomDoubles(min, max);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void smallDoubleValuesWithDuplicates() throws IOException {
        double min = LuceneSchemaIndexUniquenessVerificationIT.randomDoubleInRange(100.0, 10000.0);
        double max = min + (double)this.nodesToCreate;
        List<Value> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomDoubles(min, max));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void largeDoubleValuesWithoutDuplicates() throws IOException {
        double max = LuceneSchemaIndexUniquenessVerificationIT.randomDoubleInRange(8.988465674311579E307, Double.MAX_VALUE);
        double min = max / 2.0;
        Set<Value> data = this.randomDoubles(min, max);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void largeDoubleValuesWithDuplicates() throws IOException {
        double max = LuceneSchemaIndexUniquenessVerificationIT.randomDoubleInRange(8.988465674311579E307, Double.MAX_VALUE);
        double min = max / 2.0;
        List<Value> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomDoubles(min, max));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void smallArrayValuesWithoutDuplicates() throws IOException {
        Set<Value> data = this.randomArrays(3, 7);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void smallArrayValuesWithDuplicates() throws IOException {
        List<Value> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomArrays(3, 7));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void largeArrayValuesWithoutDuplicates() throws IOException {
        Set<Value> data = this.randomArrays(70, 100);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void largeArrayValuesWithDuplicates() throws IOException {
        List<Value> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomArrays(70, 100));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void variousValuesWithoutDuplicates() throws IOException {
        Set<Value> data = this.randomValues();
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void variousValuesWitDuplicates() throws IOException {
        List<Value> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomValues());
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    private void insert(Collection<Value> data) throws IOException {
        Value[] dataArray = data.toArray(new Value[data.size()]);
        for (int i = 0; i < dataArray.length; ++i) {
            Document doc = LuceneDocumentStructure.documentRepresentingProperties((long)i, (Value[])new Value[]{dataArray[i]});
            this.index.getIndexWriter().addDocument(doc);
        }
        this.index.maybeRefreshBlocking();
    }

    private void assertUniquenessConstraintHolds(Collection<Value> data) {
        try {
            this.verifyUniqueness(data);
        }
        catch (Throwable t) {
            Assert.fail((String)("Unable to create uniqueness constraint for data: " + Strings.prettyPrint((Object)data.toArray()) + "\n" + Exceptions.stringify((Throwable)t)));
        }
    }

    private void assertUniquenessConstraintFails(Collection<Value> data) {
        try {
            this.verifyUniqueness(data);
            Assert.fail((String)("Should not be possible to create uniqueness constraint for data: " + Strings.prettyPrint((Object)data.toArray())));
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)Matchers.instanceOf(IndexEntryConflictException.class));
        }
    }

    private void verifyUniqueness(Collection<Value> data) throws IOException, IndexEntryConflictException {
        TestPropertyAccessor propertyAccessor = new TestPropertyAccessor(new ArrayList<Value>(data));
        this.index.verifyUniqueness((PropertyAccessor)propertyAccessor, new int[]{42});
    }

    private Set<Value> randomStrings() {
        return ThreadLocalRandom.current().ints(this.nodesToCreate, 1, 200).mapToObj(this::randomString).map(Values::of).collect(Collectors.toSet());
    }

    private String randomString(int size) {
        return ThreadLocalRandom.current().nextBoolean() ? RandomStringUtils.random((int)size) : RandomStringUtils.randomAlphabetic((int)size);
    }

    private Set<Value> randomLongs(long min, long max) {
        return ThreadLocalRandom.current().longs(this.nodesToCreate, min, max).boxed().map(Values::of).collect(Collectors.toSet());
    }

    private Set<Value> randomDoubles(double min, double max) {
        return ThreadLocalRandom.current().doubles(this.nodesToCreate, min, max).boxed().map(Values::of).collect(Collectors.toSet());
    }

    private Set<Value> randomArrays(int minLength, int maxLength) {
        RandomValues randoms = RandomValues.create((RandomValues.Configuration)new ArraySizeConfig(minLength, maxLength));
        return IntStream.range(0, this.nodesToCreate).mapToObj(i -> randoms.nextArray()).collect(Collectors.toSet());
    }

    private Set<Value> randomValues() {
        RandomValues randoms = RandomValues.create((RandomValues.Configuration)new ArraySizeConfig(5, 100));
        return IntStream.range(0, this.nodesToCreate).mapToObj(i -> randoms.nextValue()).collect(Collectors.toSet());
    }

    private static List<Value> withDuplicate(Set<Value> set) {
        ArrayList<Value> data = new ArrayList<Value>(set);
        if (data.isEmpty()) {
            throw new IllegalStateException();
        }
        if (data.size() == 1) {
            data.add((Value)data.get(0));
        } else {
            int duplicateValueIndex;
            int duplicateIndex = LuceneSchemaIndexUniquenessVerificationIT.randomIntInRange(0, data.size());
            while ((duplicateValueIndex = ThreadLocalRandom.current().nextInt(data.size())) == duplicateIndex) {
            }
            Value duplicate = LuceneSchemaIndexUniquenessVerificationIT.duplicateValue((Value)data.get(duplicateValueIndex));
            data.set(duplicateIndex, duplicate);
        }
        return data;
    }

    private static Value duplicateValue(Value propertyValue) {
        return Values.of((Object)propertyValue.asObjectCopy());
    }

    private static int randomIntInRange(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max);
    }

    private static long randomLongInRange(long min, long max) {
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    private static double randomDoubleInRange(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    private static class TestConfigFactory
    implements Factory<IndexWriterConfig> {
        private TestConfigFactory() {
        }

        public IndexWriterConfig newInstance() {
            IndexWriterConfig verboseConfig = IndexWriterConfigs.standard();
            verboseConfig.setCodec(Codec.getDefault());
            return verboseConfig;
        }
    }

    private static class ArraySizeConfig
    extends RandomValues.Default {
        final int minLength;
        final int maxLength;

        ArraySizeConfig(int minLength, int maxLength) {
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        public int arrayMinLength() {
            return super.arrayMinLength();
        }

        public int arrayMaxLength() {
            return super.arrayMaxLength();
        }
    }
}

