/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class LuceneSchemaIndexPopulationIT {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final int affectedNodes;
    private final SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{0});

    @Before
    public void before() {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "10");
    }

    @After
    public void after() {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "");
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Integer> affectedNodes() {
        return Arrays.asList(7, 11, 14, 20, 35, 58);
    }

    public LuceneSchemaIndexPopulationIT(int affectedNodes) {
        this.affectedNodes = affectedNodes;
    }

    @Test
    public void partitionedIndexPopulation() throws Exception {
        try (SchemaIndex uniqueIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((SchemaIndexDescriptor)this.descriptor, (Config)Config.defaults()).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(new File(this.testDir.directory("partitionIndex" + this.affectedNodes), "uniqueIndex" + this.affectedNodes))).build();){
            uniqueIndex.open();
            Assert.assertEquals((long)0L, (long)uniqueIndex.allDocumentsReader().maxCount());
            Assert.assertFalse((boolean)uniqueIndex.exists());
            try (LuceneIndexAccessor indexAccessor = new LuceneIndexAccessor(uniqueIndex, this.descriptor);){
                this.generateUpdates(indexAccessor, this.affectedNodes);
                indexAccessor.force(IOLimiter.unlimited());
                Assert.assertTrue((boolean)uniqueIndex.isOnline());
                try (IndexReader indexReader = indexAccessor.newReader();){
                    long[] nodes = PrimitiveLongCollections.asArray((LongIterator)indexReader.query(new IndexQuery[]{IndexQuery.exists((int)1)}));
                    Assert.assertEquals((long)this.affectedNodes, (long)nodes.length);
                    IndexSampler indexSampler = indexReader.createSampler();
                    IndexSample sample = indexSampler.sampleIndex();
                    Assert.assertEquals((long)this.affectedNodes, (long)sample.indexSize());
                    Assert.assertEquals((long)this.affectedNodes, (long)sample.uniqueValues());
                    Assert.assertEquals((long)this.affectedNodes, (long)sample.sampleSize());
                }
            }
        }
    }

    private void generateUpdates(LuceneIndexAccessor indexAccessor, int nodesToUpdate) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = indexAccessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (int nodeId = 0; nodeId < nodesToUpdate; ++nodeId) {
                updater.process(this.add(nodeId, nodeId));
            }
        }
    }

    private IndexEntryUpdate<?> add(long nodeId, Object value) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{Values.of((Object)value)});
    }
}

