/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.WritableAbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.VerboseTimeout;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class DatabaseIndexIntegrationTest {
    private static final int THREAD_NUMBER = 5;
    private static ExecutorService workers;
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final RepeatRule repeatRule = new RepeatRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.repeatRule).around((TestRule)this.fileSystemRule);
    @Rule
    public final VerboseTimeout timeout = VerboseTimeout.builder().withTimeout(60L, TimeUnit.SECONDS).build();
    private final CountDownLatch raceSignal = new CountDownLatch(1);
    private SyncNotifierDirectoryFactory directoryFactory;
    private WritableTestDatabaseIndex luceneIndex;

    @BeforeClass
    public static void initExecutors() {
        workers = Executors.newFixedThreadPool(5);
    }

    @AfterClass
    public static void shutDownExecutor() {
        workers.shutdownNow();
    }

    @Before
    public void setUp() throws IOException {
        this.directoryFactory = new SyncNotifierDirectoryFactory(this.raceSignal);
        this.luceneIndex = this.createTestLuceneIndex(this.directoryFactory, this.testDirectory.directory());
    }

    @After
    public void tearDown() {
        this.directoryFactory.close();
    }

    @Test
    @RepeatRule.Repeat(times=2)
    public void testSaveCallCommitAndCloseFromMultipleThreads() throws Exception {
        this.generateInitialData();
        Supplier<Runnable> closeTaskSupplier = () -> this.createConcurrentCloseTask(this.raceSignal);
        List<Future<?>> closeFutures = this.submitTasks(closeTaskSupplier);
        for (Future<?> closeFuture : closeFutures) {
            closeFuture.get();
        }
        Assert.assertFalse((boolean)this.luceneIndex.isOpen());
    }

    @Test
    @RepeatRule.Repeat(times=2)
    public void saveCallCloseAndDropFromMultipleThreads() throws Exception {
        this.generateInitialData();
        Supplier<Runnable> dropTaskSupplier = () -> this.createConcurrentDropTask(this.raceSignal);
        List<Future<?>> futures = this.submitTasks(dropTaskSupplier);
        for (Future<?> future : futures) {
            future.get();
        }
        Assert.assertFalse((boolean)this.luceneIndex.isOpen());
    }

    private WritableTestDatabaseIndex createTestLuceneIndex(DirectoryFactory dirFactory, File folder) throws IOException {
        PartitionedIndexStorage indexStorage = new PartitionedIndexStorage(dirFactory, this.fileSystemRule.get(), folder);
        WritableTestDatabaseIndex index = new WritableTestDatabaseIndex(indexStorage);
        index.create();
        index.open();
        return index;
    }

    private List<Future<?>> submitTasks(Supplier<Runnable> taskSupplier) {
        ArrayList futures = new ArrayList(5);
        futures.add(workers.submit(this.createMainCloseTask()));
        for (int i = 0; i < 4; ++i) {
            futures.add(workers.submit(taskSupplier.get()));
        }
        return futures;
    }

    private void generateInitialData() throws IOException {
        IndexWriter indexWriter = this.firstPartitionWriter();
        for (int i = 0; i < 10; ++i) {
            indexWriter.addDocument((Iterable)this.createTestDocument());
        }
    }

    private Runnable createConcurrentDropTask(CountDownLatch dropRaceSignal) {
        return () -> {
            try {
                dropRaceSignal.await();
                Thread.yield();
                this.luceneIndex.drop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Runnable createConcurrentCloseTask(CountDownLatch closeRaceSignal) {
        return () -> {
            try {
                closeRaceSignal.await();
                Thread.yield();
                this.luceneIndex.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Runnable createMainCloseTask() {
        return () -> {
            try {
                this.luceneIndex.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Document createTestDocument() {
        Document document = new Document();
        document.add((IndexableField)new TextField("text", "textValue", Field.Store.YES));
        document.add((IndexableField)new LongField("long", 1L, Field.Store.YES));
        return document;
    }

    private IndexWriter firstPartitionWriter() {
        List partitions = this.luceneIndex.getPartitions();
        Assert.assertEquals((long)1L, (long)partitions.size());
        AbstractIndexPartition partition = (AbstractIndexPartition)partitions.get(0);
        return partition.getIndexWriter();
    }

    private static class SyncNotifierDirectoryFactory
    implements DirectoryFactory {
        final CountDownLatch signal;

        SyncNotifierDirectoryFactory(CountDownLatch signal) {
            this.signal = signal;
        }

        public Directory open(File dir, CountDownLatch signal) throws IOException {
            Directory directory = this.open(dir);
            return new SyncNotifierDirectory(directory, signal);
        }

        public Directory open(File dir) throws IOException {
            dir.mkdirs();
            FSDirectory fsDir = FSDirectory.open((Path)dir.toPath());
            return new SyncNotifierDirectory((Directory)fsDir, this.signal);
        }

        public void close() {
        }

        public void dumpToZip(ZipOutputStream zip, byte[] scratchPad) {
        }

        private class SyncNotifierDirectory
        extends Directory {
            private final Directory delegate;
            private final CountDownLatch signal;

            SyncNotifierDirectory(Directory delegate, CountDownLatch signal) {
                this.delegate = delegate;
                this.signal = signal;
            }

            public String[] listAll() throws IOException {
                return this.delegate.listAll();
            }

            public void deleteFile(String name) throws IOException {
                this.delegate.deleteFile(name);
            }

            public long fileLength(String name) throws IOException {
                return this.delegate.fileLength(name);
            }

            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                return this.delegate.createOutput(name, context);
            }

            public void sync(Collection<String> names) throws IOException {
                if (names.stream().noneMatch(name -> name.startsWith("pending_segments"))) {
                    try {
                        this.signal.countDown();
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.delegate.sync(names);
            }

            public void renameFile(String source, String dest) throws IOException {
                this.delegate.renameFile(source, dest);
            }

            public IndexInput openInput(String name, IOContext context) throws IOException {
                return this.delegate.openInput(name, context);
            }

            public Lock obtainLock(String name) throws IOException {
                return this.delegate.obtainLock(name);
            }

            public void close() throws IOException {
                this.delegate.close();
            }
        }
    }

    private static class TestLuceneIndex
    extends AbstractLuceneIndex {
        TestLuceneIndex(PartitionedIndexStorage indexStorage, IndexPartitionFactory partitionFactory) {
            super(indexStorage, partitionFactory);
        }
    }

    private static class WritableTestDatabaseIndex
    extends WritableAbstractDatabaseIndex<TestLuceneIndex> {
        WritableTestDatabaseIndex(PartitionedIndexStorage indexStorage) {
            super((AbstractLuceneIndex)new TestLuceneIndex(indexStorage, (IndexPartitionFactory)new WritableIndexPartitionFactory(IndexWriterConfigs::standard)));
        }
    }
}

