/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.index.impl.lucene.explicit.CloseTrackingIndexReader;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.WritableIndexReference;

public class WritableIndexReferenceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private IndexIdentifier identifier = (IndexIdentifier)Mockito.mock(IndexIdentifier.class);
    private IndexSearcher searcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
    private IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
    private CloseTrackingIndexReader reader = new CloseTrackingIndexReader();
    private WritableIndexReference indexReference = new WritableIndexReference(this.identifier, this.searcher, this.indexWriter);

    @Before
    public void setUp() {
        Mockito.when((Object)this.searcher.getIndexReader()).thenReturn((Object)this.reader);
    }

    @Test
    public void useProvidedWriterAsIndexWriter() {
        Assert.assertSame((Object)this.indexWriter, (Object)this.indexReference.getWriter());
    }

    @Test
    public void stalingWritableIndex() {
        Assert.assertFalse((String)"Index is not stale by default.", (boolean)this.indexReference.checkAndClearStale());
        this.indexReference.setStale();
        Assert.assertTrue((String)"We should be able to reset stale index state.", (boolean)this.indexReference.checkAndClearStale());
        Assert.assertFalse((String)"Index is not stale anymore.", (boolean)this.indexReference.checkAndClearStale());
    }

    @Test
    public void disposeWritableIndex() throws Exception {
        this.indexReference.dispose();
        Assert.assertTrue((String)"Reader should be closed.", (boolean)this.reader.isClosed());
        Assert.assertTrue((String)"Writer should be closed.", (boolean)this.indexReference.isWriterClosed());
    }
}

