/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexReference;
import org.neo4j.index.impl.lucene.explicit.IndexTypeCache;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.index.impl.lucene.explicit.WritableIndexReferenceFactory;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class WritableIndexReferenceFactoryTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final CleanupRule cleanupRule = new CleanupRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.cleanupRule).around((TestRule)this.fileSystemRule);
    private static final String INDEX_NAME = "testIndex";
    private LuceneDataSource.LuceneFilesystemFacade filesystemFacade = LuceneDataSource.LuceneFilesystemFacade.MEMORY;
    private IndexIdentifier indexIdentifier = new IndexIdentifier(IndexEntityType.Node, "testIndex");
    private IndexConfigStore indexStore;

    @Before
    public void setUp() {
        this.setupIndexInfrastructure();
    }

    @Test
    public void createWritableIndexReference() throws Exception {
        WritableIndexReferenceFactory indexReferenceFactory = this.createFactory();
        IndexReference indexReference = this.createIndexReference(indexReferenceFactory);
        Assert.assertNotNull((String)"Index should have writer.", (Object)indexReference.getWriter());
    }

    @Test
    public void refreshNotChangedWritableIndexReference() throws Exception {
        WritableIndexReferenceFactory indexReferenceFactory = this.createFactory();
        IndexReference indexReference = this.createIndexReference(indexReferenceFactory);
        IndexReference refreshedInstance = indexReferenceFactory.refresh(indexReference);
        Assert.assertSame((Object)indexReference, (Object)refreshedInstance);
    }

    @Test
    public void refreshChangedWritableIndexReference() throws Exception {
        WritableIndexReferenceFactory indexReferenceFactory = this.createFactory();
        IndexReference indexReference = this.createIndexReference(indexReferenceFactory);
        this.writeSomething(indexReference);
        IndexReference refreshedIndexReference = indexReferenceFactory.refresh(indexReference);
        this.cleanupRule.add((Object)refreshedIndexReference);
        Assert.assertNotSame((String)"Should return new refreshed index reference.", (Object)indexReference, (Object)refreshedIndexReference);
    }

    private void writeSomething(IndexReference indexReference) throws IOException {
        IndexWriter writer = indexReference.getWriter();
        writer.addDocument((Iterable)new Document());
        writer.commit();
    }

    private IndexReference createIndexReference(WritableIndexReferenceFactory indexReferenceFactory) throws Exception {
        IndexReference indexReference = indexReferenceFactory.createIndexReference(this.indexIdentifier);
        this.cleanupRule.add((Object)indexReference);
        return indexReference;
    }

    private WritableIndexReferenceFactory createFactory() {
        return new WritableIndexReferenceFactory(this.filesystemFacade, new File(this.getStoreDir(), "index"), new IndexTypeCache(this.indexStore));
    }

    private void setupIndexInfrastructure() {
        File storeDir = this.getStoreDir();
        this.indexStore = new IndexConfigStore(storeDir, this.fileSystemRule.get());
        this.indexStore.set(Node.class, INDEX_NAME, MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
    }

    private File getStoreDir() {
        return this.testDirectory.directory();
    }
}

