/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestAutoIndexing {
    private GraphDatabaseAPI graphDb;
    private Transaction tx;
    private Map<String, String> config;

    private void newTransaction() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.close();
        }
        this.tx = this.graphDb.beginTx();
    }

    private Map<String, String> getConfig() {
        if (this.config == null) {
            this.config = new HashMap<String, String>();
        }
        return this.config;
    }

    @Before
    public void startDb() {
        this.graphDb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(this.getConfig()).newGraphDatabase();
    }

    @After
    public void stopDb() {
        if (this.tx != null) {
            this.tx.close();
        }
        if (this.graphDb != null) {
            this.graphDb.shutdown();
        }
        this.tx = null;
        this.config = null;
        this.graphDb = null;
    }

    @Test
    public void testNodeAutoIndexFromAPISanity() {
        AutoIndexer autoIndexer = this.graphDb.index().getNodeAutoIndexer();
        autoIndexer.startAutoIndexingProperty("test_uuid");
        autoIndexer.setEnabled(true);
        Assert.assertEquals((long)1L, (long)autoIndexer.getAutoIndexedProperties().size());
        Assert.assertTrue((boolean)autoIndexer.getAutoIndexedProperties().contains("test_uuid"));
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        node1.setProperty("test_uuid", (Object)"node1");
        Node node2 = this.graphDb.createNode();
        node2.setProperty("test_uuid", (Object)"node2");
        this.newTransaction();
        Assert.assertEquals((Object)node1, (Object)autoIndexer.getAutoIndex().get("test_uuid", (Object)"node1").getSingle());
        Assert.assertEquals((Object)node2, (Object)autoIndexer.getAutoIndex().get("test_uuid", (Object)"node2").getSingle());
    }

    @Test
    public void testAutoIndexesReportReadOnly() {
        AutoIndexer autoIndexer = this.graphDb.index().getNodeAutoIndexer();
        try (Transaction tx = this.graphDb.beginTx();){
            Assert.assertFalse((boolean)autoIndexer.getAutoIndex().isWriteable());
            tx.success();
        }
        autoIndexer.startAutoIndexingProperty("test_uuid");
        autoIndexer.setEnabled(true);
        tx = this.graphDb.beginTx();
        var3_3 = null;
        try {
            Assert.assertFalse((boolean)autoIndexer.getAutoIndex().isWriteable());
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testChangesAreVisibleInTransaction() {
        AutoIndexer autoIndexer = this.graphDb.index().getNodeAutoIndexer();
        autoIndexer.startAutoIndexingProperty("nodeProp");
        autoIndexer.setEnabled(true);
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        node1.setProperty("nodeProp", (Object)"nodePropValue");
        node1.setProperty("nodePropNonIndexable", (Object)"valueWhatever");
        ReadableIndex nodeIndex = autoIndexer.getAutoIndex();
        Assert.assertEquals((Object)node1, (Object)nodeIndex.get("nodeProp", (Object)"nodePropValue").getSingle());
        this.newTransaction();
        Node node2 = this.graphDb.createNode();
        node2.setProperty("nodeProp", (Object)"nodePropValue2");
        Assert.assertEquals((Object)node2, (Object)nodeIndex.get("nodeProp", (Object)"nodePropValue2").getSingle());
        node2.setProperty("nodeProp", (Object)"nodePropValue3");
        Assert.assertEquals((Object)node2, (Object)nodeIndex.get("nodeProp", (Object)"nodePropValue3").getSingle());
        node2.removeProperty("nodeProp");
        Assert.assertFalse((boolean)nodeIndex.get("nodeProp", (Object)"nodePropValue2").hasNext());
        Assert.assertFalse((boolean)nodeIndex.get("nodeProp", (Object)"nodePropValue3").hasNext());
        this.newTransaction();
        Assert.assertEquals((Object)node1, (Object)nodeIndex.get("nodeProp", (Object)"nodePropValue").getSingle());
        Assert.assertFalse((boolean)nodeIndex.get("nodeProp", (Object)"nodePropValue2").hasNext());
        Assert.assertFalse((boolean)nodeIndex.get("nodeProp", (Object)"nodePropValue3").hasNext());
    }

    @Test
    public void testRelationshipAutoIndexFromAPISanity() {
        String propNameToIndex = "test";
        RelationshipAutoIndexer autoIndexer = this.graphDb.index().getRelationshipAutoIndexer();
        autoIndexer.startAutoIndexingProperty("test");
        autoIndexer.setEnabled(true);
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        Node node2 = this.graphDb.createNode();
        Node node3 = this.graphDb.createNode();
        Relationship rel12 = node1.createRelationshipTo(node2, RelationshipType.withName((String)"DYNAMIC"));
        Relationship rel23 = node2.createRelationshipTo(node3, RelationshipType.withName((String)"DYNAMIC"));
        rel12.setProperty("test", (Object)"rel12");
        rel23.setProperty("test", (Object)"rel23");
        this.newTransaction();
        Assert.assertEquals((Object)rel12, (Object)autoIndexer.getAutoIndex().get("test", (Object)"rel12").getSingle());
        Assert.assertEquals((Object)rel23, (Object)autoIndexer.getAutoIndex().get("test", (Object)"rel23").getSingle());
    }

    @Test
    public void testConfigAndAPICompatibility() {
        this.stopDb();
        this.config = new HashMap<String, String>();
        this.config.put(GraphDatabaseSettings.node_keys_indexable.name(), "nodeProp1, nodeProp2");
        this.config.put(GraphDatabaseSettings.relationship_keys_indexable.name(), "relProp1, relProp2");
        this.config.put(GraphDatabaseSettings.node_auto_indexing.name(), "true");
        this.config.put(GraphDatabaseSettings.relationship_auto_indexing.name(), "true");
        this.startDb();
        Assert.assertTrue((boolean)this.graphDb.index().getNodeAutoIndexer().isEnabled());
        Assert.assertTrue((boolean)this.graphDb.index().getRelationshipAutoIndexer().isEnabled());
        AutoIndexer autoNodeIndexer = this.graphDb.index().getNodeAutoIndexer();
        autoNodeIndexer.startAutoIndexingProperty("nodeProp1");
        autoNodeIndexer.startAutoIndexingProperty("nodeProp3");
        Assert.assertEquals((long)3L, (long)autoNodeIndexer.getAutoIndexedProperties().size());
        Assert.assertTrue((boolean)autoNodeIndexer.getAutoIndexedProperties().contains("nodeProp1"));
        Assert.assertTrue((boolean)autoNodeIndexer.getAutoIndexedProperties().contains("nodeProp2"));
        Assert.assertTrue((boolean)autoNodeIndexer.getAutoIndexedProperties().contains("nodeProp3"));
    }

    @Test
    public void testSmallGraphWithNonIndexableProps() {
        this.stopDb();
        this.config = new HashMap<String, String>();
        this.config.put(GraphDatabaseSettings.node_keys_indexable.name(), "nodeProp1, nodeProp2");
        this.config.put(GraphDatabaseSettings.relationship_keys_indexable.name(), "relProp1, relProp2");
        this.config.put(GraphDatabaseSettings.node_auto_indexing.name(), "true");
        this.config.put(GraphDatabaseSettings.relationship_auto_indexing.name(), "true");
        this.startDb();
        Assert.assertTrue((boolean)this.graphDb.index().getNodeAutoIndexer().isEnabled());
        Assert.assertTrue((boolean)this.graphDb.index().getRelationshipAutoIndexer().isEnabled());
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        Node node2 = this.graphDb.createNode();
        Node node3 = this.graphDb.createNode();
        Relationship rel12 = node1.createRelationshipTo(node2, RelationshipType.withName((String)"DYNAMIC"));
        Relationship rel23 = node2.createRelationshipTo(node3, RelationshipType.withName((String)"DYNAMIC"));
        Relationship rel31 = node3.createRelationshipTo(node1, RelationshipType.withName((String)"DYNAMIC"));
        node1.setProperty("nodeProp1", (Object)"node1Value1");
        node1.setProperty("nodePropNonIndexable1", (Object)"node1ValueNonIndexable");
        node2.setProperty("nodeProp2", (Object)"node2Value1");
        node2.setProperty("nodePropNonIndexable2", (Object)"node2ValueNonIndexable");
        node3.setProperty("nodeProp1", (Object)"node3Value1");
        node3.setProperty("nodeProp2", (Object)"node3Value2");
        node3.setProperty("nodePropNonIndexable3", (Object)"node3ValueNonIndexable");
        rel12.setProperty("relProp1", (Object)"rel12Value1");
        rel12.setProperty("relPropNonIndexable1", (Object)"rel12ValueNonIndexable");
        rel23.setProperty("relProp2", (Object)"rel23Value1");
        rel23.setProperty("relPropNonIndexable2", (Object)"rel23ValueNonIndexable");
        rel31.setProperty("relProp1", (Object)"rel31Value1");
        rel31.setProperty("relProp2", (Object)"rel31Value2");
        rel31.setProperty("relPropNonIndexable3", (Object)"rel31ValueNonIndexable");
        this.newTransaction();
        AutoIndexer autoNodeIndexer = this.graphDb.index().getNodeAutoIndexer();
        Assert.assertEquals((Object)node1, (Object)autoNodeIndexer.getAutoIndex().get("nodeProp1", (Object)"node1Value1").getSingle());
        Assert.assertEquals((Object)node2, (Object)autoNodeIndexer.getAutoIndex().get("nodeProp2", (Object)"node2Value1").getSingle());
        Assert.assertEquals((Object)node3, (Object)autoNodeIndexer.getAutoIndex().get("nodeProp1", (Object)"node3Value1").getSingle());
        Assert.assertEquals((Object)node3, (Object)autoNodeIndexer.getAutoIndex().get("nodeProp2", (Object)"node3Value2").getSingle());
        Assert.assertFalse((boolean)autoNodeIndexer.getAutoIndex().get("nodePropNonIndexable1", (Object)"node1ValueNonIndexable").hasNext());
        Assert.assertFalse((boolean)autoNodeIndexer.getAutoIndex().get("nodePropNonIndexable2", (Object)"node2ValueNonIndexable").hasNext());
        Assert.assertFalse((boolean)autoNodeIndexer.getAutoIndex().get("nodePropNonIndexable3", (Object)"node3ValueNonIndexable").hasNext());
        RelationshipAutoIndexer autoRelIndexer = this.graphDb.index().getRelationshipAutoIndexer();
        Assert.assertEquals((Object)rel12, (Object)autoRelIndexer.getAutoIndex().get("relProp1", (Object)"rel12Value1").getSingle());
        Assert.assertEquals((Object)rel23, (Object)autoRelIndexer.getAutoIndex().get("relProp2", (Object)"rel23Value1").getSingle());
        Assert.assertEquals((Object)rel31, (Object)autoRelIndexer.getAutoIndex().get("relProp1", (Object)"rel31Value1").getSingle());
        Assert.assertEquals((Object)rel31, (Object)autoRelIndexer.getAutoIndex().get("relProp2", (Object)"rel31Value2").getSingle());
        Assert.assertFalse((boolean)autoRelIndexer.getAutoIndex().get("relPropNonIndexable1", (Object)"rel12ValueNonIndexable").hasNext());
        Assert.assertFalse((boolean)autoRelIndexer.getAutoIndex().get("relPropNonIndexable2", (Object)"rel23ValueNonIndexable").hasNext());
        Assert.assertFalse((boolean)autoRelIndexer.getAutoIndex().get("relPropNonIndexable3", (Object)"rel31ValueNonIndexable").hasNext());
    }

    @Test
    public void testDefaultIsOff() {
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        node1.setProperty("testProp", (Object)"node1");
        this.newTransaction();
        AutoIndexer autoIndexer = this.graphDb.index().getNodeAutoIndexer();
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("testProp", (Object)"node1").hasNext());
    }

    @Test
    public void testDefaulIfOffIsForEverything() {
        this.graphDb.index().getNodeAutoIndexer().setEnabled(true);
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        node1.setProperty("testProp", (Object)"node1");
        node1.setProperty("testProp1", (Object)"node1");
        Node node2 = this.graphDb.createNode();
        node2.setProperty("testProp", (Object)"node2");
        node2.setProperty("testProp1", (Object)"node2");
        this.newTransaction();
        AutoIndexer autoIndexer = this.graphDb.index().getNodeAutoIndexer();
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("testProp", (Object)"node1").hasNext());
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("testProp1", (Object)"node1").hasNext());
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("testProp", (Object)"node2").hasNext());
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("testProp1", (Object)"node2").hasNext());
    }

    @Test
    public void testDefaultIsOffIfExplicit() {
        this.stopDb();
        this.config = new HashMap<String, String>();
        this.config.put(GraphDatabaseSettings.node_keys_indexable.name(), "nodeProp1, nodeProp2");
        this.config.put(GraphDatabaseSettings.relationship_keys_indexable.name(), "relProp1, relProp2");
        this.config.put(GraphDatabaseSettings.node_auto_indexing.name(), "false");
        this.config.put(GraphDatabaseSettings.relationship_auto_indexing.name(), "false");
        this.startDb();
        AutoIndexer autoIndexer = this.graphDb.index().getNodeAutoIndexer();
        autoIndexer.startAutoIndexingProperty("testProp");
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        node1.setProperty("nodeProp1", (Object)"node1");
        node1.setProperty("nodeProp2", (Object)"node1");
        node1.setProperty("testProp", (Object)"node1");
        this.newTransaction();
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("nodeProp1", (Object)"node1").hasNext());
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("nodeProp2", (Object)"node1").hasNext());
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("testProp", (Object)"node1").hasNext());
    }

    @Test
    public void testDefaultsAreSeparateForNodesAndRelationships() {
        this.stopDb();
        this.config = new HashMap<String, String>();
        this.config.put(GraphDatabaseSettings.node_keys_indexable.name(), "propName");
        this.config.put(GraphDatabaseSettings.node_auto_indexing.name(), "true");
        this.startDb();
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        Node node2 = this.graphDb.createNode();
        node1.setProperty("propName", (Object)"node1");
        node2.setProperty("propName", (Object)"node2");
        node2.setProperty("propName_", (Object)"node2");
        Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"DYNAMIC"));
        rel.setProperty("propName", (Object)"rel1");
        this.newTransaction();
        ReadableIndex autoIndex = this.graphDb.index().getNodeAutoIndexer().getAutoIndex();
        Assert.assertEquals((Object)node1, (Object)autoIndex.get("propName", (Object)"node1").getSingle());
        Assert.assertEquals((Object)node2, (Object)autoIndex.get("propName", (Object)"node2").getSingle());
        Assert.assertFalse((boolean)this.graphDb.index().getRelationshipAutoIndexer().getAutoIndex().get("propName", (Object)"rel1").hasNext());
    }

    @Test
    public void testStartStopAutoIndexing() {
        this.stopDb();
        this.config = new HashMap<String, String>();
        this.config.put(GraphDatabaseSettings.node_keys_indexable.name(), "propName");
        this.config.put(GraphDatabaseSettings.node_auto_indexing.name(), "true");
        this.startDb();
        AutoIndexer autoIndexer = this.graphDb.index().getNodeAutoIndexer();
        Assert.assertTrue((boolean)autoIndexer.isEnabled());
        autoIndexer.setEnabled(false);
        Assert.assertFalse((boolean)autoIndexer.isEnabled());
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        Node node2 = this.graphDb.createNode();
        node1.setProperty("propName", (Object)"node");
        this.newTransaction();
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("nodeProp1", (Object)"node1").hasNext());
        autoIndexer.setEnabled(true);
        node2.setProperty("propName", (Object)"node");
        this.newTransaction();
        Assert.assertEquals((Object)node2, (Object)autoIndexer.getAutoIndex().get("propName", (Object)"node").getSingle());
    }

    @Test
    public void testStopMonitoringProperty() {
        AutoIndexer autoIndexer = this.graphDb.index().getNodeAutoIndexer();
        autoIndexer.setEnabled(true);
        autoIndexer.startAutoIndexingProperty("propName");
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        Node node2 = this.graphDb.createNode();
        node1.setProperty("propName", (Object)"node");
        this.newTransaction();
        Assert.assertEquals((Object)node1, (Object)autoIndexer.getAutoIndex().get("propName", (Object)"node").getSingle());
        this.newTransaction();
        autoIndexer.startAutoIndexingProperty("propName2");
        autoIndexer.stopAutoIndexingProperty("propName");
        node2.setProperty("propName", (Object)"propValue");
        Node node3 = this.graphDb.createNode();
        node3.setProperty("propName2", (Object)"propValue");
        this.newTransaction();
        Assert.assertEquals((Object)node1, (Object)autoIndexer.getAutoIndex().get("propName", (Object)"node").getSingle());
        Assert.assertEquals((Object)node3, (Object)autoIndexer.getAutoIndex().get("propName2", (Object)"propValue").getSingle());
        node1.setProperty("propName", (Object)"newValue");
        this.newTransaction();
        Assert.assertFalse((boolean)autoIndexer.getAutoIndex().get("propName", (Object)"newValue").hasNext());
    }

    @Test
    public void testGettingAutoIndexByNameReturnsSomethingReadOnly() {
        this.graphDb.index().getNodeAutoIndexer().setEnabled(true);
        this.graphDb.index().getNodeAutoIndexer().startAutoIndexingProperty("nodeProp");
        this.graphDb.index().getRelationshipAutoIndexer().setEnabled(true);
        this.graphDb.index().getRelationshipAutoIndexer().startAutoIndexingProperty("relProp");
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        Node node2 = this.graphDb.createNode();
        Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"FOO"));
        node1.setProperty("nodeProp", (Object)"nodePropValue");
        rel.setProperty("relProp", (Object)"relPropValue");
        this.newTransaction();
        Assert.assertEquals((long)1L, (long)this.graphDb.index().nodeIndexNames().length);
        Assert.assertEquals((long)1L, (long)this.graphDb.index().relationshipIndexNames().length);
        Assert.assertEquals((Object)"node_auto_index", (Object)this.graphDb.index().nodeIndexNames()[0]);
        Assert.assertEquals((Object)"relationship_auto_index", (Object)this.graphDb.index().relationshipIndexNames()[0]);
        Index nodeIndex = this.graphDb.index().forNodes("node_auto_index");
        RelationshipIndex relIndex = this.graphDb.index().forRelationships("relationship_auto_index");
        Assert.assertEquals((Object)node1, (Object)nodeIndex.get("nodeProp", (Object)"nodePropValue").getSingle());
        Assert.assertEquals((Object)rel, (Object)relIndex.get("relProp", (Object)"relPropValue").getSingle());
        try {
            nodeIndex.add(null, null, null);
            Assert.fail((String)"Auto indexes should not allow external manipulation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            relIndex.add(null, null, null);
            Assert.fail((String)"Auto indexes should not allow external manipulation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveUnloadedHeavyProperty() {
        this.graphDb.index().getNodeAutoIndexer().setEnabled(true);
        this.graphDb.index().getNodeAutoIndexer().startAutoIndexingProperty("nodeProp");
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        node1.setProperty("nodeProp", (Object)new int[]{-1, 2, 3, 4, 5, 6, 1, 1, 1, 1});
        this.newTransaction();
        NeoStoreDataSource dataSource = (NeoStoreDataSource)this.graphDb.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
        node1.removeProperty("nodeProp");
        this.newTransaction();
        Assert.assertFalse((boolean)node1.hasProperty("nodeProp"));
    }

    @Test
    public void testRemoveRelationshipRemovesDocument() {
        RelationshipAutoIndexer autoIndexer = this.graphDb.index().getRelationshipAutoIndexer();
        autoIndexer.startAutoIndexingProperty("foo");
        autoIndexer.setEnabled(true);
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        Node node2 = this.graphDb.createNode();
        Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"foo"));
        rel.setProperty("foo", (Object)"bar");
        this.newTransaction();
        try (IndexHits relationshipIndexHits = this.graphDb.index().forRelationships("relationship_auto_index").query((Object)"_id_:*");){
            Assert.assertThat((Object)relationshipIndexHits.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
        this.newTransaction();
        rel.delete();
        this.newTransaction();
        relationshipIndexHits = this.graphDb.index().forRelationships("relationship_auto_index").query((Object)"_id_:*");
        var6_6 = null;
        try {
            Assert.assertThat((Object)relationshipIndexHits.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (relationshipIndexHits != null) {
                if (var6_6 != null) {
                    try {
                        relationshipIndexHits.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    relationshipIndexHits.close();
                }
            }
        }
    }

    @Test
    public void testDeletingNodeRemovesItFromAutoIndex() {
        AutoIndexer nodeAutoIndexer = this.graphDb.index().getNodeAutoIndexer();
        nodeAutoIndexer.startAutoIndexingProperty("foo");
        nodeAutoIndexer.setEnabled(true);
        this.newTransaction();
        Node node1 = this.graphDb.createNode();
        node1.setProperty("foo", (Object)"bar");
        this.newTransaction();
        try (IndexHits nodeIndexHits = this.graphDb.index().forNodes("node_auto_index").query((Object)"_id_:*");){
            Assert.assertThat((Object)nodeIndexHits.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
        node1.delete();
        this.newTransaction();
        nodeIndexHits = this.graphDb.index().forNodes("node_auto_index").query((Object)"_id_:*");
        var4_4 = null;
        try {
            Assert.assertThat((Object)nodeIndexHits.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (nodeIndexHits != null) {
                if (var4_4 != null) {
                    try {
                        nodeIndexHits.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    nodeIndexHits.close();
                }
            }
        }
    }

    @Test
    public void shouldOnlyDeleteAffectedKeyWhenRemovingPropertyFromNode() {
        String key1 = "foo";
        String key2 = "bar";
        String value1 = "bip";
        String value2 = "bop";
        AutoIndexer nodeAutoIndexer = this.graphDb.index().getNodeAutoIndexer();
        nodeAutoIndexer.startAutoIndexingProperty(key1);
        nodeAutoIndexer.startAutoIndexingProperty(key2);
        nodeAutoIndexer.setEnabled(true);
        this.newTransaction();
        Node node = this.graphDb.createNode();
        node.setProperty(key1, (Object)value1);
        node.setProperty(key2, (Object)value2);
        this.newTransaction();
        node.removeProperty(key1);
        this.newTransaction();
        Assert.assertEquals((long)0L, (long)Iterators.count((Iterator)nodeAutoIndexer.getAutoIndex().get(key1, (Object)value1)));
        Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)nodeAutoIndexer.getAutoIndex().get(key2, (Object)value2)));
    }
}

