/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.index.impl.lucene.explicit.CloseTrackingIndexReader;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.ReadOnlyIndexReference;

public class ReadOnlyIndexReferenceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private IndexIdentifier identifier = (IndexIdentifier)Mockito.mock(IndexIdentifier.class);
    private IndexSearcher searcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
    private CloseTrackingIndexReader reader = new CloseTrackingIndexReader();
    private ReadOnlyIndexReference indexReference = new ReadOnlyIndexReference(this.identifier, this.searcher);

    @Before
    public void setUp() {
        Mockito.when((Object)this.searcher.getIndexReader()).thenReturn((Object)this.reader);
    }

    @Test
    public void obtainingWriterIsUnsupported() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Read only indexes do not have index writers.");
        this.indexReference.getWriter();
    }

    @Test
    public void markAsStaleIsUnsupported() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Read only indexes can't be marked as stale.");
        this.indexReference.setStale();
    }

    @Test
    public void checkAndClearStaleAlwaysFalse() {
        Assert.assertFalse((boolean)this.indexReference.checkAndClearStale());
    }

    @Test
    public void disposeClosingSearcherAndMarkAsClosed() throws IOException {
        this.indexReference.dispose();
        Assert.assertTrue((boolean)this.reader.isClosed());
        Assert.assertTrue((boolean)this.indexReference.isClosed());
    }

    @Test
    public void detachIndexReferenceWhenSomeReferencesExist() throws IOException {
        this.indexReference.incRef();
        this.indexReference.detachOrClose();
        Assert.assertTrue((String)"Should leave index in detached state.", (boolean)this.indexReference.isDetached());
    }

    @Test
    public void closeIndexReferenceWhenNoReferenceExist() throws IOException {
        this.indexReference.detachOrClose();
        Assert.assertFalse((String)"Should leave index in closed state.", (boolean)this.indexReference.isDetached());
        Assert.assertTrue((boolean)this.reader.isClosed());
        Assert.assertTrue((boolean)this.indexReference.isClosed());
    }

    @Test
    public void doNotCloseInstanceWhenSomeReferenceExist() {
        this.indexReference.incRef();
        Assert.assertFalse((boolean)this.indexReference.close());
        Assert.assertFalse((boolean)this.indexReference.isClosed());
    }

    @Test
    public void closeDetachedIndexReferencedOnlyOnce() throws IOException {
        this.indexReference.incRef();
        this.indexReference.detachOrClose();
        Assert.assertTrue((String)"Should leave index in detached state.", (boolean)this.indexReference.isDetached());
        Assert.assertTrue((boolean)this.indexReference.close());
        Assert.assertTrue((boolean)this.reader.isClosed());
        Assert.assertTrue((boolean)this.indexReference.isClosed());
    }

    @Test
    public void doNotCloseDetachedIndexReferencedMoreThenOnce() throws IOException {
        this.indexReference.incRef();
        this.indexReference.incRef();
        this.indexReference.detachOrClose();
        Assert.assertTrue((String)"Should leave index in detached state.", (boolean)this.indexReference.isDetached());
        Assert.assertFalse((boolean)this.indexReference.close());
    }

    @Test
    public void doNotCloseReferencedIndex() {
        this.indexReference.incRef();
        Assert.assertFalse((boolean)this.indexReference.close());
        Assert.assertFalse((boolean)this.indexReference.isClosed());
    }

    @Test
    public void closeNotReferencedIndex() {
        Assert.assertTrue((boolean)this.indexReference.close());
    }
}

