/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.explicit.LuceneBatchInserterIndexProviderNewImpl;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class LuceneBatchInserterIndexProviderNewImplTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void createBatchIndexFromAnyIndexStoreProvider() throws Exception {
        this.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir()));
        this.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)this.fileSystemRule.get()));
        this.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), this.getConfig()));
        this.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), this.getConfig(), this.getExtensions()));
        this.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)this.fileSystemRule.get(), this.getConfig()));
        this.createEndCloseIndexProvider(BatchInserters.inserter((File)this.getStoreDir(), (FileSystemAbstraction)this.fileSystemRule.get(), this.getConfig(), this.getExtensions()));
    }

    private void createEndCloseIndexProvider(BatchInserter inserter) {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(inserter);
        provider.shutdown();
        inserter.shutdown();
    }

    private Iterable<KernelExtensionFactory<?>> getExtensions() {
        return Iterables.asIterable((Object[])new KernelExtensionFactory[]{new InMemoryIndexProviderFactory()});
    }

    private Map<String, String> getConfig() {
        return MapUtil.stringMap((String[])new String[0]);
    }

    private File getStoreDir() {
        return this.testDirectory.graphDbDir();
    }
}

