/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.explicit.IndexType;

@RunWith(value=Parameterized.class)
public class IndexTypeTest {
    private static final String STRING_TEST_FIELD = "testString";
    private static final String STRING_TEST_FIELD2 = "testString2";
    private static final String NUMERIC_TEST_FIELD = "testNumeric";
    private static final String NUMERIC_TEST_FIELD2 = "testNumeric2";
    @Parameterized.Parameter(value=0)
    public IndexType indexType;
    @Parameterized.Parameter(value=1)
    public int documentFieldsPerUserField;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object> indexTypes() {
        Map customIndexTypeConfig = MapUtil.stringMap((String[])new String[]{"type", "exact", "to_lower_case", "true"});
        return Arrays.asList(new Object[]{IndexType.EXACT, 2}, new Object[]{IndexType.getIndexType((Map)customIndexTypeConfig), 3});
    }

    @Test
    public void removeFromExactIndexedDocumentRetainCorrectNumberOfFields() {
        Document document = new Document();
        this.indexType.addToDocument(document, STRING_TEST_FIELD, (Object)"value");
        this.indexType.addToDocument(document, STRING_TEST_FIELD2, (Object)"value2");
        this.indexType.addToDocument(document, NUMERIC_TEST_FIELD, (Object)1);
        this.indexType.addToDocument(document, NUMERIC_TEST_FIELD2, (Object)2);
        this.indexType.removeFromDocument(document, STRING_TEST_FIELD, null);
        Assert.assertEquals((String)"Usual fields, doc values fields for user fields and housekeeping fields.", (long)(this.documentFieldsPerUserField * 3), (long)document.getFields().size());
        Assert.assertEquals((String)"Two string fields with specified name expected.", (long)2L, (long)this.getDocumentFields(document, STRING_TEST_FIELD2).length);
        Assert.assertEquals((String)"Two numeric fields with specified name expected.", (long)2L, (long)this.getDocumentFields(document, NUMERIC_TEST_FIELD).length);
        Assert.assertEquals((String)"Two numeric fields with specified name expected.", (long)2L, (long)this.getDocumentFields(document, NUMERIC_TEST_FIELD2).length);
    }

    @Test
    public void removeFieldFromExactIndexedDocumentRetainCorrectNumberOfFields() {
        Document document = new Document();
        this.indexType.addToDocument(document, STRING_TEST_FIELD, (Object)"value");
        this.indexType.addToDocument(document, STRING_TEST_FIELD2, (Object)"value2");
        this.indexType.addToDocument(document, NUMERIC_TEST_FIELD, (Object)1);
        this.indexType.addToDocument(document, NUMERIC_TEST_FIELD2, (Object)2);
        this.indexType.removeFieldsFromDocument(document, NUMERIC_TEST_FIELD, null);
        this.indexType.removeFieldsFromDocument(document, STRING_TEST_FIELD2, null);
        Assert.assertEquals((String)"Usual fields, doc values fields for user fields and housekeeping fields.", (long)(this.documentFieldsPerUserField * 2), (long)document.getFields().size());
        Assert.assertEquals((String)"Two string fields with specified name expected.", (long)2L, (long)this.getDocumentFields(document, STRING_TEST_FIELD).length);
        Assert.assertEquals((String)"Two numeric fields with specified name expected.", (long)2L, (long)this.getDocumentFields(document, NUMERIC_TEST_FIELD2).length);
    }

    private IndexableField[] getDocumentFields(Document document, String name) {
        return document.getFields(name);
    }
}

