/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;

public abstract class Neo4jTestCase {
    private static GraphDatabaseService graphDb;
    private Transaction tx;

    @BeforeClass
    public static void setUpDb() {
        graphDb = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @AfterClass
    public static void tearDownDb() {
        graphDb.shutdown();
    }

    @Before
    public void setUpTest() {
        this.tx = graphDb.beginTx();
    }

    @After
    public void tearDownTest() {
        if (!this.manageMyOwnTxFinish()) {
            this.finishTx(true);
        }
    }

    protected boolean manageMyOwnTxFinish() {
        return false;
    }

    protected void finishTx(boolean commit) {
        if (this.tx == null) {
            return;
        }
        if (commit) {
            this.tx.success();
        }
        this.tx.close();
        this.tx = null;
    }

    protected Transaction beginTx() {
        if (this.tx == null) {
            this.tx = graphDb.beginTx();
        }
        return this.tx;
    }

    public static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : Objects.requireNonNull(file.listFiles())) {
                Neo4jTestCase.deleteFileOrDirectory(child);
            }
        }
        Assert.assertTrue((String)("delete " + file), (boolean)file.delete());
    }

    protected static GraphDatabaseService graphDb() {
        return graphDb;
    }

    public static <T> void assertContains(Collection<T> collection, T ... expectedItems) {
        String collectionString = Neo4jTestCase.join(", ", collection.toArray());
        Assert.assertEquals((String)collectionString, (long)expectedItems.length, (long)collection.size());
        for (T item : expectedItems) {
            Assert.assertTrue((boolean)collection.contains(item));
        }
    }

    public static <T> void assertContains(Iterable<T> items, T ... expectedItems) {
        Neo4jTestCase.assertContains(Neo4jTestCase.asCollection(items), expectedItems);
    }

    public static <T> void assertContainsInOrder(Collection<T> collection, T ... expectedItems) {
        String collectionString = Neo4jTestCase.join(", ", collection.toArray());
        Assert.assertEquals((String)collectionString, (long)expectedItems.length, (long)collection.size());
        Iterator<T> itr = collection.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Assert.assertEquals(expectedItems[i], itr.next());
            ++i;
        }
    }

    public static <T> void assertContainsInOrder(Iterable<T> collection, T ... expectedItems) {
        Neo4jTestCase.assertContainsInOrder(Neo4jTestCase.asCollection(collection), expectedItems);
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static <T> String join(String delimiter, T ... items) {
        StringBuilder buffer = new StringBuilder();
        for (T item : items) {
            if (buffer.length() > 0) {
                buffer.append(delimiter);
            }
            buffer.append(item.toString());
        }
        return buffer.toString();
    }
}

