/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class ExplicitIndexTest {
    private static final RelationshipType TYPE = RelationshipType.withName((String)"TYPE");
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void removalOfNodeIndexDoesNotInfluenceRelationshipIndexWithSameName() {
        String indexName = "index";
        ExplicitIndexTest.createNodeExplicitIndexWithSingleNode((GraphDatabaseService)this.db, indexName);
        ExplicitIndexTest.createRelationshipExplicitIndexWithSingleRelationship((GraphDatabaseService)this.db, indexName);
        try (Transaction tx = this.db.beginTx();){
            Relationship relationship = this.db.createNode().createRelationshipTo(this.db.createNode(), TYPE);
            RelationshipIndex relationshipIndex = this.db.index().forRelationships(indexName);
            relationshipIndex.add((PropertyContainer)relationship, "key", (Object)"otherValue");
            Index nodeIndex = this.db.index().forNodes(indexName);
            nodeIndex.delete();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            Assert.assertFalse((boolean)this.db.index().existsForNodes(indexName));
            RelationshipIndex relationshipIndex = this.db.index().forRelationships(indexName);
            Assert.assertEquals((long)2L, (long)ExplicitIndexTest.sizeOf(relationshipIndex));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void removalOfRelationshipIndexDoesNotInfluenceNodeIndexWithSameName() {
        String indexName = "index";
        ExplicitIndexTest.createNodeExplicitIndexWithSingleNode((GraphDatabaseService)this.db, indexName);
        ExplicitIndexTest.createRelationshipExplicitIndexWithSingleRelationship((GraphDatabaseService)this.db, indexName);
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            Index nodeIndex = this.db.index().forNodes(indexName);
            nodeIndex.add((PropertyContainer)node, "key", (Object)"otherValue");
            RelationshipIndex relationshipIndex = this.db.index().forRelationships(indexName);
            relationshipIndex.delete();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            Assert.assertFalse((boolean)this.db.index().existsForRelationships(indexName));
            Index nodeIndex = this.db.index().forNodes(indexName);
            Assert.assertEquals((long)2L, (long)ExplicitIndexTest.sizeOf(nodeIndex));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowIllegalArgumentChangingTypeOfFieldOnNodeIndex() {
        Index nodeIndex3;
        long nodeId;
        String indexName = "index";
        ExplicitIndexTest.createNodeExplicitIndexWithSingleNode((GraphDatabaseService)this.db, indexName);
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            nodeId = node.getId();
            Index nodeIndex2 = this.db.index().forNodes(indexName);
            nodeIndex2.add((PropertyContainer)node, "key", (Object)"otherValue");
            tx.success();
        }
        tx = this.db.beginTx();
        var5_3 = null;
        try {
            nodeIndex3 = this.db.index().forNodes(indexName);
            nodeIndex3.remove((PropertyContainer)this.db.getNodeById(nodeId), "key");
            tx.success();
        }
        catch (Throwable nodeIndex3) {
            var5_3 = nodeIndex3;
            throw nodeIndex3;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable nodeIndex3) {
                        var5_3.addSuppressed(nodeIndex3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.expectedException.expect(IllegalArgumentException.class);
        tx = this.db.beginTx();
        var5_3 = null;
        try {
            nodeIndex3 = this.db.index().forNodes(indexName);
            nodeIndex3.add((PropertyContainer)this.db.getNodeById(nodeId), "key", (Object)ValueContext.numeric((Number)52));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowIllegalArgumentChangingTypeOfFieldOnRelationshipIndex() {
        RelationshipIndex index3;
        long relId;
        String indexName = "index";
        ExplicitIndexTest.createRelationshipExplicitIndexWithSingleRelationship((GraphDatabaseService)this.db, indexName);
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            Relationship rel = node.createRelationshipTo(node, TYPE);
            relId = rel.getId();
            RelationshipIndex index2 = this.db.index().forRelationships(indexName);
            index2.add((PropertyContainer)rel, "key", (Object)"otherValue");
            tx.success();
        }
        tx = this.db.beginTx();
        var5_3 = null;
        try {
            index3 = this.db.index().forRelationships(indexName);
            index3.remove((PropertyContainer)this.db.getRelationshipById(relId), "key");
            tx.success();
        }
        catch (Throwable index3) {
            var5_3 = index3;
            throw index3;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable index3) {
                        var5_3.addSuppressed(index3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.expectedException.expect(IllegalArgumentException.class);
        tx = this.db.beginTx();
        var5_3 = null;
        try {
            index3 = this.db.index().forRelationships(indexName);
            index3.add((PropertyContainer)this.db.getRelationshipById(relId), "key", (Object)ValueContext.numeric((Number)52));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToAddNodesAfterRemovalOfKey() {
        Index nodeIndex;
        long nodeId;
        Node node;
        String indexName = "index";
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            nodeId = node.getId();
            nodeIndex = this.db.index().forNodes(indexName);
            nodeIndex.add((PropertyContainer)node, "key", (Object)"hej");
            nodeIndex.add((PropertyContainer)node, "keydelete", (Object)"hej");
            tx.success();
        }
        tx = this.db.beginTx();
        var5_3 = null;
        try {
            Index nodeIndex2 = this.db.index().forNodes(indexName);
            nodeIndex2.remove((PropertyContainer)this.db.getNodeById(nodeId), "keydelete");
            tx.success();
        }
        catch (Throwable nodeIndex2) {
            var5_3 = nodeIndex2;
            throw nodeIndex2;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable nodeIndex2) {
                        var5_3.addSuppressed(nodeIndex2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.db.shutdownAndKeepStore();
        this.db.getGraphDatabaseAPI();
        tx = this.db.beginTx();
        var5_3 = null;
        try {
            node = this.db.createNode();
            nodeIndex = this.db.index().forNodes(indexName);
            nodeIndex.add((PropertyContainer)node, "key", (Object)"hej");
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void indexContentsShouldStillBeOrderedAfterRemovalOfKey() {
        IndexHits query;
        long third;
        long first;
        long fourth;
        long second;
        long delete;
        Index nodeIndex;
        String indexName = "index";
        try (Transaction tx = this.db.beginTx();){
            this.db.index().forNodes(indexName);
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            nodeIndex = this.db.index().forNodes(indexName);
            Node node2 = this.db.createNode();
            delete = node2.getId();
            nodeIndex.add((PropertyContainer)node2, "keydelte", (Object)"delete");
            node2 = this.db.createNode();
            second = node2.getId();
            nodeIndex.add((PropertyContainer)node2, "key", (Object)ValueContext.numeric((Number)2));
            nodeIndex.add((PropertyContainer)node2, "keydelte", (Object)"delete");
            node2 = this.db.createNode();
            fourth = node2.getId();
            nodeIndex.add((PropertyContainer)node2, "key", (Object)ValueContext.numeric((Number)4));
            nodeIndex.add((PropertyContainer)node2, "keydelte", (Object)"delete");
            node2 = this.db.createNode();
            first = node2.getId();
            nodeIndex.add((PropertyContainer)node2, "key", (Object)ValueContext.numeric((Number)1));
            nodeIndex.add((PropertyContainer)node2, "keydelte", (Object)"delete");
            node2 = this.db.createNode();
            third = node2.getId();
            nodeIndex.add((PropertyContainer)node2, "key", (Object)ValueContext.numeric((Number)3));
            nodeIndex.add((PropertyContainer)node2, "keydelte", (Object)"delete");
            tx.success();
        }
        tx = this.db.beginTx();
        var13_12 = null;
        try {
            nodeIndex = this.db.index().forNodes(indexName);
            query = nodeIndex.query("key", (Object)QueryContext.numericRange((String)"key", (Number)2, (Number)3));
            Assert.assertEquals((long)2L, (long)query.size());
            query.forEachRemaining(node -> Assert.assertTrue((node.getId() == second || node.getId() == third ? 1 : 0) != 0));
        }
        catch (Throwable nodeIndex2) {
            var13_12 = nodeIndex2;
            throw nodeIndex2;
        }
        finally {
            if (tx != null) {
                if (var13_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable nodeIndex2) {
                        var13_12.addSuppressed(nodeIndex2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var13_12 = null;
        try {
            nodeIndex = this.db.index().forNodes(indexName);
            nodeIndex.remove((PropertyContainer)this.db.getNodeById(delete), "keydelete");
            nodeIndex.remove((PropertyContainer)this.db.getNodeById(first), "keydelete");
            nodeIndex.remove((PropertyContainer)this.db.getNodeById(second), "keydelete");
            nodeIndex.remove((PropertyContainer)this.db.getNodeById(third), "keydelete");
            nodeIndex.remove((PropertyContainer)this.db.getNodeById(fourth), "keydelete");
            tx.success();
        }
        catch (Throwable nodeIndex3) {
            var13_12 = nodeIndex3;
            throw nodeIndex3;
        }
        finally {
            if (tx != null) {
                if (var13_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable nodeIndex3) {
                        var13_12.addSuppressed(nodeIndex3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var13_12 = null;
        try {
            nodeIndex = this.db.index().forNodes(indexName);
            query = nodeIndex.query("key", (Object)QueryContext.numericRange((String)"key", (Number)2, (Number)3));
            Assert.assertEquals((long)2L, (long)query.size());
            query.forEachRemaining(node -> Assert.assertTrue((node.getId() == second || node.getId() == third ? 1 : 0) != 0));
        }
        catch (Throwable throwable) {
            var13_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var13_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var13_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void relationshipIndexShouldBeAbleToReindexInSameTransaction() {
        RelationshipIndex index;
        Relationship relationship;
        Node endNode;
        Node startNode;
        try (Transaction tx = this.db.beginTx();){
            startNode = this.db.createNode();
            endNode = this.db.createNode();
            relationship = startNode.createRelationshipTo(endNode, TYPE);
            index = this.db.index().forRelationships(TYPE.name());
            index.add((PropertyContainer)relationship, "key", (Object)new ValueContext((Object)1).indexNumeric());
            tx.success();
        }
        Assert.assertTrue((String)"Find relationship by property", (boolean)this.relationshipExistsByQuery(index, startNode, endNode, false));
        Assert.assertTrue((String)"Find relationship by property and start node", (boolean)this.relationshipExistsByQuery(index, startNode, endNode, true));
        tx = this.db.beginTx();
        var6_2 = null;
        try {
            index.remove((PropertyContainer)relationship);
            index.add((PropertyContainer)relationship, "key", (Object)new ValueContext((Object)2).indexNumeric());
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertTrue((String)"Find relationship by property", (boolean)this.relationshipExistsByQuery(index, startNode, endNode, false));
        Assert.assertTrue((String)"Find relationship by property and start node", (boolean)this.relationshipExistsByQuery(index, startNode, endNode, true));
    }

    @Test
    public void getSingleMustNotCloseStatementTwice() {
        long expected2;
        long expected1;
        String indexName = "index";
        try (Transaction tx = this.db.beginTx();){
            Node node1 = this.db.createNode();
            Node node2 = this.db.createNode();
            Index nodeIndex = this.db.index().forNodes(indexName);
            nodeIndex.add((PropertyContainer)node1, "key", (Object)"hej");
            nodeIndex.add((PropertyContainer)node2, "key", (Object)"hejhej");
            expected1 = node1.getId();
            expected2 = node2.getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var7_3 = null;
        try {
            Index nodeIndex = this.db.index().forNodes(indexName);
            IndexHits hits = nodeIndex.query("key", (Object)"hej");
            while (hits.hasNext()) {
                Node actual1 = (Node)hits.next();
                Assert.assertEquals((long)expected1, (long)actual1.getId());
                IndexHits hits2 = nodeIndex.query("key", (Object)"hejhej");
                Node actual2 = (Node)hits2.getSingle();
                Assert.assertEquals((long)expected2, (long)actual2.getId());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var7_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private boolean relationshipExistsByQuery(RelationshipIndex index, Node startNode, Node endNode, boolean specifyStartNode) {
        boolean found = false;
        try (Transaction tx = this.db.beginTx();
             IndexHits query = index.query("key", (Object)QueryContext.numericRange((String)"key", (Number)0, (Number)3), (Node)(specifyStartNode ? startNode : null), null);){
            for (Relationship relationship : query) {
                if (relationship.getStartNodeId() != startNode.getId() || relationship.getEndNodeId() != endNode.getId()) continue;
                found = true;
                break;
            }
            tx.success();
        }
        return found;
    }

    private static void createNodeExplicitIndexWithSingleNode(GraphDatabaseService db, String indexName) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            Index nodeIndex = db.index().forNodes(indexName);
            nodeIndex.add((PropertyContainer)node, "key", (Object)System.currentTimeMillis());
            tx.success();
        }
    }

    private static void createRelationshipExplicitIndexWithSingleRelationship(GraphDatabaseService db, String indexName) {
        try (Transaction tx = db.beginTx();){
            Relationship relationship = db.createNode().createRelationshipTo(db.createNode(), TYPE);
            RelationshipIndex relationshipIndexIndex = db.index().forRelationships(indexName);
            relationshipIndexIndex.add((PropertyContainer)relationship, "key", (Object)System.currentTimeMillis());
            tx.success();
        }
    }

    private static int sizeOf(Index<?> index) {
        try (IndexHits indexHits = index.query((Object)"_id_:*");){
            int n = indexHits.size();
            return n;
        }
    }
}

