/*
 * Copyright (c) 2002-2018 "Neo4j,"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.index.impl.lucene.explicit;

import org.neo4j.kernel.impl.api.explicitindex.AbstractIndexHits;

/**
 * Empty implementation of {@link AbstractIndexHits} with no matches and {@link Float#NaN} as a score
 * @param <T> index hits type
 */
public class EmptyIndexHits<T> extends AbstractIndexHits<T>
{
    @Override
    public int size()
    {
        return 0;
    }

    @Override
    public float currentScore()
    {
        return Float.NaN;
    }

    @Override
    protected T fetchNextOrNull()
    {
        return null;
    }
}
