/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.lucene.search.NumericRangeQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.LruCache;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.legacy.Contains;
import org.neo4j.index.impl.lucene.legacy.LuceneBatchInserterIndexProviderNewImpl;
import org.neo4j.index.impl.lucene.legacy.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.legacy.MyStandardAnalyzer;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.index.lucene.unsafe.batchinsert.LuceneBatchInserterIndexProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanStoreExtension;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class TestLuceneBatchInsert {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private File storeDir;
    private BatchInserter inserter;
    private GraphDatabaseService db;

    @Before
    public void startInserter() throws Exception {
        this.storeDir = this.testDirectory.graphDbDir();
        Iterable filteredKernelExtensions = Iterables.filter(this.onlyRealLuceneExtensions(), (Iterable)Service.load(KernelExtensionFactory.class));
        this.inserter = BatchInserters.inserter((File)this.storeDir, (FileSystemAbstraction)this.fileSystemRule.get(), (Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.label_index.name(), GraphDatabaseSettings.LabelIndex.LUCENE.name()}), (Iterable)filteredKernelExtensions);
    }

    @After
    public void shutdown() {
        this.shutdownInserter();
        if (this.db != null) {
            this.db.shutdown();
            this.db = null;
        }
    }

    @Test
    public void testSome() throws Exception {
        int i;
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        String indexName = "users";
        BatchInserterIndex index = provider.nodeIndex(indexName, LuceneIndexImplementation.EXACT_CONFIG);
        HashMap<Integer, Long> ids = new HashMap<Integer, Long>();
        int count = 5;
        for (i = 0; i < count; ++i) {
            long id = this.inserter.createNode(null, new Label[0]);
            index.add(id, MapUtil.map((Object[])new Object[]{"name", "Joe" + i, "other", "Schmoe"}));
            ids.put(i, id);
        }
        index.flush();
        for (i = 0; i < count; ++i) {
            Neo4jTestCase.assertContains(index.get("name", (Object)("Joe" + i)), new Long[]{(Long)ids.get(i)});
        }
        Neo4jTestCase.assertContains(index.query((Object)"name:Joe0 AND other:Schmoe"), new Long[]{(Long)ids.get(0)});
        Neo4jTestCase.assertContains(index.query("name", (Object)"Joe*"), ids.values().toArray(new Long[ids.size()]));
        provider.shutdown();
        this.switchToGraphDatabaseService(new ConfigurationParameter[0]);
        try (Transaction transaction = this.db.beginTx();){
            IndexManager indexManager = this.db.index();
            Assert.assertFalse((boolean)indexManager.existsForRelationships(indexName));
            Assert.assertTrue((boolean)indexManager.existsForNodes(indexName));
            Assert.assertNotNull((Object)indexManager.forNodes(indexName));
            Index dbIndex = this.db.index().forNodes("users");
            for (int i2 = 0; i2 < count; ++i2) {
                Neo4jTestCase.assertContains(dbIndex.get("name", (Object)("Joe" + i2)), new Node[]{this.db.getNodeById(((Long)ids.get(i2)).longValue())});
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            Iterator iterator = ids.values().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                nodes.add(this.db.getNodeById(id));
            }
            Neo4jTestCase.assertContains(dbIndex.query("name", (Object)"Joe*"), nodes.toArray(new Node[nodes.size()]));
            Neo4jTestCase.assertContains(dbIndex.query((Object)"name:Joe0 AND other:Schmoe"), new Node[]{this.db.getNodeById(((Long)ids.get(0)).longValue())});
            transaction.success();
        }
    }

    @Test
    public void testFulltext() {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        String name = "users";
        BatchInserterIndex index = provider.nodeIndex(name, MapUtil.stringMap((String[])new String[]{"type", "fulltext"}));
        long id1 = this.inserter.createNode(null, new Label[0]);
        index.add(id1, MapUtil.map((Object[])new Object[]{"name", "Mattias Persson", "email", "something@somewhere", "something", "bad"}));
        long id2 = this.inserter.createNode(null, new Label[0]);
        index.add(id2, MapUtil.map((Object[])new Object[]{"name", "Lars PerssoN"}));
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"Mattias Persson"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.query("name", (Object)"mattias"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.query("name", (Object)"bla"), new Long[0]);
        Neo4jTestCase.assertContains(index.query("name", (Object)"persson"), new Long[]{id1, id2});
        Neo4jTestCase.assertContains(index.query("email", (Object)"*@*"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.get("something", (Object)"bad"), new Long[]{id1});
        long id3 = this.inserter.createNode(null, new Label[0]);
        index.add(id3, MapUtil.map((Object[])new Object[]{"name", new String[]{"What Ever", "Anything"}}));
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"What Ever"), new Long[]{id3});
        Neo4jTestCase.assertContains(index.get("name", (Object)"Anything"), new Long[]{id3});
        provider.shutdown();
        this.switchToGraphDatabaseService(new ConfigurationParameter[0]);
        try (Transaction transaction = this.db.beginTx();){
            Index dbIndex = this.db.index().forNodes(name);
            Node node1 = this.db.getNodeById(id1);
            Node node2 = this.db.getNodeById(id2);
            Neo4jTestCase.assertContains(dbIndex.query("name", (Object)"persson"), new Node[]{node1, node2});
            transaction.success();
        }
    }

    @Test
    public void testCanIndexRelationships() {
        LuceneBatchInserterIndexProviderNewImpl indexProvider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        BatchInserterIndex edgesIndex = indexProvider.relationshipIndex("edgeIndex", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
        long nodeId1 = this.inserter.createNode(MapUtil.map((Object[])new Object[]{"ID", "1"}), new Label[0]);
        long nodeId2 = this.inserter.createNode(MapUtil.map((Object[])new Object[]{"ID", "2"}), new Label[0]);
        long relationshipId = this.inserter.createRelationship(nodeId1, nodeId2, (RelationshipType)EdgeType.KNOWS, null);
        edgesIndex.add(relationshipId, MapUtil.map((Object[])new Object[]{"EDGE_TYPE", EdgeType.KNOWS.name()}));
        edgesIndex.flush();
        Assert.assertEquals((String)String.format("Should return relationship id", new Object[0]), (Object)new Long(relationshipId), (Object)edgesIndex.query("EDGE_TYPE", (Object)EdgeType.KNOWS.name()).getSingle());
        indexProvider.shutdown();
    }

    @Test
    public void triggerNPEAfterFlush() {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        BatchInserterIndex index = provider.nodeIndex("Node-exact", LuceneIndexImplementation.EXACT_CONFIG);
        Map map = MapUtil.map((Object[])new Object[]{"name", "Something"});
        long node = this.inserter.createNode(map, new Label[0]);
        index.add(node, map);
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"Something"), new Long[]{node});
        provider.shutdown();
    }

    @Test
    public void testNumericValues() {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        BatchInserterIndex index = provider.nodeIndex("mine", LuceneIndexImplementation.EXACT_CONFIG);
        long node1 = this.inserter.createNode(null, new Label[0]);
        index.add(node1, MapUtil.map((Object[])new Object[]{"number", ValueContext.numeric((Number)45)}));
        long node2 = this.inserter.createNode(null, new Label[0]);
        index.add(node2, MapUtil.map((Object[])new Object[]{"number", ValueContext.numeric((Number)21)}));
        index.flush();
        Neo4jTestCase.assertContains(index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)21, (Integer)50, (boolean)true, (boolean)true)), new Long[]{node1, node2});
        provider.shutdown();
        this.switchToGraphDatabaseService(new ConfigurationParameter[0]);
        try (Transaction transaction = this.db.beginTx();){
            Node n1 = this.db.getNodeById(node1);
            this.db.getNodeById(node2);
            Index idx = this.db.index().forNodes("mine");
            Neo4jTestCase.assertContains(idx.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)21, (Integer)45, (boolean)false, (boolean)true)), new Node[]{n1});
            transaction.success();
        }
    }

    @Test
    public void testNumericValueArrays() {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        BatchInserterIndex batchIndex = provider.nodeIndex("mine", LuceneIndexImplementation.EXACT_CONFIG);
        long nodeId1 = this.inserter.createNode(null, new Label[0]);
        batchIndex.add(nodeId1, MapUtil.map((Object[])new Object[]{"number", new ValueContext[]{ValueContext.numeric((Number)45), ValueContext.numeric((Number)98)}}));
        long nodeId2 = this.inserter.createNode(null, new Label[0]);
        batchIndex.add(nodeId2, MapUtil.map((Object[])new Object[]{"number", new ValueContext[]{ValueContext.numeric((Number)47), ValueContext.numeric((Number)100)}}));
        batchIndex.flush();
        IndexHits batchIndexResult1 = batchIndex.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)true, (boolean)true));
        Assert.assertThat((Object)batchIndexResult1, Contains.contains(nodeId1, nodeId2));
        Assert.assertThat((Object)batchIndexResult1.size(), (Matcher)Is.is((Object)2));
        IndexHits batchIndexResult2 = batchIndex.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)44, (Integer)46, (boolean)true, (boolean)true));
        Assert.assertThat((Object)batchIndexResult2, Contains.contains(nodeId1));
        Assert.assertThat((Object)batchIndexResult2.size(), (Matcher)Is.is((Object)1));
        IndexHits batchIndexResult3 = batchIndex.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)99, (Integer)101, (boolean)true, (boolean)true));
        Assert.assertThat((Object)batchIndexResult3, Contains.contains(nodeId2));
        Assert.assertThat((Object)batchIndexResult3.size(), (Matcher)Is.is((Object)1));
        IndexHits batchIndexResult4 = batchIndex.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)false, (boolean)false));
        Assert.assertThat((Object)batchIndexResult4, (Matcher)Matchers.emptyIterable());
        provider.shutdown();
        this.switchToGraphDatabaseService(new ConfigurationParameter[0]);
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = this.db.getNodeById(nodeId1);
            Node node2 = this.db.getNodeById(nodeId2);
            Index index = this.db.index().forNodes("mine");
            IndexHits indexResult1 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)true, (boolean)true));
            Assert.assertThat((Object)indexResult1, Contains.contains(node1, node2));
            Assert.assertThat((Object)indexResult1.size(), (Matcher)Is.is((Object)2));
            IndexHits indexResult2 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)44, (Integer)46, (boolean)true, (boolean)true));
            Assert.assertThat((Object)indexResult2, Contains.contains(node1));
            Assert.assertThat((Object)indexResult2.size(), (Matcher)Is.is((Object)1));
            IndexHits indexResult3 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)99, (Integer)101, (boolean)true, (boolean)true));
            Assert.assertThat((Object)indexResult3, Contains.contains(node2));
            Assert.assertThat((Object)indexResult3.size(), (Matcher)Is.is((Object)1));
            IndexHits indexResult4 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)false, (boolean)false));
            Assert.assertThat((Object)indexResult4, (Matcher)Matchers.emptyIterable());
            transaction.success();
        }
    }

    @Test
    public void indexNumbers() throws Exception {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        BatchInserterIndex index = provider.nodeIndex("mine", LuceneIndexImplementation.EXACT_CONFIG);
        long id = this.inserter.createNode(null, new Label[0]);
        HashMap<String, Long> props = new HashMap<String, Long>();
        props.put("key", 123L);
        index.add(id, props);
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)123L).size());
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)"123").size());
        provider.shutdown();
    }

    @Test
    public void shouldCreateAutoIndexThatIsUsableInEmbedded() throws Exception {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        BatchInserterIndex index = provider.nodeIndex("node_auto_index", LuceneIndexImplementation.EXACT_CONFIG);
        long id = this.inserter.createNode(null, new Label[0]);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "peter");
        index.add(id, props);
        index.flush();
        provider.shutdown();
        this.shutdownInserter();
        this.switchToGraphDatabaseService(TestLuceneBatchInsert.configure(GraphDatabaseSettings.node_keys_indexable, "name"), TestLuceneBatchInsert.configure(GraphDatabaseSettings.relationship_keys_indexable, "relProp1,relProp2"), TestLuceneBatchInsert.configure(GraphDatabaseSettings.node_auto_indexing, "true"), TestLuceneBatchInsert.configure(GraphDatabaseSettings.relationship_auto_indexing, "true"));
        try (Transaction tx = this.db.beginTx();){
            Node node1 = this.db.createNode();
            node1.setProperty("name", (Object)"bob");
            tx.success();
        }
        tx = this.db.beginTx();
        var7_6 = null;
        try {
            Assert.assertTrue((boolean)this.db.index().getNodeAutoIndexer().getAutoIndex().get("name", (Object)"peter").hasNext());
            Assert.assertTrue((boolean)this.db.index().getNodeAutoIndexer().getAutoIndex().get("name", (Object)"bob").hasNext());
            Assert.assertFalse((boolean)this.db.index().getNodeAutoIndexer().getAutoIndex().get("name", (Object)"joe").hasNext());
            tx.success();
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void addOrUpdateFlushBehaviour() throws Exception {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        BatchInserterIndex index = provider.nodeIndex("update", LuceneIndexImplementation.EXACT_CONFIG);
        long id = this.inserter.createNode(null, new Label[0]);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("key", "value");
        index.add(id, props);
        index.updateOrAdd(id, props);
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)"value").size());
        index.flush();
        props.put("key", "value2");
        index.updateOrAdd(id, props);
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)"value2").size());
        Assert.assertEquals((long)0L, (long)index.get("key", (Object)"value").size());
        props.put("key2", "value2");
        props.put("key", "value");
        index.updateOrAdd(id, props);
        Assert.assertEquals((long)0L, (long)index.get("key2", (Object)"value2").size());
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("key2", (Object)"value2").size());
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)"value").size());
        long id2 = this.inserter.createNode(null, new Label[0]);
        props = new HashMap();
        props.put("2key", "value");
        index.updateOrAdd(id2, props);
        props.put("2key", "value2");
        props.put("2key2", "value3");
        index.updateOrAdd(id2, props);
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("2key", (Object)"value2").size());
        provider.shutdown();
    }

    @Test
    public void useStandardAnalyzer() throws Exception {
        LuceneBatchInserterIndexProviderNewImpl provider = new LuceneBatchInserterIndexProviderNewImpl(this.inserter);
        BatchInserterIndex index = provider.nodeIndex("myindex", MapUtil.stringMap((String[])new String[]{"analyzer", MyStandardAnalyzer.class.getName()}));
        index.add(0L, MapUtil.map((Object[])new Object[]{"name", "Mattias"}));
        provider.shutdown();
    }

    @Test
    public void cachesShouldBeFilledWhenAddToMultipleIndexesCreatedNow() throws Exception {
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider(this.inserter);
        BatchInserterIndex index = provider.nodeIndex("index1", LuceneIndexImplementation.EXACT_CONFIG);
        index.setCacheCapacity("name", 100000);
        String nameKey = "name";
        String titleKey = "title";
        this.assertCacheIsEmpty(index, nameKey, titleKey);
        index.add(0L, MapUtil.map((Object[])new Object[]{"name", "Neo", "title", "Matrix"}));
        this.assertCacheContainsSomething(index, nameKey);
        this.assertCacheIsEmpty(index, titleKey);
        BatchInserterIndex index2 = provider.nodeIndex("index2", LuceneIndexImplementation.EXACT_CONFIG);
        index2.setCacheCapacity("title", 100000);
        this.assertCacheIsEmpty(index2, nameKey, titleKey);
        index2.add(0L, MapUtil.map((Object[])new Object[]{"name", "Neo", "title", "Matrix"}));
        this.assertCacheContainsSomething(index2, titleKey);
        this.assertCacheIsEmpty(index2, nameKey);
        provider.shutdown();
    }

    @Test
    public void cachesDoesntGetFilledWhenAddingForAnExistingIndex() throws Exception {
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider(this.inserter);
        String indexName = "index";
        BatchInserterIndex index = provider.nodeIndex(indexName, LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        index.add(0L, MapUtil.map((Object[])new Object[]{key, "Mattias"}));
        provider.shutdown();
        this.shutdownInserter();
        this.startInserter();
        provider = new LuceneBatchInserterIndexProvider(this.inserter);
        index = provider.nodeIndex(indexName, LuceneIndexImplementation.EXACT_CONFIG);
        index.setCacheCapacity(key, 100000);
        this.assertCacheIsEmpty(index, key);
        index.add(1L, MapUtil.map((Object[])new Object[]{key, "Persson"}));
        index.flush();
        this.assertCacheIsEmpty(index, key);
        Assert.assertEquals((long)1L, (long)((Long)index.get(key, (Object)"Persson").getSingle()).intValue());
        provider.shutdown();
    }

    @Test
    public void shouldKeepAroundUnusedIndexesAfterConsecutiveInsertion() throws Exception {
        String indexName1 = "first";
        String indexName2 = "second";
        String key = "name";
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider(this.inserter);
        BatchInserterIndex index1 = provider.nodeIndex(indexName1, LuceneIndexImplementation.EXACT_CONFIG);
        index1.add(0L, MapUtil.map((Object[])new Object[]{key, "Mattias"}));
        BatchInserterIndex index2 = provider.nodeIndex(indexName1, LuceneIndexImplementation.EXACT_CONFIG);
        index2.add(0L, MapUtil.map((Object[])new Object[]{key, "Mattias"}));
        provider.shutdown();
        this.shutdownInserter();
        this.startInserter();
        provider = new LuceneBatchInserterIndexProvider(this.inserter);
        BatchInserterIndex index22 = provider.nodeIndex(indexName2, LuceneIndexImplementation.EXACT_CONFIG);
        index22.add(1L, MapUtil.map((Object[])new Object[]{key, "Mattias"}));
        provider.shutdown();
        this.shutdownInserter();
        this.switchToGraphDatabaseService(new ConfigurationParameter[0]);
        try (Transaction transaction = this.db.beginTx();){
            Assert.assertTrue((String)(indexName1 + " should exist"), (boolean)this.db.index().existsForNodes(indexName1));
            Assert.assertTrue((String)(indexName2 + " should exist"), (boolean)this.db.index().existsForNodes(indexName2));
            transaction.success();
        }
    }

    private void assertCacheContainsSomething(BatchInserterIndex index, String ... keys) {
        Map<String, LruCache<String, Collection<Long>>> cache = this.getIndexCache(index);
        for (String key : keys) {
            Assert.assertTrue((cache.get(key).size() > 0 ? 1 : 0) != 0);
        }
    }

    private void assertCacheIsEmpty(BatchInserterIndex index, String ... keys) {
        Map<String, LruCache<String, Collection<Long>>> cache = this.getIndexCache(index);
        for (String key : keys) {
            LruCache<String, Collection<Long>> keyCache = cache.get(key);
            Assert.assertTrue((keyCache == null || keyCache.size() == 0 ? 1 : 0) != 0);
        }
    }

    private Map<String, LruCache<String, Collection<Long>>> getIndexCache(BatchInserterIndex index) {
        try {
            Field field = index.getClass().getDeclaredField("cache");
            field.setAccessible(true);
            return (Map)field.get(index);
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    private Predicate<? super KernelExtensionFactory> onlyRealLuceneExtensions() {
        return extension -> extension instanceof LuceneLabelScanStoreExtension || extension instanceof LuceneSchemaIndexProviderFactory;
    }

    private void switchToGraphDatabaseService(ConfigurationParameter ... config) {
        this.shutdownInserter();
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir);
        for (ConfigurationParameter configurationParameter : config) {
            builder = builder.setConfig(configurationParameter.key, configurationParameter.value);
        }
        this.db = builder.newGraphDatabase();
    }

    private static ConfigurationParameter configure(Setting<?> key, String value) {
        return new ConfigurationParameter(key, value);
    }

    private void shutdownInserter() {
        if (this.inserter != null) {
            this.inserter.shutdown();
            this.inserter = null;
        }
    }

    private static class ConfigurationParameter {
        private final Setting<?> key;
        private final String value;

        ConfigurationParameter(Setting<?> key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    private static enum EdgeType implements RelationshipType
    {
        KNOWS;

    }
}

