/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IndexingServiceIntegrationTest {
    private static final String FOOD_LABEL = "food";
    private static final String CLOTHES_LABEL = "clothes";
    private static final String WEATHER_LABEL = "weather";
    private static final String PROPERTY_NAME = "name";
    private static final SchemaIndexProvider.Descriptor indexDescriptor = LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private GraphDatabaseService database;

    @Before
    public void setUp() {
        EphemeralFileSystemAbstraction fileSystem = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        this.database = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).addKernelExtension((KernelExtensionFactory)new LuceneSchemaIndexProviderFactory()).newImpermanentDatabase();
        this.createData(this.database, 100);
    }

    @After
    public void tearDown() {
        try {
            this.database.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testManualIndexPopulation() throws IOException, IndexNotFoundKernelException, InterruptedException {
        IndexingService indexingService = this.getIndexingService(this.database);
        SchemaStore schemaStore = this.getSchemaStore(this.database);
        LabelTokenHolder labelTokenHolder = this.getLabelTokenHolder(this.database);
        PropertyKeyTokenHolder propertyKeyTokenHolder = this.getPropertyKeyTokenHolder(this.database);
        int foodId = labelTokenHolder.getIdByName(FOOD_LABEL);
        int propertyId = propertyKeyTokenHolder.getIdByName(PROPERTY_NAME);
        IndexRule rule = IndexRule.indexRule((long)schemaStore.nextId(), (IndexDescriptor)IndexDescriptorFactory.forLabel((int)foodId, (int[])new int[]{propertyId}), (SchemaIndexProvider.Descriptor)indexDescriptor);
        indexingService.createIndexes(new IndexRule[]{rule});
        IndexProxy indexProxy = indexingService.getIndexProxy(rule.getId());
        this.waitIndexOnline(indexProxy);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assert.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @Test
    public void testSchemaIndexMatchIndexingService() throws IndexNotFoundKernelException, IOException {
        try (Transaction transaction = this.database.beginTx();){
            this.database.schema().constraintFor(Label.label((String)CLOTHES_LABEL)).assertPropertyIsUnique(PROPERTY_NAME).create();
            this.database.schema().indexFor(Label.label((String)WEATHER_LABEL)).on(PROPERTY_NAME).create();
            transaction.success();
        }
        transaction = this.database.beginTx();
        var2_2 = null;
        try {
            this.database.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        LabelTokenHolder labelTokenHolder = this.getLabelTokenHolder(this.database);
        PropertyKeyTokenHolder propertyKeyTokenHolder = this.getPropertyKeyTokenHolder(this.database);
        int clothedLabelId = labelTokenHolder.getIdByName(CLOTHES_LABEL);
        int weatherLabelId = labelTokenHolder.getIdByName(WEATHER_LABEL);
        int propertyId = propertyKeyTokenHolder.getIdByName(PROPERTY_NAME);
        IndexProxy clothesIndex = indexingService.getIndexProxy(SchemaDescriptorFactory.forLabel((int)clothedLabelId, (int[])new int[]{propertyId}));
        IndexProxy weatherIndex = indexingService.getIndexProxy(SchemaDescriptorFactory.forLabel((int)weatherLabelId, (int[])new int[]{propertyId}));
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)clothesIndex.getState());
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)weatherIndex.getState());
    }

    @Test
    public void failForceIndexesWhenOneOfTheIndexesIsBroken() throws Exception {
        Object transaction;
        String constraintLabelPrefix = "ConstraintLabel";
        String constraintPropertyPrefix = "ConstraintProperty";
        String indexLabelPrefix = "Label";
        String indexPropertyPrefix = "Property";
        for (int i = 0; i < 10; ++i) {
            transaction = this.database.beginTx();
            Throwable throwable = null;
            try {
                this.database.schema().constraintFor(Label.label((String)(constraintLabelPrefix + i))).assertPropertyIsUnique(constraintPropertyPrefix + i).create();
                this.database.schema().indexFor(Label.label((String)(indexLabelPrefix + i))).on(indexPropertyPrefix + i).create();
                transaction.success();
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (transaction != null) {
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        Transaction ignored = this.database.beginTx();
        transaction = null;
        try {
            this.database.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            transaction = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (transaction != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)transaction).addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        LabelTokenHolder labelTokenHolder = this.getLabelTokenHolder(this.database);
        PropertyKeyTokenHolder propertyKeyTokenHolder = this.getPropertyKeyTokenHolder(this.database);
        int indexLabel7 = labelTokenHolder.getIdByName(indexLabelPrefix + 7);
        int indexProperty7 = propertyKeyTokenHolder.getIdByName(indexPropertyPrefix + 7);
        IndexProxy index = indexingService.getIndexProxy(IndexDescriptorFactory.forLabel((int)indexLabel7, (int[])new int[]{indexProperty7}).schema());
        index.drop();
        this.expectedException.expect(UnderlyingStorageException.class);
        this.expectedException.expectMessage("Unable to force");
        indexingService.forceAll();
    }

    private PropertyKeyTokenHolder getPropertyKeyTokenHolder(GraphDatabaseService database) {
        return (PropertyKeyTokenHolder)this.getDependencyResolver(database).resolveDependency(PropertyKeyTokenHolder.class);
    }

    private void waitIndexOnline(IndexProxy indexProxy) throws InterruptedException {
        while (InternalIndexState.ONLINE != indexProxy.getState()) {
            Thread.sleep(10L);
        }
    }

    private SchemaStore getSchemaStore(GraphDatabaseService database) {
        NeoStores neoStores = ((RecordStorageEngine)this.getDependencyResolver(database).resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        return neoStores.getSchemaStore();
    }

    private IndexingService getIndexingService(GraphDatabaseService database) {
        return (IndexingService)this.getDependencyResolver(database).resolveDependency(IndexingService.class);
    }

    private LabelTokenHolder getLabelTokenHolder(GraphDatabaseService database) {
        return (LabelTokenHolder)this.getDependencyResolver(database).resolveDependency(LabelTokenHolder.class);
    }

    private DependencyResolver getDependencyResolver(GraphDatabaseService database) {
        return ((GraphDatabaseAPI)database).getDependencyResolver();
    }

    private void createData(GraphDatabaseService database, int numberOfNodes) {
        int index = 0;
        while (index < numberOfNodes) {
            Transaction transaction = database.beginTx();
            Throwable throwable = null;
            try {
                Node node = database.createNode(new Label[]{Label.label((String)FOOD_LABEL), Label.label((String)CLOTHES_LABEL), Label.label((String)WEATHER_LABEL)});
                node.setProperty(PROPERTY_NAME, (Object)("Node" + index++));
                transaction.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (transaction == null) continue;
                if (throwable != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                transaction.close();
            }
        }
    }
}

