/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class ConstraintCreationIT {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(ConstraintCreationIT.class);
    private static final Label LABEL = Label.label((String)"label1");
    private static final String INDEX_IDENTIFIER = "1";

    @Test
    public void shouldNotLeaveLuceneIndexFilesHangingAroundIfConstraintCreationFails() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                Node node1 = db.createNode(new Label[]{LABEL});
                node1.setProperty("prop", (Object)true);
            }
            tx.success();
        }
        try {
            tx = db.beginTx();
            var3_4 = null;
            try {
                db.schema().constraintFor(LABEL).assertPropertyIsUnique("prop").create();
                Assert.fail((String)"Should have failed with ConstraintViolationException");
                tx.success();
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var3_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (ConstraintViolationException tx2) {
            // empty catch block
        }
        var3_4 = null;
        try (Transaction ignore = db.beginTx();){
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)db.schema().getIndexes()));
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
        SchemaIndexProvider schemaIndexProvider = (SchemaIndexProvider)db.getDependencyResolver().resolveDependency(SchemaIndexProvider.class);
        File schemaStoreDir = schemaIndexProvider.getSchemaIndexStoreDirectory(new File(db.getStoreDir()));
        Assert.assertFalse((boolean)new IndexFolderLayout(schemaStoreDir, INDEX_IDENTIFIER).getIndexFolder().exists());
    }
}

