/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.index.IndexReaderStub;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartition;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexSample;

public class NonUniqueDatabaseIndexSamplerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final IndexSearcher indexSearcher = (IndexSearcher)Mockito.mock(IndexSearcher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final TaskCoordinator taskControl = new TaskCoordinator(0L, TimeUnit.MILLISECONDS);
    private final IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());

    @Test
    public void nonUniqueSamplingCancel() throws IndexNotFoundKernelException, IOException {
        Terms terms = this.getTerms("test", 1);
        Map fieldTermsMap = MapUtil.genericMap((Object[])new Object[]{"0string", terms, "id", terms, "0string", terms});
        IndexReaderStub indexReader = new IndexReaderStub(new SamplingFields(fieldTermsMap));
        Mockito.when((Object)this.indexSearcher.getIndexReader()).thenReturn((Object)indexReader);
        this.expectedException.expect(IndexNotFoundKernelException.class);
        this.expectedException.expectMessage("Index dropped while sampling.");
        NonUniqueLuceneIndexSampler luceneIndexSampler = this.createSampler();
        this.taskControl.cancel();
        luceneIndexSampler.sampleIndex();
    }

    @Test
    public void nonUniqueIndexSampling() throws Exception {
        Terms aTerms = this.getTerms("a", 1);
        Terms idTerms = this.getTerms("id", 2);
        Terms bTerms = this.getTerms("b", 3);
        Map fieldTermsMap = MapUtil.genericMap((Object[])new Object[]{"0string", aTerms, "id", idTerms, "0array", bTerms});
        IndexReaderStub indexReader = new IndexReaderStub(new SamplingFields(fieldTermsMap));
        indexReader.setElements(new String[4]);
        Mockito.when((Object)this.indexSearcher.getIndexReader()).thenReturn((Object)indexReader);
        Assert.assertEquals((Object)new IndexSample(4L, 2L, 4L), (Object)this.createSampler().sampleIndex());
    }

    @Test
    public void samplingOfLargeNumericValues() throws Exception {
        try (RAMDirectory dir = new RAMDirectory();
             WritableIndexPartition indexPartition = new WritableIndexPartition(new File("testPartition"), (Directory)dir, IndexWriterConfigs.standard());){
            NonUniqueDatabaseIndexSamplerTest.insertDocument(indexPartition, 1L, Long.MAX_VALUE);
            NonUniqueDatabaseIndexSamplerTest.insertDocument(indexPartition, 2L, Integer.MAX_VALUE);
            indexPartition.maybeRefreshBlocking();
            try (PartitionSearcher searcher = indexPartition.acquireSearcher();){
                NonUniqueLuceneIndexSampler sampler = new NonUniqueLuceneIndexSampler(searcher.getIndexSearcher(), this.taskControl.newInstance(), new IndexSamplingConfig(Config.empty()));
                Assert.assertEquals((Object)new IndexSample(2L, 2L, 2L), (Object)sampler.sampleIndex());
            }
        }
    }

    private NonUniqueLuceneIndexSampler createSampler() {
        return new NonUniqueLuceneIndexSampler(this.indexSearcher, this.taskControl.newInstance(), this.indexSamplingConfig);
    }

    private Terms getTerms(String value, int frequency) throws IOException {
        TermsEnum termsEnum = (TermsEnum)Mockito.mock(TermsEnum.class);
        Terms terms = (Terms)Mockito.mock(Terms.class);
        Mockito.when((Object)terms.iterator()).thenReturn((Object)termsEnum);
        Mockito.when((Object)termsEnum.next()).thenReturn((Object)new BytesRef(value.getBytes())).thenReturn(null);
        Mockito.when((Object)termsEnum.docFreq()).thenReturn((Object)frequency);
        return terms;
    }

    private static void insertDocument(WritableIndexPartition partition, long nodeId, Object propertyValue) throws IOException {
        Document doc = LuceneDocumentStructure.documentRepresentingProperties((long)nodeId, (Object[])new Object[]{propertyValue});
        partition.getIndexWriter().addDocument((Iterable)doc);
    }

    private class SamplingFields
    extends Fields {
        private Map<String, Terms> fieldTermsMap;

        SamplingFields(Map<String, Terms> fieldTermsMap) {
            this.fieldTermsMap = fieldTermsMap;
        }

        public Iterator<String> iterator() {
            return this.fieldTermsMap.keySet().iterator();
        }

        public Terms terms(String field) throws IOException {
            return this.fieldTermsMap.get(field);
        }

        public int size() {
            return this.fieldTermsMap.size();
        }
    }
}

