/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;

public class SimpleIndexReaderTest {
    private final PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
    private final IndexSearcher indexSearcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
    private final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.empty());
    private final TaskCoordinator taskCoordinator = new TaskCoordinator(0L, TimeUnit.MILLISECONDS);

    @Before
    public void setUp() {
        Mockito.when((Object)this.partitionSearcher.getIndexSearcher()).thenReturn((Object)this.indexSearcher);
    }

    @Test
    public void releaseSearcherOnClose() throws IOException {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher)).close();
    }

    @Test
    public void seekQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"test")});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)org.mockito.Matchers.any(TermQuery.class), (Collector)org.mockito.Matchers.any(DocValuesCollector.class));
    }

    @Test
    public void scanQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.exists((int)1)});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)org.mockito.Matchers.any(MatchAllDocsQuery.class), (Collector)org.mockito.Matchers.any(DocValuesCollector.class));
    }

    @Test
    public void stringRangeSeekQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"a", (boolean)false, (String)"b", (boolean)true)});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)org.mockito.Matchers.any(TermQuery.class), (Collector)org.mockito.Matchers.any(DocValuesCollector.class));
    }

    @Test
    public void prefixRangeSeekQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.stringPrefix((int)1, (String)"bb")});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)org.mockito.Matchers.any(PrefixQuery.class), (Collector)org.mockito.Matchers.any(DocValuesCollector.class));
    }

    @Test
    public void numberRangeSeekQueryReachSearcher() throws Exception {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)7, (boolean)true, (Number)8, (boolean)true)});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)org.mockito.Matchers.any(NumericRangeQuery.class), (Collector)org.mockito.Matchers.any(DocValuesCollector.class));
    }

    @Test
    public void countIndexedNodesReachSearcher() throws IOException {
        SimpleIndexReader simpleIndexReader = this.getUniqueSimpleReader();
        simpleIndexReader.countIndexedNodes(2L, new Object[]{"testValue"});
        ((IndexSearcher)Mockito.verify((Object)this.indexSearcher)).search((Query)org.mockito.Matchers.any(BooleanQuery.class), (Collector)org.mockito.Matchers.any(DocValuesCollector.class));
    }

    @Test
    public void uniqueIndexSamplerForUniqueIndex() {
        SimpleIndexReader uniqueSimpleReader = this.getUniqueSimpleReader();
        Assert.assertThat((Object)uniqueSimpleReader.createSampler(), (Matcher)Matchers.instanceOf(UniqueLuceneIndexSampler.class));
    }

    @Test
    public void nonUuniqueIndexSamplerForNonUniqueIndex() {
        SimpleIndexReader uniqueSimpleReader = this.getNonUniqueSimpleReader();
        Assert.assertThat((Object)uniqueSimpleReader.createSampler(), (Matcher)Matchers.instanceOf(NonUniqueLuceneIndexSampler.class));
    }

    private SimpleIndexReader getNonUniqueSimpleReader() {
        return new SimpleIndexReader(this.partitionSearcher, IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), this.samplingConfig, this.taskCoordinator);
    }

    private SimpleIndexReader getUniqueSimpleReader() {
        return new SimpleIndexReader(this.partitionSearcher, IndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{0}), this.samplingConfig, this.taskCoordinator);
    }
}

