/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class UniqueDatabaseIndexPopulatingUpdaterTest {
    private static final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{42});

    @Test
    public void removeNotSupported() {
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater();
        try {
            updater.remove(PrimitiveLongCollections.setOf((long[])new long[]{1L, 2L, 3L}));
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(UnsupportedOperationException.class));
        }
    }

    @Test
    public void closeVerifiesUniquenessOfAddedValues() throws Exception {
        SchemaIndex index = (SchemaIndex)Mockito.mock(SchemaIndex.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(index);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"baz"}));
        Mockito.verifyZeroInteractions((Object[])new Object[]{index});
        updater.close();
        ((SchemaIndex)Mockito.verify((Object)index)).verifyUniqueness((PropertyAccessor)org.mockito.Matchers.any(), (int[])org.mockito.Matchers.eq((Object)descriptor.getPropertyIds()), (List)org.mockito.Matchers.eq(Arrays.asList("foo", "bar", "baz")));
    }

    @Test
    public void closeVerifiesUniquenessOfChangedValues() throws Exception {
        SchemaIndex index = (SchemaIndex)Mockito.mock(SchemaIndex.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(index);
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)descriptor, (Object)"foo1", (Object)"foo2"));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)descriptor, (Object)"bar1", (Object)"bar2"));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)descriptor, (Object)"baz1", (Object)"baz2"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{index});
        updater.close();
        ((SchemaIndex)Mockito.verify((Object)index)).verifyUniqueness((PropertyAccessor)org.mockito.Matchers.any(), (int[])org.mockito.Matchers.eq((Object)descriptor.getPropertyIds()), (List)org.mockito.Matchers.eq(Arrays.asList("foo2", "bar2", "baz2")));
    }

    @Test
    public void closeVerifiesUniquenessOfAddedAndChangedValues() throws Exception {
        SchemaIndex index = (SchemaIndex)Mockito.mock(SchemaIndex.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(index);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"added1"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"added2"}));
        updater.process(IndexEntryUpdate.change((long)3L, (LabelSchemaSupplier)descriptor, (Object)"before1", (Object)"after1"));
        updater.process(IndexEntryUpdate.change((long)4L, (LabelSchemaSupplier)descriptor, (Object)"before2", (Object)"after2"));
        updater.process(IndexEntryUpdate.remove((long)5L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"removed1"}));
        Mockito.verifyZeroInteractions((Object[])new Object[]{index});
        updater.close();
        List<Object> toBeVerified = Arrays.asList("added1", "added2", "after1", "after2");
        ((SchemaIndex)Mockito.verify((Object)index)).verifyUniqueness((PropertyAccessor)org.mockito.Matchers.any(), (int[])org.mockito.Matchers.eq((Object)descriptor.getPropertyIds()), (List)org.mockito.Matchers.eq(toBeVerified));
    }

    @Test
    public void addedNodePropertiesIncludedInSample() throws Exception {
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"baz"}));
        updater.process(IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"qux"}));
        UniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L);
    }

    @Test
    public void changedNodePropertiesDoNotInfluenceSample() throws Exception {
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)descriptor, (Object)"before1", (Object)"after1"));
        updater.process(IndexEntryUpdate.change((long)2L, (LabelSchemaSupplier)descriptor, (Object)"before2", (Object)"after2"));
        UniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 0L);
    }

    @Test
    public void removedNodePropertyIncludedInSample() throws Exception {
        long initialValue = 10L;
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        sampler.increment(initialValue);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.remove((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"removed1"}));
        updater.process(IndexEntryUpdate.remove((long)2L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"removed2"}));
        UniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, initialValue - 2L);
    }

    @Test
    public void nodePropertyUpdatesIncludedInSample() throws Exception {
        UniqueIndexSampler sampler = new UniqueIndexSampler();
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)descriptor, (Object)"foo", (Object)"bar"));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"baz"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"qux"}));
        updater.process(IndexEntryUpdate.remove((long)4L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"qux"}));
        UniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 2L);
    }

    @Test
    public void additionsDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"qux"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)1L), LuceneDocumentStructure.documentRepresentingProperties((long)1L, (Object[])new Object[]{"foo"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)2L), LuceneDocumentStructure.documentRepresentingProperties((long)2L, (Object[])new Object[]{"bar"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)3L), LuceneDocumentStructure.documentRepresentingProperties((long)3L, (Object[])new Object[]{"qux"}));
    }

    @Test
    public void changesDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)descriptor, (Object)"before1", (Object)"after1"));
        updater.process(IndexEntryUpdate.change((long)2L, (LabelSchemaSupplier)descriptor, (Object)"before2", (Object)"after2"));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)1L), LuceneDocumentStructure.documentRepresentingProperties((long)1L, (Object[])new Object[]{"after1"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)2L), LuceneDocumentStructure.documentRepresentingProperties((long)2L, (Object[])new Object[]{"after2"}));
    }

    @Test
    public void removalsDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        UniqueLuceneIndexPopulatingUpdater updater = UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        updater.process(IndexEntryUpdate.remove((long)1L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.remove((long)2L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.remove((long)3L, (LabelSchemaSupplier)descriptor, (Object[])new Object[]{"baz"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)1L));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)2L));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)3L));
    }

    private static void verifySamplingResult(UniqueIndexSampler sampler, long expectedValue) {
        IndexSample sample = sampler.result();
        Assert.assertEquals((long)expectedValue, (long)sample.indexSize());
        Assert.assertEquals((long)expectedValue, (long)sample.uniqueValues());
        Assert.assertEquals((long)expectedValue, (long)sample.sampleSize());
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater() {
        return UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(new UniqueIndexSampler());
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater(SchemaIndex index) {
        return UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(index, (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class), new UniqueIndexSampler());
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater(LuceneIndexWriter writer) {
        return UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater((SchemaIndex)Mockito.mock(SchemaIndex.class), writer, new UniqueIndexSampler());
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater(UniqueIndexSampler sampler) {
        return UniqueDatabaseIndexPopulatingUpdaterTest.newUpdater((SchemaIndex)Mockito.mock(SchemaIndex.class), (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class), sampler);
    }

    private static UniqueLuceneIndexPopulatingUpdater newUpdater(SchemaIndex index, LuceneIndexWriter writer, UniqueIndexSampler sampler) {
        return new UniqueLuceneIndexPopulatingUpdater(writer, descriptor.getPropertyIds(), index, (PropertyAccessor)Mockito.mock(PropertyAccessor.class), sampler);
    }
}

