/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LuceneIndexRecoveryIT {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final String NUM_BANANAS_KEY = "number_of_bananas_owned";
    private static final Label myLabel = Label.label((String)"MyLabel");
    private GraphDatabaseAPI db;
    private DirectoryFactory directoryFactory;

    @Before
    public void before() {
        this.directoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    }

    @After
    public void after() {
        if (this.db != null) {
            this.db.shutdown();
        }
        this.directoryFactory.close();
    }

    @Test
    public void addShouldBeIdempotentWhenDoingRecovery() throws Exception {
        this.startDb(this.createLuceneIndexFactory());
        IndexDefinition index = this.createIndex(myLabel);
        this.waitForIndex(index);
        long nodeId = this.createNode(myLabel, 12);
        try (Transaction tx = this.db.beginTx();){
            Assert.assertNotNull((Object)this.db.getNodeById(nodeId));
        }
        Assert.assertEquals((long)1L, (long)this.doIndexLookup(myLabel, 12).size());
        this.killDb();
        this.startDb(this.createLuceneIndexFactory());
        tx = this.db.beginTx();
        var5_4 = null;
        try {
            Assert.assertNotNull((Object)this.db.getNodeById(nodeId));
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)this.doIndexLookup(myLabel, 12).size());
    }

    @Test
    public void changeShouldBeIdempotentWhenDoingRecovery() throws Exception {
        this.startDb(this.createLuceneIndexFactory());
        IndexDefinition indexDefinition = this.createIndex(myLabel);
        this.waitForIndex(indexDefinition);
        long node = this.createNode(myLabel, 12);
        this.rotateLogsAndCheckPoint();
        this.updateNode(node, 13);
        this.killDb();
        this.startDb(this.createLuceneIndexFactory());
        Assert.assertEquals((long)0L, (long)this.doIndexLookup(myLabel, 12).size());
        Assert.assertEquals((long)1L, (long)this.doIndexLookup(myLabel, 13).size());
    }

    @Test
    public void removeShouldBeIdempotentWhenDoingRecovery() throws Exception {
        this.startDb(this.createLuceneIndexFactory());
        IndexDefinition indexDefinition = this.createIndex(myLabel);
        this.waitForIndex(indexDefinition);
        long node = this.createNode(myLabel, 12);
        this.rotateLogsAndCheckPoint();
        this.deleteNode(node);
        this.killDb();
        this.startDb(this.createLuceneIndexFactory());
        Assert.assertEquals((long)0L, (long)this.doIndexLookup(myLabel, 12).size());
    }

    @Test
    public void shouldNotAddTwiceDuringRecoveryIfCrashedDuringPopulation() throws Exception {
        this.startDb(this.createAlwaysInitiallyPopulatingLuceneIndexFactory());
        IndexDefinition indexDefinition = this.createIndex(myLabel);
        this.waitForIndex(indexDefinition);
        long nodeId = this.createNode(myLabel, 12);
        Assert.assertEquals((long)1L, (long)this.doIndexLookup(myLabel, 12).size());
        this.killDb();
        this.startDb(this.createAlwaysInitiallyPopulatingLuceneIndexFactory());
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = (IndexDefinition)this.db.schema().getIndexes().iterator().next();
            this.waitForIndex(index);
            Assert.assertEquals((Object)12, (Object)this.db.getNodeById(nodeId).getProperty("number_of_bananas_owned"));
            Assert.assertEquals((long)1L, (long)this.doIndexLookup(myLabel, 12).size());
        }
    }

    @Test
    public void shouldNotUpdateTwiceDuringRecovery() throws Exception {
        this.startDb(this.createLuceneIndexFactory());
        IndexDefinition indexDefinition = this.createIndex(myLabel);
        this.waitForIndex(indexDefinition);
        long nodeId = this.createNode(myLabel, 12);
        this.updateNode(nodeId, 14);
        this.killDb();
        this.startDb(this.createLuceneIndexFactory());
        Assert.assertEquals((long)0L, (long)this.doIndexLookup(myLabel, 12).size());
        Assert.assertEquals((long)1L, (long)this.doIndexLookup(myLabel, 14).size());
    }

    private void startDb(KernelExtensionFactory<?> indexProviderFactory) {
        if (this.db != null) {
            this.db.shutdown();
        }
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem(this.fs.get());
        factory.addKernelExtensions(Arrays.asList(indexProviderFactory));
        this.db = (GraphDatabaseAPI)factory.newImpermanentDatabase();
    }

    private void killDb() throws Exception {
        if (this.db != null) {
            this.fs.snapshot(new Runnable(){

                @Override
                public void run() {
                    LuceneIndexRecoveryIT.this.db.shutdown();
                    LuceneIndexRecoveryIT.this.db = null;
                }
            });
        }
    }

    private void rotateLogsAndCheckPoint() throws IOException {
        ((LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
        ((CheckPointer)this.db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private IndexDefinition createIndex(Label label) {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition definition = this.db.schema().indexFor(label).on("number_of_bananas_owned").create();
            tx.success();
            IndexDefinition indexDefinition = definition;
            return indexDefinition;
        }
    }

    private void waitForIndex(IndexDefinition definition) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(definition, 10L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private Set<Node> doIndexLookup(Label myLabel, Object value) {
        try (Transaction tx = this.db.beginTx();){
            ResourceIterator iter = this.db.findNodes(myLabel, "number_of_bananas_owned", value);
            Set nodes = Iterators.asUniqueSet((Iterator)iter);
            tx.success();
            Set set = nodes;
            return set;
        }
    }

    private long createNode(Label label, int number) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{label});
            node.setProperty("number_of_bananas_owned", (Object)number);
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    private void updateNode(long nodeId, int value) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.getNodeById(nodeId);
            node.setProperty("number_of_bananas_owned", (Object)value);
            tx.success();
        }
    }

    private void deleteNode(long node) {
        try (Transaction tx = this.db.beginTx();){
            this.db.getNodeById(node).delete();
            tx.success();
        }
    }

    private KernelExtensionFactory<LuceneSchemaIndexProviderFactory.Dependencies> createAlwaysInitiallyPopulatingLuceneIndexFactory() {
        return new KernelExtensionFactory<LuceneSchemaIndexProviderFactory.Dependencies>(LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR.getKey()){

            public Class<LuceneSchemaIndexProviderFactory.Dependencies> getSettingsClass() {
                return LuceneSchemaIndexProviderFactory.Dependencies.class;
            }

            public Lifecycle newInstance(KernelContext context, LuceneSchemaIndexProviderFactory.Dependencies dependencies) throws Throwable {
                return new LuceneSchemaIndexProvider(LuceneIndexRecoveryIT.this.fs.get(), LuceneIndexRecoveryIT.this.directoryFactory, context.storeDir(), dependencies.getLogging().getInternalLogProvider(), dependencies.getConfig(), context.databaseInfo().operationalMode){

                    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
                        return InternalIndexState.POPULATING;
                    }
                };
            }
        };
    }

    private KernelExtensionFactory<LuceneSchemaIndexProviderFactory.Dependencies> createLuceneIndexFactory() {
        return new KernelExtensionFactory<LuceneSchemaIndexProviderFactory.Dependencies>(LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR.getKey()){

            public Lifecycle newInstance(KernelContext context, LuceneSchemaIndexProviderFactory.Dependencies dependencies) throws Throwable {
                return new LuceneSchemaIndexProvider(LuceneIndexRecoveryIT.this.fs.get(), LuceneIndexRecoveryIT.this.directoryFactory, context.storeDir(), dependencies.getLogging().getInternalLogProvider(), dependencies.getConfig(), context.databaseInfo().operationalMode){

                    public int compareTo(SchemaIndexProvider o) {
                        return 1;
                    }
                };
            }
        };
    }
}

