/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import junit.framework.TestCase;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.ValueEncoding;

public class LuceneDocumentStructureTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void stringWithMaximumLengthShouldBeAllowed() {
        String longestString = RandomStringUtils.randomAscii((int)32766);
        Document document = LuceneDocumentStructure.documentRepresentingProperties((long)123L, (Object[])new Object[]{longestString});
        TestCase.assertEquals((String)longestString, (String)document.getField(ValueEncoding.String.key(0)).stringValue());
    }

    @Test
    public void shouldBuildDocumentRepresentingStringProperty() throws Exception {
        Document document = LuceneDocumentStructure.documentRepresentingProperties((long)123L, (Object[])new Object[]{"hello"});
        TestCase.assertEquals((String)"123", (String)document.get("id"));
        TestCase.assertEquals((String)"hello", (String)document.get(ValueEncoding.String.key(0)));
    }

    @Test
    public void shouldBuildDocumentRepresentingMultipleStringProperties() throws Exception {
        Object[] values = new String[]{"hello", "world"};
        Document document = LuceneDocumentStructure.documentRepresentingProperties((long)123L, (Object[])values);
        TestCase.assertEquals((String)"123", (String)document.get("id"));
        Assert.assertThat((Object)document.get(ValueEncoding.String.key(0)), (Matcher)CoreMatchers.equalTo((Object)values[0]));
        Assert.assertThat((Object)document.get(ValueEncoding.String.key(1)), (Matcher)CoreMatchers.equalTo((Object)values[1]));
    }

    @Test
    public void shouldBuildDocumentRepresentingMultiplePropertiesOfDifferentTypes() throws Exception {
        Object[] values = new Object[]{"hello", 789};
        Document document = LuceneDocumentStructure.documentRepresentingProperties((long)123L, (Object[])values);
        TestCase.assertEquals((String)"123", (String)document.get("id"));
        Assert.assertThat((Object)document.get(ValueEncoding.String.key(0)), (Matcher)CoreMatchers.equalTo((Object)"hello"));
        Assert.assertThat((Object)document.get(ValueEncoding.Number.key(1)), (Matcher)CoreMatchers.equalTo((Object)"789.0"));
    }

    @Test
    public void shouldBuildDocumentRepresentingBoolProperty() throws Exception {
        Document document = LuceneDocumentStructure.documentRepresentingProperties((long)123L, (Object[])new Object[]{true});
        TestCase.assertEquals((String)"123", (String)document.get("id"));
        TestCase.assertEquals((String)"true", (String)document.get(ValueEncoding.Bool.key(0)));
    }

    @Test
    public void shouldBuildDocumentRepresentingNumberProperty() throws Exception {
        Document document = LuceneDocumentStructure.documentRepresentingProperties((long)123L, (Object[])new Object[]{12});
        TestCase.assertEquals((String)"123", (String)document.get("id"));
        TestCase.assertEquals((Object)12.0, (Object)document.getField(ValueEncoding.Number.key(0)).numericValue().doubleValue());
    }

    @Test
    public void shouldBuildDocumentRepresentingArrayProperty() throws Exception {
        Document document = LuceneDocumentStructure.documentRepresentingProperties((long)123L, (Object[])new Object[]{new Integer[]{1, 2, 3}});
        TestCase.assertEquals((String)"123", (String)document.get("id"));
        TestCase.assertEquals((String)"D1.0|2.0|3.0|", (String)document.get(ValueEncoding.Array.key(0)));
    }

    @Test
    public void shouldBuildQueryRepresentingBoolProperty() throws Exception {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneDocumentStructure.newSeekQuery((Object[])new Object[]{true});
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery query = (TermQuery)constantScoreQuery.getQuery();
        TestCase.assertEquals((String)"true", (String)query.getTerm().text());
    }

    @Test
    public void shouldBuildQueryRepresentingStringProperty() throws Exception {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneDocumentStructure.newSeekQuery((Object[])new Object[]{"Characters"});
        ConstantScoreQuery query = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TestCase.assertEquals((String)"Characters", (String)((TermQuery)query.getQuery()).getTerm().text());
    }

    @Test
    public void shouldBuildQueryRepresentingNumberProperty() throws Exception {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneDocumentStructure.newSeekQuery((Object[])new Object[]{12});
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        NumericRangeQuery query = (NumericRangeQuery)constantScoreQuery.getQuery();
        TestCase.assertEquals((Object)12.0, (Object)query.getMin());
        TestCase.assertEquals((Object)12.0, (Object)query.getMax());
    }

    @Test
    public void shouldBuildQueryRepresentingArrayProperty() throws Exception {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneDocumentStructure.newSeekQuery((Object[])new Object[]{new Integer[]{1, 2, 3}});
        ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery query = (TermQuery)constantScoreQuery.getQuery();
        TestCase.assertEquals((String)"D1.0|2.0|3.0|", (String)query.getTerm().text());
    }

    @Test
    public void shouldBuildQueryRepresentingMultipleProperties() throws Exception {
        BooleanQuery booleanQuery = (BooleanQuery)LuceneDocumentStructure.newSeekQuery((Object[])new Object[]{true, "Characters", 12, new Integer[]{1, 2, 3}});
        ConstantScoreQuery boolScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(0)).getQuery();
        TermQuery boolTermQuery = (TermQuery)boolScoreQuery.getQuery();
        ConstantScoreQuery stringScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(1)).getQuery();
        TermQuery stringTermQuery = (TermQuery)stringScoreQuery.getQuery();
        ConstantScoreQuery numberScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(2)).getQuery();
        NumericRangeQuery numericRangeQuery = (NumericRangeQuery)numberScoreQuery.getQuery();
        ConstantScoreQuery arrayScoreQuery = (ConstantScoreQuery)((BooleanClause)booleanQuery.clauses().get(3)).getQuery();
        TermQuery arrayTermQuery = (TermQuery)arrayScoreQuery.getQuery();
        TestCase.assertEquals((String)"true", (String)boolTermQuery.getTerm().text());
        TestCase.assertEquals((String)"Characters", (String)stringTermQuery.getTerm().text());
        TestCase.assertEquals((Object)12.0, (Object)numericRangeQuery.getMin());
        TestCase.assertEquals((Object)12.0, (Object)numericRangeQuery.getMax());
        TestCase.assertEquals((String)"D1.0|2.0|3.0|", (String)arrayTermQuery.getTerm().text());
    }

    @Test
    public void shouldBuildRangeSeekByNumberQueryForStrings() throws Exception {
        NumericRangeQuery query = LuceneDocumentStructure.newInclusiveNumericRangeSeekQuery((Number)12.0, null);
        TestCase.assertEquals((String)"number", (String)query.getField());
        TestCase.assertEquals((Object)12.0, (Object)query.getMin());
        TestCase.assertEquals((boolean)true, (boolean)query.includesMin());
        TestCase.assertEquals(null, (Object)query.getMax());
        TestCase.assertEquals((boolean)true, (boolean)query.includesMax());
    }

    @Test
    public void shouldBuildRangeSeekByStringQueryForStrings() throws Exception {
        TermRangeQuery query = (TermRangeQuery)LuceneDocumentStructure.newRangeSeekByStringQuery((String)"foo", (boolean)false, null, (boolean)true);
        TestCase.assertEquals((String)"string", (String)query.getField());
        TestCase.assertEquals((String)"foo", (String)query.getLowerTerm().utf8ToString());
        TestCase.assertEquals((boolean)false, (boolean)query.includesLower());
        TestCase.assertEquals(null, (Object)query.getUpperTerm());
        TestCase.assertEquals((boolean)true, (boolean)query.includesUpper());
    }

    @Test
    public void shouldBuildWildcardQueries() throws Exception {
        WildcardQuery query = (WildcardQuery)LuceneDocumentStructure.newWildCardStringQuery((String)"foo");
        TestCase.assertEquals((String)"string", (String)query.getField());
    }

    @Test
    public void shouldBuildRangeSeekByPrefixQueryForStrings() throws Exception {
        MultiTermQuery prefixQuery = (MultiTermQuery)LuceneDocumentStructure.newRangeSeekByPrefixQuery((String)"Prefix");
        Assert.assertThat((String)"Should contain term value", (Object)prefixQuery.toString(), (Matcher)Matchers.containsString((String)"Prefix"));
    }
}

