/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.IOFunction;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LongArrayMatcher;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class DatabaseIndexAccessorTest {
    public static final int PROP_ID = 1;
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    @ClassRule
    public static final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    @Parameterized.Parameter(value=0)
    public IndexDescriptor index;
    @Parameterized.Parameter(value=1)
    public IOFunction<DirectoryFactory, LuceneIndexAccessor> accessorFactory;
    private LuceneIndexAccessor accessor;
    private final long nodeId = 1L;
    private final long nodeId2 = 2L;
    private final Object value = "value";
    private final Object value2 = 40;
    private DirectoryFactory.InMemoryDirectoryFactory dirFactory;
    private static final IndexDescriptor GENERAL_INDEX = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
    private static final IndexDescriptor UNIQUE_INDEX = IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1});

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> implementations() {
        File dir = new File("dir");
        return Arrays.asList(DatabaseIndexAccessorTest.arg(GENERAL_INDEX, (IOFunction<DirectoryFactory, LuceneIndexAccessor>)((IOFunction)dirFactory1 -> {
            SchemaIndex index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)GENERAL_INDEX).withFileSystem(fileSystemRule.get())).withDirectoryFactory(dirFactory1)).withIndexRootFolder(dir)).withIndexIdentifier("1")).build();
            index.create();
            index.open();
            return new LuceneIndexAccessor(index, GENERAL_INDEX);
        })), DatabaseIndexAccessorTest.arg(UNIQUE_INDEX, (IOFunction<DirectoryFactory, LuceneIndexAccessor>)((IOFunction)dirFactory1 -> {
            SchemaIndex index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)UNIQUE_INDEX).withFileSystem(fileSystemRule.get())).withDirectoryFactory(dirFactory1)).withIndexRootFolder(dir)).withIndexIdentifier("testIndex")).build();
            index.create();
            index.open();
            return new LuceneIndexAccessor(index, UNIQUE_INDEX);
        })));
    }

    private static Object[] arg(IndexDescriptor index, IOFunction<DirectoryFactory, LuceneIndexAccessor> foo) {
        return new Object[]{index, foo};
    }

    @Before
    public void before() throws IOException {
        this.dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
        this.accessor = (LuceneIndexAccessor)this.accessorFactory.apply((Object)this.dirFactory);
    }

    @After
    public void after() throws IOException {
        this.accessor.close();
        this.dirFactory.close();
    }

    @Test
    public void indexReaderShouldSupportScan() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.value), this.add(2L, this.value2)));
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator results = reader.query(new IndexQuery[]{IndexQuery.exists((int)1)});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value)})));
        reader.close();
    }

    @Test
    public void indexStringRangeQuery() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, "A"), this.add(2L, "B"), this.add(3L, "C"), this.add(4L, "")));
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator rangeFromBInclusive = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"B", (boolean)true, null, (boolean)false)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)rangeFromBInclusive), (Matcher)LongArrayMatcher.of(2L, 3L));
        PrimitiveLongIterator rangeFromANonInclusive = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"A", (boolean)false, null, (boolean)false)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)rangeFromANonInclusive), (Matcher)LongArrayMatcher.of(2L, 3L));
        PrimitiveLongIterator emptyLowInclusive = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"", (boolean)true, null, (boolean)false)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)emptyLowInclusive), (Matcher)LongArrayMatcher.of(1L, 2L, 3L, 4L));
        PrimitiveLongIterator emptyUpperNonInclusive = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"B", (boolean)true, (String)"", (boolean)false)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)emptyUpperNonInclusive), (Matcher)LongArrayMatcher.emptyArrayMatcher());
        PrimitiveLongIterator emptyInterval = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"", (boolean)true, (String)"", (boolean)true)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)emptyInterval), (Matcher)LongArrayMatcher.of(4L));
        PrimitiveLongIterator emptyAllNonInclusive = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)"", (boolean)false, null, (boolean)false)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)emptyAllNonInclusive), (Matcher)LongArrayMatcher.of(1L, 2L, 3L));
        PrimitiveLongIterator nullNonInclusive = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)null, (boolean)false, null, (boolean)false)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)nullNonInclusive), (Matcher)LongArrayMatcher.of(1L, 2L, 3L, 4L));
        PrimitiveLongIterator nullInclusive = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (String)null, (boolean)false, null, (boolean)false)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)nullInclusive), (Matcher)LongArrayMatcher.of(1L, 2L, 3L, 4L));
    }

    @Test
    public void indexNumberRangeQuery() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, 1), this.add(2L, 2), this.add(3L, 3), this.add(4L, 4), this.add(5L, Double.NaN)));
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator rangeTwoThree = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)2, (boolean)true, (Number)3, (boolean)true)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)rangeTwoThree), (Matcher)LongArrayMatcher.of(2L, 3L));
        PrimitiveLongIterator infiniteMaxRange = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)2, (boolean)true, (Number)Long.MAX_VALUE, (boolean)true)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)infiniteMaxRange), (Matcher)LongArrayMatcher.of(2L, 3L, 4L));
        PrimitiveLongIterator infiniteMinRange = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)Long.MIN_VALUE, (boolean)true, (Number)3, (boolean)true)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)infiniteMinRange), (Matcher)LongArrayMatcher.of(1L, 2L, 3L));
        PrimitiveLongIterator maxNanInterval = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)3, (boolean)true, (Number)Double.NaN, (boolean)true)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)maxNanInterval), (Matcher)LongArrayMatcher.of(3L, 4L, 5L));
        PrimitiveLongIterator minNanInterval = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)Double.NaN, (boolean)true, (Number)5, (boolean)true)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)minNanInterval), (Matcher)LongArrayMatcher.emptyArrayMatcher());
        PrimitiveLongIterator nanInterval = reader.query(new IndexQuery[]{IndexQuery.range((int)1, (Number)Double.NaN, (boolean)true, (Number)Double.NaN, (boolean)true)});
        Assert.assertThat((Object)PrimitiveLongCollections.asArray((PrimitiveLongIterator)nanInterval), (Matcher)LongArrayMatcher.of(5L));
    }

    @Test
    public void indexReaderShouldHonorRepeatableReads() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.value)));
        IndexReader reader = this.accessor.newReader();
        this.updateAndCommit(Arrays.asList(this.remove(1L, this.value)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value)})));
        reader.close();
    }

    @Test
    public void multipleIndexReadersFromDifferentPointsInTimeCanSeeDifferentResults() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.value)));
        IndexReader firstReader = this.accessor.newReader();
        this.updateAndCommit(Arrays.asList(this.add(2L, this.value2)));
        IndexReader secondReader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)firstReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value)})));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)firstReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value2)})));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)secondReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value)})));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)secondReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value2)})));
        firstReader.close();
        secondReader.close();
    }

    @Test
    public void canAddNewData() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.value), this.add(2L, this.value2)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value)})));
        reader.close();
    }

    @Test
    public void canChangeExistingData() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.value)));
        this.updateAndCommit(Arrays.asList(this.change(1L, this.value, this.value2)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value2)})));
        Assert.assertEquals(Collections.emptySet(), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value)})));
        reader.close();
    }

    @Test
    public void canRemoveExistingData() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.value), this.add(2L, this.value2)));
        this.updateAndCommit(Arrays.asList(this.remove(1L, this.value)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value2)})));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.value)})));
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStopSamplingWhenIndexIsDropped() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.value), this.add(2L, this.value2)));
        IndexReader indexReader = this.accessor.newReader();
        IndexSampler indexSampler = indexReader.createSampler();
        Future drop = this.threading.executeAndAwait((ThrowingFunction)((IOFunction)nothing -> {
            this.accessor.drop();
            return nothing;
        }), null, ThreadingRule.waitingWhileIn(TaskCoordinator.class, (String)"awaitCompletion"), 3L, TimeUnit.SECONDS);
        try (IndexReader reader = indexReader;){
            indexSampler.sampleIndex();
            Assert.fail((String)"expected exception");
        }
        catch (IndexNotFoundKernelException e) {
            Assert.assertEquals((Object)"Index dropped while sampling.", (Object)e.getMessage());
        }
        finally {
            drop.get();
        }
    }

    private IndexEntryUpdate add(long nodeId, Object value) {
        return IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.index.schema(), (Object[])new Object[]{value});
    }

    private IndexEntryUpdate remove(long nodeId, Object value) {
        return IndexEntryUpdate.remove((long)nodeId, (LabelSchemaSupplier)this.index.schema(), (Object[])new Object[]{value});
    }

    private IndexEntryUpdate change(long nodeId, Object valueBefore, Object valueAfter) {
        return IndexEntryUpdate.change((long)nodeId, (LabelSchemaSupplier)this.index.schema(), (Object)valueBefore, (Object)valueAfter);
    }

    private void updateAndCommit(List<IndexEntryUpdate> nodePropertyUpdates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate update : nodePropertyUpdates) {
                updater.process(update);
            }
        }
    }
}

