/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.IOFunction;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class DatabaseCompositeIndexAccessorTest {
    private static final int PROP_ID1 = 1;
    private static final int PROP_ID2 = 2;
    private static final IndexDescriptor DESCRIPTOR = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1, 2});
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    @ClassRule
    public static final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    @Parameterized.Parameter
    public IOFunction<DirectoryFactory, LuceneIndexAccessor> accessorFactory;
    private LuceneIndexAccessor accessor;
    private final long nodeId = 1L;
    private final long nodeId2 = 2L;
    private final Object[] values = new Object[]{"value1", "values2"};
    private final Object[] values2 = new Object[]{40, 42};
    private DirectoryFactory.InMemoryDirectoryFactory dirFactory;
    private static final IndexDescriptor indexDescriptor = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1, 2});
    private static final IndexDescriptor uniqueIndexDescriptor = IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1, 2});

    @Parameterized.Parameters(name="{0}")
    public static Collection<IOFunction<DirectoryFactory, LuceneIndexAccessor>[]> implementations() {
        File dir = new File("dir");
        return Arrays.asList(DatabaseCompositeIndexAccessorTest.arg((IOFunction<DirectoryFactory, LuceneIndexAccessor>)((IOFunction)dirFactory1 -> {
            SchemaIndex index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)indexDescriptor).withFileSystem(fileSystemRule.get())).withDirectoryFactory(dirFactory1)).withIndexRootFolder(dir)).withIndexIdentifier("1")).build();
            index.create();
            index.open();
            return new LuceneIndexAccessor(index, DESCRIPTOR);
        })), DatabaseCompositeIndexAccessorTest.arg((IOFunction<DirectoryFactory, LuceneIndexAccessor>)((IOFunction)dirFactory1 -> {
            SchemaIndex index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)uniqueIndexDescriptor).withFileSystem(fileSystemRule.get())).withDirectoryFactory(dirFactory1)).withIndexRootFolder(dir)).withIndexIdentifier("testIndex")).build();
            index.create();
            index.open();
            return new LuceneIndexAccessor(index, DESCRIPTOR);
        })));
    }

    private static IOFunction<DirectoryFactory, LuceneIndexAccessor>[] arg(IOFunction<DirectoryFactory, LuceneIndexAccessor> foo) {
        return new IOFunction[]{foo};
    }

    @Before
    public void before() throws IOException {
        this.dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
        this.accessor = (LuceneIndexAccessor)this.accessorFactory.apply((Object)this.dirFactory);
    }

    @After
    public void after() throws IOException {
        this.accessor.close();
        this.dirFactory.close();
    }

    @Test
    public void indexReaderShouldSupportScan() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values), this.add(2L, this.values2)));
        IndexReader reader = this.accessor.newReader();
        PrimitiveLongIterator results = reader.query(new IndexQuery[]{IndexQuery.exists((int)1), IndexQuery.exists((int)2)});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])})));
        reader.close();
    }

    @Test
    public void multipleIndexReadersFromDifferentPointsInTimeCanSeeDifferentResults() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values)));
        IndexReader firstReader = this.accessor.newReader();
        this.updateAndCommit(Arrays.asList(this.add(2L, this.values2)));
        IndexReader secondReader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)firstReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])})));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)firstReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values2[0]), IndexQuery.exact((int)2, (Object)this.values2[1])})));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)secondReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])})));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)secondReader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values2[0]), IndexQuery.exact((int)2, (Object)this.values2[1])})));
        firstReader.close();
        secondReader.close();
    }

    @Test
    public void canAddNewData() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values), this.add(2L, this.values2)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])})));
        reader.close();
    }

    @Test
    public void canChangeExistingData() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values)));
        this.updateAndCommit(Arrays.asList(this.change(1L, this.values, this.values2)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values2[0]), IndexQuery.exact((int)2, (Object)this.values2[1])})));
        Assert.assertEquals(Collections.emptySet(), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])})));
        reader.close();
    }

    @Test
    public void canRemoveExistingData() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values), this.add(2L, this.values2)));
        this.updateAndCommit(Arrays.asList(this.remove(1L, this.values)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values2[0]), IndexQuery.exact((int)2, (Object)this.values2[1])})));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])})));
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStopSamplingWhenIndexIsDropped() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values), this.add(2L, this.values2)));
        IndexReader indexReader = this.accessor.newReader();
        IndexSampler indexSampler = indexReader.createSampler();
        Future drop = this.threading.executeAndAwait((ThrowingFunction)new IOFunction<Void, Void>(){

            public Void apply(Void nothing) throws IOException {
                DatabaseCompositeIndexAccessorTest.this.accessor.drop();
                return nothing;
            }
        }, null, ThreadingRule.waitingWhileIn(TaskCoordinator.class, (String)"awaitCompletion"), 3L, TimeUnit.SECONDS);
        try (IndexReader reader = indexReader;){
            indexSampler.sampleIndex();
            Assert.fail((String)"expected exception");
        }
        catch (IndexNotFoundKernelException e) {
            Assert.assertEquals((Object)"Index dropped while sampling.", (Object)e.getMessage());
        }
        finally {
            drop.get();
        }
    }

    private IndexEntryUpdate add(long nodeId, Object ... values) {
        return IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)indexDescriptor.schema(), (Object[])values);
    }

    private IndexEntryUpdate remove(long nodeId, Object ... values) {
        return IndexEntryUpdate.remove((long)nodeId, (LabelSchemaSupplier)indexDescriptor.schema(), (Object[])values);
    }

    private IndexEntryUpdate change(long nodeId, Object[] valuesBefore, Object[] valuesAfter) {
        return IndexEntryUpdate.change((long)nodeId, (LabelSchemaSupplier)indexDescriptor.schema(), (Object[])valuesBefore, (Object[])valuesAfter);
    }

    private void updateAndCommit(List<IndexEntryUpdate> nodePropertyUpdates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate update : nodePropertyUpdates) {
                updater.process(update);
            }
        }
    }
}

