/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.AllNodesCollector;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class AccessUniqueDatabaseIndexTest {
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private final DirectoryFactory directoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private final File indexDirectory = new File("index1");
    private final IndexDescriptor index = IndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100});

    @Test
    public void shouldAddUniqueEntries() throws Exception {
        PartitionedIndexStorage indexStorage = this.getIndexStorage();
        LuceneIndexAccessor accessor = this.createAccessor(indexStorage);
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1"), this.add(2L, "value2")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(3L, "value3")));
        accessor.close();
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(indexStorage, "value1"));
    }

    @Test
    public void shouldUpdateUniqueEntries() throws Exception {
        PartitionedIndexStorage indexStorage = this.getIndexStorage();
        LuceneIndexAccessor accessor = this.createAccessor(indexStorage);
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.change(1L, "value1", "value2")));
        accessor.close();
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(indexStorage, "value2"));
        Assert.assertEquals(Collections.emptyList(), this.getAllNodes(indexStorage, "value1"));
    }

    @Test
    public void shouldRemoveAndAddEntries() throws Exception {
        PartitionedIndexStorage indexStorage = this.getIndexStorage();
        LuceneIndexAccessor accessor = this.createAccessor(indexStorage);
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(2L, "value2")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(3L, "value3")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(4L, "value4")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.remove(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.remove(2L, "value2")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.remove(3L, "value3")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(3L, "value3b")));
        accessor.close();
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(indexStorage, "value1"));
        Assert.assertEquals(Collections.emptyList(), this.getAllNodes(indexStorage, "value2"));
        Assert.assertEquals(Collections.emptyList(), this.getAllNodes(indexStorage, "value3"));
        Assert.assertEquals(Arrays.asList(3L), this.getAllNodes(indexStorage, "value3b"));
        Assert.assertEquals(Arrays.asList(4L), this.getAllNodes(indexStorage, "value4"));
    }

    @Test
    public void shouldConsiderWholeTransactionForValidatingUniqueness() throws Exception {
        PartitionedIndexStorage indexStorage = this.getIndexStorage();
        LuceneIndexAccessor accessor = this.createAccessor(indexStorage);
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(1L, "value1")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.add(2L, "value2")));
        this.updateAndCommit((IndexAccessor)accessor, Arrays.asList(this.change(1L, "value1", "value2"), this.change(2L, "value2", "value1")));
        accessor.close();
        Assert.assertEquals(Arrays.asList(2L), this.getAllNodes(indexStorage, "value1"));
        Assert.assertEquals(Arrays.asList(1L), this.getAllNodes(indexStorage, "value2"));
    }

    private LuceneIndexAccessor createAccessor(PartitionedIndexStorage indexStorage) throws IOException {
        SchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)this.index).withIndexStorage(indexStorage)).build();
        luceneIndex.open();
        return new LuceneIndexAccessor(luceneIndex, this.index);
    }

    private PartitionedIndexStorage getIndexStorage() throws IOException {
        IndexStorageFactory storageFactory = new IndexStorageFactory(this.directoryFactory, this.fileSystemRule.get(), this.indexDirectory);
        return storageFactory.indexStorageOf(1L, false);
    }

    private IndexEntryUpdate add(long nodeId, Object propertyValue) {
        return IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.index.schema(), (Object[])new Object[]{propertyValue});
    }

    private IndexEntryUpdate change(long nodeId, Object oldValue, Object newValue) {
        return IndexEntryUpdate.change((long)nodeId, (LabelSchemaSupplier)this.index.schema(), (Object)oldValue, (Object)newValue);
    }

    private IndexEntryUpdate remove(long nodeId, Object oldValue) {
        return IndexEntryUpdate.remove((long)nodeId, (LabelSchemaSupplier)this.index.schema(), (Object[])new Object[]{oldValue});
    }

    private List<Long> getAllNodes(PartitionedIndexStorage indexStorage, String propertyValue) throws IOException {
        return AllNodesCollector.getAllNodes(indexStorage.openDirectory(indexStorage.getPartitionFolder(1)), propertyValue);
    }

    private void updateAndCommit(IndexAccessor accessor, Iterable<IndexEntryUpdate> updates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate update : updates) {
                updater.process(update);
            }
        }
    }
}

