/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.storestrategy;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.impl.index.IndexReaderStub;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.PageOfRangesIterator;

@RunWith(value=Parameterized.class)
public class PageOfRangesIteratorTest {
    @Parameterized.Parameter
    public BitmapDocumentFormat format;

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0} bits")
    public static List<Object[]> formats() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void shouldReadPagesOfDocumentsFromSearcher() throws Exception {
        int labelId = 7;
        int pageSize = 2;
        Query query = (Query)Mockito.mock(Query.class);
        IndexSearcher searcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
        NumericDocValues rangeNDV = (NumericDocValues)Mockito.mock(NumericDocValues.class);
        Mockito.when((Object)rangeNDV.get(11)).thenReturn((Object)1L);
        Mockito.when((Object)rangeNDV.get(16)).thenReturn((Object)2L);
        Mockito.when((Object)rangeNDV.get(37)).thenReturn((Object)3L);
        NumericDocValues labelNDV = (NumericDocValues)Mockito.mock(NumericDocValues.class);
        Mockito.when((Object)labelNDV.get(11)).thenReturn((Object)1L);
        Mockito.when((Object)labelNDV.get(16)).thenReturn((Object)3L);
        Mockito.when((Object)labelNDV.get(37)).thenReturn((Object)48L);
        Map docValues = MapUtil.genericMap((Object[])new Object[]{"range", rangeNDV, "7", labelNDV});
        IndexReaderStub reader = new IndexReaderStub(docValues);
        reader.setElements(new String[]{"11", "16", "37"});
        LeafReaderContext context = reader.getContext();
        ((IndexSearcher)Mockito.doAnswer(invocation -> {
            DocValuesCollector collector = (DocValuesCollector)invocation.getArguments()[1];
            collector.doSetNextReader(context);
            collector.collect(11);
            collector.collect(16);
            collector.collect(37);
            return null;
        }).when((Object)searcher)).search((Query)Matchers.same((Object)query), (Collector)Matchers.any(DocValuesCollector.class));
        PrimitiveLongIterator iterator = PrimitiveLongCollections.concat((Iterator)new PageOfRangesIterator(this.format, searcher, 2, query, BooleanClause.Occur.MUST, new int[]{7}));
        List longs = PrimitiveLongCollections.asList((PrimitiveLongIterator)iterator);
        Assert.assertEquals(Arrays.asList(1L << this.format.bitmapFormat().shift, 2L << this.format.bitmapFormat().shift, (2L << this.format.bitmapFormat().shift) + 1L, (3L << this.format.bitmapFormat().shift) + 4L, (3L << this.format.bitmapFormat().shift) + 5L), (Object)longs);
        ((IndexSearcher)Mockito.verify((Object)searcher, (VerificationMode)Mockito.times((int)1))).search((Query)Matchers.same((Object)query), (Collector)Matchers.any(DocValuesCollector.class));
        ((NumericDocValues)Mockito.verify((Object)rangeNDV, (VerificationMode)Mockito.times((int)6))).get(Matchers.anyInt());
        ((NumericDocValues)Mockito.verify((Object)labelNDV, (VerificationMode)Mockito.times((int)3))).get(Matchers.anyInt());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{searcher});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{labelNDV});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{rangeNDV});
    }
}

