/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.storestrategy;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.impl.index.collector.FirstHitCollector;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartition;
import org.neo4j.kernel.api.impl.labelscan.WritableDatabaseLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.Bitmap;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.labelscan.writer.PartitionedLuceneLabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;

@RunWith(value=Parameterized.class)
public class NodeRangeDocumentLabelScanStorageStrategyTest {
    @Parameterized.Parameter
    public BitmapDocumentFormat format;

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0} bits")
    public static List<Object[]> formats() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void shouldCreateNewDocumentsForNewlyLabeledNodes() throws Exception {
        WritableIndexPartition partition = (WritableIndexPartition)Mockito.mock(WritableIndexPartition.class);
        WritableDatabaseLabelScanIndex index = this.buildLuceneIndex(partition);
        PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
        Mockito.when((Object)partition.acquireSearcher()).thenReturn((Object)partitionSearcher);
        IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
        Mockito.when((Object)partition.getIndexWriter()).thenReturn((Object)indexWriter);
        IndexSearcher searcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
        Mockito.when((Object)partitionSearcher.getIndexSearcher()).thenReturn((Object)searcher);
        Mockito.when((Object)searcher.search((Query)new TermQuery(this.format.rangeTerm(0L)), 1)).thenReturn((Object)NodeRangeDocumentLabelScanStorageStrategyTest.emptyTopDocs());
        Mockito.when((Object)searcher.search((Query)new TermQuery(this.format.rangeTerm(1L)), 1)).thenReturn(null);
        PartitionedLuceneLabelScanWriter writer = new PartitionedLuceneLabelScanWriter(index, this.format);
        writer.write(NodeLabelUpdate.labelChanges((long)0L, (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(new long[0]), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(6L, 7L)));
        writer.write(NodeLabelUpdate.labelChanges((long)1L, (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(new long[0]), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(6L, 8L)));
        writer.write(NodeLabelUpdate.labelChanges((long)(1 << this.format.bitmapFormat().shift), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(new long[0]), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(7L)));
        writer.close();
        ((WritableIndexPartition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).acquireSearcher();
        ((PartitionSearcher)Mockito.verify((Object)partitionSearcher, (VerificationMode)Mockito.times((int)2))).getIndexSearcher();
        ((WritableIndexPartition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).getIndexWriter();
        ((PartitionSearcher)Mockito.verify((Object)partitionSearcher, (VerificationMode)Mockito.times((int)2))).close();
        ((IndexWriter)Mockito.verify((Object)indexWriter)).updateDocument((Term)Matchers.eq((Object)this.format.rangeTerm(0L)), (Iterable)NodeRangeDocumentLabelScanStorageStrategyTest.match(NodeRangeDocumentLabelScanStorageStrategyTest.document(this.format.rangeField(0L), this.format.labelField(6L, 3L), this.format.labelField(7L, 1L), this.format.labelField(8L, 2L), this.format.labelSearchField(8L))));
        ((IndexWriter)Mockito.verify((Object)indexWriter)).updateDocument((Term)Matchers.eq((Object)this.format.rangeTerm(1L)), (Iterable)NodeRangeDocumentLabelScanStorageStrategyTest.match(NodeRangeDocumentLabelScanStorageStrategyTest.document(this.format.rangeField(1L), this.format.labelField(7L, 1L), this.format.labelSearchField(7L))));
        ((WritableDatabaseLabelScanIndex)Mockito.verify((Object)index)).maybeRefreshBlocking();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{partition});
    }

    @Test
    public void shouldUpdateDocumentsForReLabeledNodes() throws Exception {
        Document givenDoc = new Document();
        this.format.addRangeValuesField(givenDoc, 0L);
        this.format.addLabelFields(givenDoc, "7", 112L);
        WritableDatabaseLabelScanIndex index = (WritableDatabaseLabelScanIndex)Mockito.mock(WritableDatabaseLabelScanIndex.class);
        IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
        WritableIndexPartition partition = this.newIndexPartitionMock(indexWriter, givenDoc);
        Mockito.when((Object)index.getPartitions()).thenReturn(Collections.singletonList(partition));
        PartitionedLuceneLabelScanWriter writer = new PartitionedLuceneLabelScanWriter(index, this.format);
        writer.write(NodeLabelUpdate.labelChanges((long)0L, (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(new long[0]), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(7L, 8L)));
        writer.close();
        Document thenDoc = new Document();
        this.format.addRangeValuesField(thenDoc, 0L);
        this.format.addLabelFields(thenDoc, "7", 113L);
        this.format.addLabelAndSearchFields(thenDoc, 8L, new Bitmap(1L));
        ((IndexWriter)Mockito.verify((Object)indexWriter)).updateDocument((Term)Matchers.eq((Object)this.format.rangeTerm(0L)), (Iterable)NodeRangeDocumentLabelScanStorageStrategyTest.match(thenDoc));
    }

    @Test
    public void shouldRemoveLabelFieldsThatDoesNotRepresentAnyNodes() throws Exception {
        IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
        Document doc = NodeRangeDocumentLabelScanStorageStrategyTest.document(this.format.rangeField(0L), this.format.labelField(7L, 1L), this.format.labelField(8L, 1L));
        WritableIndexPartition partition = this.newIndexPartitionMock(indexWriter, doc);
        WritableDatabaseLabelScanIndex index = this.buildLuceneIndex(partition);
        PartitionedLuceneLabelScanWriter writer = new PartitionedLuceneLabelScanWriter(index, this.format);
        writer.write(NodeLabelUpdate.labelChanges((long)0L, (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(7L, 8L), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(8L)));
        writer.close();
        ((IndexWriter)Mockito.verify((Object)indexWriter)).updateDocument((Term)Matchers.eq((Object)this.format.rangeTerm(0L)), (Iterable)NodeRangeDocumentLabelScanStorageStrategyTest.match(NodeRangeDocumentLabelScanStorageStrategyTest.document(this.format.rangeField(0L), this.format.labelField(8L, 1L), this.format.labelSearchField(8L))));
    }

    @Test
    public void shouldDeleteEmptyDocuments() throws Exception {
        IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
        Document doc = NodeRangeDocumentLabelScanStorageStrategyTest.document(this.format.rangeField(0L), this.format.labelField(7L, 1L));
        WritableIndexPartition partition = this.newIndexPartitionMock(indexWriter, doc);
        WritableDatabaseLabelScanIndex index = this.buildLuceneIndex(partition);
        PartitionedLuceneLabelScanWriter writer = new PartitionedLuceneLabelScanWriter(index, this.format);
        writer.write(NodeLabelUpdate.labelChanges((long)0L, (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(7L), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(new long[0])));
        writer.close();
        ((IndexWriter)Mockito.verify((Object)indexWriter)).deleteDocuments(new Term[]{this.format.rangeTerm(0L)});
    }

    @Test
    public void shouldUpdateDocumentToReflectLabelsAfterRegardlessOfPreviousContent() throws Exception {
        IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
        Document doc = NodeRangeDocumentLabelScanStorageStrategyTest.document(this.format.rangeField(0L), this.format.labelField(6L, 1L), this.format.labelField(7L, 1L));
        WritableIndexPartition partition = this.newIndexPartitionMock(indexWriter, doc);
        WritableDatabaseLabelScanIndex index = this.buildLuceneIndex(partition);
        PartitionedLuceneLabelScanWriter writer = new PartitionedLuceneLabelScanWriter(index, this.format);
        writer.write(NodeLabelUpdate.labelChanges((long)0L, (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(7L), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(7L, 8L)));
        writer.close();
        ((IndexWriter)Mockito.verify((Object)indexWriter)).updateDocument((Term)Matchers.eq((Object)this.format.rangeTerm(0L)), (Iterable)NodeRangeDocumentLabelScanStorageStrategyTest.match(NodeRangeDocumentLabelScanStorageStrategyTest.document(this.format.rangeField(0L), this.format.labelField(7L, 1L), this.format.labelField(8L, 1L), this.format.labelSearchField(7L), this.format.labelSearchField(8L))));
    }

    @Test
    public void shouldStoreAnyNodeIdInRange() throws Exception {
        int max = 1 << this.format.bitmapFormat().shift;
        for (int i = 0; i < max; ++i) {
            IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
            WritableIndexPartition partition = this.newIndexPartitionMock(indexWriter, new Document[0]);
            WritableDatabaseLabelScanIndex index = this.buildLuceneIndex(partition);
            PartitionedLuceneLabelScanWriter writer = new PartitionedLuceneLabelScanWriter(index, this.format);
            writer.write(NodeLabelUpdate.labelChanges((long)i, (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(new long[0]), (long[])NodeRangeDocumentLabelScanStorageStrategyTest.labels(7L)));
            writer.close();
            Document document = new Document();
            this.format.addRangeValuesField(document, 0L);
            this.format.addLabelAndSearchFields(document, 7L, new Bitmap(1L << i));
            ((IndexWriter)Mockito.verify((Object)indexWriter)).updateDocument((Term)Matchers.eq((Object)this.format.rangeTerm(0L)), (Iterable)NodeRangeDocumentLabelScanStorageStrategyTest.match(document));
        }
    }

    private WritableIndexPartition newIndexPartitionMock(IndexWriter indexWriter, Document ... documents) throws IOException {
        WritableIndexPartition partition = (WritableIndexPartition)Mockito.mock(WritableIndexPartition.class);
        PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
        Mockito.when((Object)partition.acquireSearcher()).thenReturn((Object)partitionSearcher);
        Mockito.when((Object)partition.getIndexWriter()).thenReturn((Object)indexWriter);
        IndexSearcher searcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
        Mockito.when((Object)partitionSearcher.getIndexSearcher()).thenReturn((Object)searcher);
        for (int i = 0; i < documents.length; ++i) {
            int docId = i;
            ((IndexSearcher)Mockito.doAnswer(invocation -> {
                FirstHitCollector collector = (FirstHitCollector)invocation.getArguments()[1];
                try {
                    collector.collect(docId);
                }
                catch (CollectionTerminatedException collectionTerminatedException) {
                    // empty catch block
                }
                return null;
            }).when((Object)searcher)).search((Query)Matchers.eq((Object)new TermQuery(this.format.rangeTerm(documents[i]))), (Collector)Matchers.any(FirstHitCollector.class));
            Mockito.when((Object)searcher.doc(i)).thenReturn((Object)documents[i]);
        }
        return partition;
    }

    private static long[] labels(long ... labels) {
        return labels;
    }

    private static Document document(IndexableField ... fields) {
        Document document = new Document();
        Stream.of(fields).forEach(arg_0 -> ((Document)document).add(arg_0));
        return document;
    }

    private static TopDocs emptyTopDocs() {
        return new TopDocs(0, new ScoreDoc[0], 0.0f);
    }

    private static Document match(final Document document) {
        return (Document)Matchers.argThat((Matcher)new TypeSafeMatcher<Document>(){

            protected boolean matchesSafely(Document item) {
                return this.equal(this.fields(document), this.fields(item));
            }

            public void describeTo(Description description) {
                description.appendValue((Object)document);
            }

            private Map<String, IndexableField> fields(Document doc) {
                HashMap<String, IndexableField> these = new HashMap<String, IndexableField>();
                for (IndexableField field : doc.getFields()) {
                    these.put(field.name(), field);
                }
                return these;
            }

            boolean equal(Map<String, IndexableField> these, Map<String, IndexableField> those) {
                if (!these.keySet().equals(those.keySet())) {
                    return false;
                }
                for (Map.Entry<String, IndexableField> entry : these.entrySet()) {
                    if (this.equal(entry.getValue(), those.get(entry.getKey()))) continue;
                    return false;
                }
                return true;
            }

            boolean equal(IndexableField lhs, IndexableField rhs) {
                if (lhs.binaryValue() != null && rhs.binaryValue() != null) {
                    return Arrays.equals(lhs.binaryValue().bytes, rhs.binaryValue().bytes);
                }
                return lhs.stringValue().equals(rhs.stringValue());
            }
        });
    }

    private WritableDatabaseLabelScanIndex buildLuceneIndex(WritableIndexPartition partition) {
        WritableDatabaseLabelScanIndex index = (WritableDatabaseLabelScanIndex)Mockito.mock(WritableDatabaseLabelScanIndex.class);
        Mockito.when((Object)index.getPartitions()).thenReturn(Collections.singletonList(partition));
        return index;
    }
}

