/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.impl.labelscan.LuceneNodeLabelRange;

public class LuceneNodeLabelRangeTest {
    @Test
    public void shouldTransposeNodeIdsAndLabelIds() throws Exception {
        long[] labelIds = new long[]{1L, 3L, 5L};
        long[][] nodeIdsByLabelIndex = new long[][]{{0L}, {2L, 4L}, {0L, 2L, 4L}};
        LuceneNodeLabelRange range = LuceneNodeLabelRange.fromBitmapStructure((int)0, (long[])labelIds, (long[][])nodeIdsByLabelIndex);
        Assert.assertThat((Object)Iterables.asIterable((long[])range.nodes()), (Matcher)CoreMatchers.hasItems((Object[])new Long[]{0L, 2L, 4L}));
        Assert.assertThat((Object)Iterables.asIterable((long[])range.labels(0L)), (Matcher)CoreMatchers.hasItems((Object[])new Long[]{1L, 5L}));
        Assert.assertThat((Object)Iterables.asIterable((long[])range.labels(2L)), (Matcher)CoreMatchers.hasItems((Object[])new Long[]{3L, 5L}));
        Assert.assertThat((Object)Iterables.asIterable((long[])range.labels(4L)), (Matcher)CoreMatchers.hasItems((Object[])new Long[]{3L, 5L}));
    }
}

