/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.labelscan.LabelScanStoreTest;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndexBuilder;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanStore;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.factory.OperationalMode;

@RunWith(value=Parameterized.class)
public class LuceneLabelScanStoreTest
extends LabelScanStoreTest {
    @Parameterized.Parameter
    public BitmapDocumentFormat documentFormat;
    private final DirectoryFactory inMemoryDirectoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private PartitionedIndexStorage indexStorage;

    @Parameterized.Parameters(name="{0}")
    public static List<BitmapDocumentFormat> parameterizedWithStrategies() {
        return Arrays.asList(BitmapDocumentFormat._32, BitmapDocumentFormat._64);
    }

    protected LabelScanStore createLabelScanStore(FileSystemAbstraction fs, File rootFolder, List<NodeLabelUpdate> existingData, boolean usePersistentStore, boolean readOnly, LabelScanStore.Monitor monitor) {
        DirectoryFactory directoryFactory = usePersistentStore ? DirectoryFactory.PERSISTENT : this.inMemoryDirectoryFactory;
        this.indexStorage = new PartitionedIndexStorage(directoryFactory, fs, rootFolder, "labelStore", false);
        Config config = Config.defaults().with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), String.valueOf(readOnly)}));
        LuceneLabelScanIndexBuilder indexBuilder = ((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)LuceneLabelScanIndexBuilder.create().withDirectoryFactory(directoryFactory)).withIndexStorage(this.indexStorage)).withOperationalMode(OperationalMode.single)).withConfig(config)).withDocumentFormat(this.documentFormat);
        return new LuceneLabelScanStore(indexBuilder, FullStoreChangeStream.asStream(existingData), monitor);
    }

    protected Matcher<Iterable<? super String>> hasBareMinimumFileList() {
        return IsCollectionContaining.hasItem((Matcher)Matchers.startsWith((String)"segments"));
    }

    protected void corruptIndex(FileSystemAbstraction fileSystem, File rootFolder) throws IOException {
        List indexPartitions = this.indexStorage.listFolders();
        for (File partition : indexPartitions) {
            File[] files = partition.listFiles();
            if (files == null) continue;
            for (File indexFile : files) {
                this.scrambleFile(indexFile);
            }
        }
    }
}

