/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.impl.labelscan.LabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndexBuilder;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class LuceneLabelScanIndexIT {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final int affectedNodes;

    @Before
    public void before() throws Exception {
        System.setProperty("labelScanStore.maxPartitionSize", "10");
    }

    @After
    public void after() throws IOException {
        System.setProperty("labelScanStore.maxPartitionSize", "");
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Integer> affectedNodes() {
        return Arrays.asList(7, 110, 250, 380, 1400, 2000, 3500, 5800);
    }

    public LuceneLabelScanIndexIT(int affectedNodes) {
        this.affectedNodes = affectedNodes;
    }

    @Test
    public void readFromPartitionedIndex() throws IOException {
        try (LabelScanIndex labelScanIndex = ((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)LuceneLabelScanIndexBuilder.create().withFileSystem(this.fileSystemRule.get())).withIndexIdentifier("partitionedIndex" + this.affectedNodes)).withIndexRootFolder(this.testDir.directory("partitionedIndexFolder" + this.affectedNodes))).build();){
            labelScanIndex.open();
            this.generateLabelChanges(labelScanIndex, this.affectedNodes);
            try (LabelScanReader labelScanReader = labelScanIndex.getLabelScanReader();){
                int i;
                for (i = 0; i < this.affectedNodes; ++i) {
                    long[] labels = PrimitiveLongCollections.asArray((PrimitiveLongIterator)labelScanReader.nodesWithLabel(i));
                    Assert.assertEquals((String)"Should have only one label", (long)1L, (long)labels.length);
                    Assert.assertEquals((String)"Label id should be equal to node id", (long)i, (long)labels[0]);
                }
                for (i = 0; i < this.affectedNodes; ++i) {
                    long[] nodes = PrimitiveLongCollections.asArray((PrimitiveLongIterator)labelScanReader.nodesWithLabel(i));
                    Assert.assertEquals((String)"Should have only one node for each label", (long)1L, (long)nodes.length);
                    Assert.assertEquals((String)"Label id should be equal to node id", (long)i, (long)nodes[0]);
                }
            }
        }
    }

    private void generateLabelChanges(LabelScanWriter scanWriter, int affectedNodes) throws IOException {
        for (int i = 0; i < affectedNodes; ++i) {
            scanWriter.write(NodeLabelUpdate.labelChanges((long)i, (long[])new long[0], (long[])new long[]{i}));
        }
    }

    private void generateLabelChanges(LabelScanIndex labelScanIndex, int numberOfUpdates) throws IOException {
        try (LabelScanWriter scanWriter = labelScanIndex.getLabelScanWriter();){
            this.generateLabelChanges(scanWriter, numberOfUpdates);
        }
    }
}

