/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.verification;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.DuplicateCheckingCollector;
import org.neo4j.kernel.api.impl.schema.verification.PartitionedUniquenessVerifier;
import org.neo4j.kernel.api.index.PropertyAccessor;

@RunWith(value=MockitoJUnitRunner.class)
public class PartitionedUniquenessVerifierTest {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PartitionSearcher searcher1;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PartitionSearcher searcher2;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PartitionSearcher searcher3;

    @Test
    public void partitionSearchersAreClosed() throws IOException {
        PartitionedUniquenessVerifier verifier = this.createPartitionedVerifier();
        verifier.close();
        ((PartitionSearcher)Mockito.verify((Object)this.searcher1)).close();
        ((PartitionSearcher)Mockito.verify((Object)this.searcher2)).close();
        ((PartitionSearcher)Mockito.verify((Object)this.searcher3)).close();
    }

    @Test
    public void verifyPropertyUpdates() throws Exception {
        PartitionedUniquenessVerifier verifier = this.createPartitionedVerifier();
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        verifier.verify(propertyAccessor, new int[]{42}, Arrays.asList("a", "b"));
        PartitionedUniquenessVerifierTest.verifySearchInvocations(this.searcher1, "a", "b");
        PartitionedUniquenessVerifierTest.verifySearchInvocations(this.searcher2, "a", "b");
        PartitionedUniquenessVerifierTest.verifySearchInvocations(this.searcher3, "a", "b");
    }

    private PartitionedUniquenessVerifier createPartitionedVerifier() {
        return new PartitionedUniquenessVerifier(this.getSearchers());
    }

    private List<PartitionSearcher> getSearchers() {
        return Arrays.asList(this.searcher1, this.searcher2, this.searcher3);
    }

    private static void verifySearchInvocations(PartitionSearcher searcher, Object ... values) throws IOException {
        for (Object value : values) {
            ((IndexSearcher)Mockito.verify((Object)searcher.getIndexSearcher())).search((Query)Matchers.eq((Object)LuceneDocumentStructure.newSeekQuery((Object[])new Object[]{value})), (Collector)Matchers.any(DuplicateCheckingCollector.class));
        }
    }
}

