/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class PartitionedIndexStorageTest {
    private static final String INDEX_ID = "testIndex";
    @Rule
    public final DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fsRule.get());
    private FileSystemAbstraction fs;
    private PartitionedIndexStorage storage;

    @Before
    public void createIndexStorage() throws Exception {
        this.fs = this.fsRule.get();
        this.storage = new PartitionedIndexStorage(PartitionedIndexStorageTest.getOrCreateDirFactory(this.fs), this.fs, this.testDir.graphDbDir(), INDEX_ID, false);
    }

    @Test
    public void prepareFolderCreatesFolder() throws IOException {
        File folder = this.createRandomFolder(this.testDir.graphDbDir());
        this.storage.prepareFolder(folder);
        Assert.assertTrue((boolean)this.fs.fileExists(folder));
    }

    @Test
    public void prepareFolderRemovesFromFileSystem() throws IOException {
        File folder = this.createRandomFolder(this.testDir.graphDbDir());
        this.createRandomFilesAndFolders(folder);
        this.storage.prepareFolder(folder);
        Assert.assertTrue((boolean)this.fs.fileExists(folder));
        Assert.assertTrue((boolean)ArrayUtil.isEmpty((Object[])this.fs.listFiles(folder)));
    }

    @Test
    public void prepareFolderRemovesFromLucene() throws IOException {
        File folder = this.createRandomFolder(this.testDir.graphDbDir());
        Directory dir = this.createRandomLuceneDir(folder);
        Assert.assertFalse((boolean)ArrayUtil.isEmpty((Object[])dir.listAll()));
        this.storage.prepareFolder(folder);
        Assert.assertTrue((boolean)this.fs.fileExists(folder));
        Assert.assertTrue((boolean)ArrayUtil.isEmpty((Object[])dir.listAll()));
    }

    @Test
    public void openIndexDirectoriesForEmptyIndex() throws IOException {
        File indexFolder = this.storage.getIndexFolder();
        Map directories = this.storage.openIndexDirectories();
        Assert.assertTrue((boolean)directories.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openIndexDirectories() throws IOException {
        File indexFolder = this.storage.getIndexFolder();
        this.createRandomLuceneDir(indexFolder).close();
        this.createRandomLuceneDir(indexFolder).close();
        Map directories = this.storage.openIndexDirectories();
        try {
            Assert.assertEquals((long)2L, (long)directories.size());
            for (Directory dir : directories.values()) {
                Assert.assertFalse((boolean)ArrayUtil.isEmpty((Object[])dir.listAll()));
            }
        }
        finally {
            IOUtils.closeAll(directories.values());
        }
    }

    @Test
    public void listFoldersForEmptyFolder() throws IOException {
        File indexFolder = this.storage.getIndexFolder();
        this.fs.mkdirs(indexFolder);
        List folders = this.storage.listFolders();
        Assert.assertTrue((boolean)folders.isEmpty());
    }

    @Test
    public void listFolders() throws IOException {
        File indexFolder = this.storage.getIndexFolder();
        this.fs.mkdirs(indexFolder);
        this.createRandomFile(indexFolder);
        this.createRandomFile(indexFolder);
        File folder1 = this.createRandomFolder(indexFolder);
        File folder2 = this.createRandomFolder(indexFolder);
        List folders = this.storage.listFolders();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new File[]{folder1, folder2}), new HashSet(folders));
    }

    @Test
    public void shouldListIndexPartitionsSorted() throws Exception {
        try (DefaultFileSystemAbstraction scramblingFs = new DefaultFileSystemAbstraction(){

            public File[] listFiles(File directory) {
                List<File> files = Arrays.asList(super.listFiles(directory));
                Collections.shuffle(files);
                return files.toArray(new File[files.size()]);
            }
        };){
            PartitionedIndexStorage myStorage = new PartitionedIndexStorage(PartitionedIndexStorageTest.getOrCreateDirFactory((FileSystemAbstraction)scramblingFs), (FileSystemAbstraction)scramblingFs, this.testDir.graphDbDir(), INDEX_ID, false);
            File parent = myStorage.getIndexFolder();
            int directoryCount = 10;
            for (int i = 0; i < directoryCount; ++i) {
                scramblingFs.mkdirs(new File(parent, String.valueOf(i + 1)));
            }
            Map directories = myStorage.openIndexDirectories();
            Assert.assertEquals((long)directoryCount, (long)directories.size());
            int previous = 0;
            for (Map.Entry directory : directories.entrySet()) {
                int current = Integer.parseInt(((File)directory.getKey()).getName());
                Assert.assertTrue((String)("Wanted directory " + current + " to have higher id than previous " + previous), (current > previous ? 1 : 0) != 0);
                previous = current;
            }
        }
    }

    private void createRandomFilesAndFolders(File rootFolder) throws IOException {
        int count = ThreadLocalRandom.current().nextInt(10) + 1;
        for (int i = 0; i < count; ++i) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                this.createRandomFile(rootFolder);
                continue;
            }
            this.createRandomFolder(rootFolder);
        }
    }

    private Directory createRandomLuceneDir(File rootFolder) throws IOException {
        File folder = this.createRandomFolder(rootFolder);
        DirectoryFactory directoryFactory = PartitionedIndexStorageTest.getOrCreateDirFactory(this.fs);
        Directory directory = directoryFactory.open(folder);
        try (IndexWriter writer = new IndexWriter(directory, IndexWriterConfigs.standard());){
            writer.addDocument((Iterable)PartitionedIndexStorageTest.randomDocument());
            writer.commit();
        }
        return directory;
    }

    private void createRandomFile(File rootFolder) throws IOException {
        File file = new File(rootFolder, RandomStringUtils.randomAlphabetic((int)5));
        try (StoreChannel channel = this.fs.create(file);){
            channel.writeAll(ByteBuffer.allocate(100));
        }
    }

    private File createRandomFolder(File rootFolder) throws IOException {
        File folder = new File(rootFolder, RandomStringUtils.randomAlphabetic((int)5));
        this.fs.mkdirs(folder);
        return folder;
    }

    private static Document randomDocument() {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("field", RandomStringUtils.randomAlphabetic((int)5), Field.Store.YES));
        return doc;
    }

    private static DirectoryFactory getOrCreateDirFactory(FileSystemAbstraction fs) {
        return (DirectoryFactory)fs.getOrCreateThirdPartyFileSystem(DirectoryFactory.class, clazz -> new DirectoryFactory.InMemoryDirectoryFactory());
    }
}

