/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriterConfig;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Factory;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Strings;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.TestPropertyAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneSchemaIndexUniquenessVerificationIT {
    private static final int DOCS_PER_PARTITION = ThreadLocalRandom.current().nextInt(10, 100);
    private static final int PROPERTY_KEY_ID = 42;
    private static final IndexDescriptor descriptor = IndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{42});
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private int nodesToCreate = DOCS_PER_PARTITION * 2 + 1;
    private SchemaIndex index;
    private static final long MAX_LONG_VALUE = 0x1FFFFFFFFFFFFFL;
    private static final long MIN_LONG_VALUE = 9007199254740971L;

    @Before
    public void setPartitionSize() throws Exception {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", String.valueOf(DOCS_PER_PARTITION));
        VerboseConfigFactory configFactory = new VerboseConfigFactory();
        this.index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)descriptor).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(this.testDir.directory("uniquenessVerification"))).withWriterConfig((Factory)configFactory).withIndexIdentifier("index")).build();
        this.index.create();
        this.index.open();
    }

    @After
    public void resetPartitionSize() throws IOException {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "");
        IOUtils.closeAll((AutoCloseable[])new SchemaIndex[]{this.index});
    }

    @Test
    public void stringValuesWithoutDuplicates() throws IOException {
        Set<PropertyValue> data = this.randomStrings();
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void stringValuesWithDuplicates() throws IOException {
        List<PropertyValue> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomStrings());
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void smallLongValuesWithoutDuplicates() throws IOException {
        long min = LuceneSchemaIndexUniquenessVerificationIT.randomLongInRange(100L, 10000L);
        long max = min + (long)this.nodesToCreate;
        Set<PropertyValue> data = this.randomLongs(min, max);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void smallLongValuesWithDuplicates() throws IOException {
        long min = LuceneSchemaIndexUniquenessVerificationIT.randomLongInRange(100L, 10000L);
        long max = min + (long)this.nodesToCreate;
        List<PropertyValue> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomLongs(min, max));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void largeLongValuesWithoutDuplicates() throws IOException {
        long max = LuceneSchemaIndexUniquenessVerificationIT.randomLongInRange(9007199254740971L, 0x1FFFFFFFFFFFFFL);
        long min = max - (long)this.nodesToCreate;
        Set<PropertyValue> data = this.randomLongs(min, max);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void largeLongValuesWithDuplicates() throws IOException {
        long max = LuceneSchemaIndexUniquenessVerificationIT.randomLongInRange(9007199254740971L, 0x1FFFFFFFFFFFFFL);
        long min = max - (long)this.nodesToCreate;
        List<PropertyValue> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomLongs(min, max));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void smallDoubleValuesWithoutDuplicates() throws IOException {
        double min = LuceneSchemaIndexUniquenessVerificationIT.randomDoubleInRange(100.0, 10000.0);
        double max = min + (double)this.nodesToCreate;
        Set<PropertyValue> data = this.randomDoubles(min, max);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void smallDoubleValuesWithDuplicates() throws IOException {
        double min = LuceneSchemaIndexUniquenessVerificationIT.randomDoubleInRange(100.0, 10000.0);
        double max = min + (double)this.nodesToCreate;
        List<PropertyValue> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomDoubles(min, max));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void largeDoubleValuesWithoutDuplicates() throws IOException {
        double max = LuceneSchemaIndexUniquenessVerificationIT.randomDoubleInRange(8.988465674311579E307, Double.MAX_VALUE);
        double min = max / 2.0;
        Set<PropertyValue> data = this.randomDoubles(min, max);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void largeDoubleValuesWithDuplicates() throws IOException {
        double max = LuceneSchemaIndexUniquenessVerificationIT.randomDoubleInRange(8.988465674311579E307, Double.MAX_VALUE);
        double min = max / 2.0;
        List<PropertyValue> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomDoubles(min, max));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void smallArrayValuesWithoutDuplicates() throws IOException {
        Set<PropertyValue> data = this.randomArrays(3, 7);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void smallArrayValuesWithDuplicates() throws IOException {
        List<PropertyValue> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomArrays(3, 7));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void largeArrayValuesWithoutDuplicates() throws IOException {
        Set<PropertyValue> data = this.randomArrays(70, 100);
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void largeArrayValuesWithDuplicates() throws IOException {
        List<PropertyValue> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomArrays(70, 100));
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    @Test
    public void variousValuesWithoutDuplicates() throws IOException {
        Set<PropertyValue> data = this.randomPropertyValues();
        this.insert(data);
        this.assertUniquenessConstraintHolds(data);
    }

    @Test
    public void variousValuesWitDuplicates() throws IOException {
        List<PropertyValue> data = LuceneSchemaIndexUniquenessVerificationIT.withDuplicate(this.randomPropertyValues());
        this.insert(data);
        this.assertUniquenessConstraintFails(data);
    }

    private void insert(Collection<PropertyValue> data) throws IOException {
        PropertyValue[] dataArray = data.toArray(new PropertyValue[data.size()]);
        for (int i = 0; i < dataArray.length; ++i) {
            Document doc = LuceneDocumentStructure.documentRepresentingProperties((long)i, (Object[])new Object[]{dataArray[i].value});
            this.index.getIndexWriter().addDocument(doc);
        }
        this.index.maybeRefreshBlocking();
    }

    private void assertUniquenessConstraintHolds(Collection<PropertyValue> data) {
        try {
            this.verifyUniqueness(data);
        }
        catch (Throwable t) {
            Assert.fail((String)("Unable to create uniqueness constraint for data: " + Strings.prettyPrint((Object)data.toArray()) + "\n" + Exceptions.stringify((Throwable)t)));
        }
    }

    private void assertUniquenessConstraintFails(Collection<PropertyValue> data) {
        try {
            this.verifyUniqueness(data);
            Assert.fail((String)("Should not be possible to create uniqueness constraint for data: " + Strings.prettyPrint((Object)data.toArray())));
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)Matchers.instanceOf(IndexEntryConflictException.class));
        }
    }

    private void verifyUniqueness(Collection<PropertyValue> data) throws IOException, IndexEntryConflictException {
        Object[] propertyValues = data.stream().map(property -> property.value).toArray();
        TestPropertyAccessor propertyAccessor = new TestPropertyAccessor(propertyValues);
        this.index.verifyUniqueness((PropertyAccessor)propertyAccessor, new int[]{42});
    }

    private Set<PropertyValue> randomStrings() {
        return ThreadLocalRandom.current().ints(this.nodesToCreate, 1, 200).mapToObj(this::randomString).map(PropertyValue::new).collect(Collectors.toSet());
    }

    private String randomString(int size) {
        return ThreadLocalRandom.current().nextBoolean() ? RandomStringUtils.random((int)size) : RandomStringUtils.randomAlphabetic((int)size);
    }

    private Set<PropertyValue> randomLongs(long min, long max) {
        return ThreadLocalRandom.current().longs(this.nodesToCreate, min, max).boxed().map(PropertyValue::new).collect(Collectors.toSet());
    }

    private Set<PropertyValue> randomDoubles(double min, double max) {
        return ThreadLocalRandom.current().doubles(this.nodesToCreate, min, max).boxed().map(PropertyValue::new).collect(Collectors.toSet());
    }

    private Set<PropertyValue> randomArrays(int minLength, int maxLength) {
        Randoms randoms = new Randoms((Random)ThreadLocalRandom.current(), (Randoms.Configuration)new ArraySizeConfig(minLength, maxLength));
        return IntStream.range(0, this.nodesToCreate).mapToObj(i -> randoms.array()).map(PropertyValue::new).collect(Collectors.toSet());
    }

    private Set<PropertyValue> randomPropertyValues() {
        Randoms randoms = new Randoms((Random)ThreadLocalRandom.current(), (Randoms.Configuration)new ArraySizeConfig(5, 100));
        return IntStream.range(0, this.nodesToCreate).mapToObj(i -> randoms.propertyValue()).map(PropertyValue::new).collect(Collectors.toSet());
    }

    private static List<PropertyValue> withDuplicate(Set<PropertyValue> set) {
        ArrayList<PropertyValue> data = new ArrayList<PropertyValue>(set);
        if (data.isEmpty()) {
            throw new IllegalStateException();
        }
        if (data.size() == 1) {
            data.add((PropertyValue)data.get(0));
        } else {
            int duplicateValueIndex;
            int duplicateIndex = LuceneSchemaIndexUniquenessVerificationIT.randomIntInRange(0, data.size());
            while ((duplicateValueIndex = ThreadLocalRandom.current().nextInt(data.size())) == duplicateIndex) {
            }
            PropertyValue duplicate = LuceneSchemaIndexUniquenessVerificationIT.duplicatePropertyValue((PropertyValue)data.get(duplicateValueIndex));
            data.set(duplicateIndex, duplicate);
        }
        return data;
    }

    private static PropertyValue duplicatePropertyValue(PropertyValue propertyValue) {
        return new PropertyValue(propertyValue.value);
    }

    private static int randomIntInRange(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max);
    }

    private static long randomLongInRange(long min, long max) {
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    private static double randomDoubleInRange(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    private static class VerboseConfigFactory
    implements Factory<IndexWriterConfig> {
        private VerboseConfigFactory() {
        }

        public IndexWriterConfig newInstance() {
            IndexWriterConfig verboseConfig = IndexWriterConfigs.standard();
            verboseConfig.setInfoStream(System.out);
            return verboseConfig;
        }
    }

    private static class PropertyValue {
        final Object value;

        PropertyValue(Object value) {
            this.value = Objects.requireNonNull(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyValue that = (PropertyValue)o;
            return Property.property((int)42, (Object)this.value).valueEquals(that.value);
        }

        public int hashCode() {
            if (this.value instanceof Number) {
                return Double.hashCode(((Number)this.value).doubleValue());
            }
            if (this.value.getClass().isArray()) {
                return ArrayUtil.hashCode((Object)this.value);
            }
            return this.value.hashCode();
        }

        public String toString() {
            return Strings.prettyPrint((Object)this.value);
        }
    }

    private static class ArraySizeConfig
    extends Randoms.Default {
        final int minLength;
        final int maxLength;

        ArraySizeConfig(int minLength, int maxLength) {
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        public int arrayMinLength() {
            return super.arrayMinLength();
        }

        public int arrayMaxLength() {
            return super.arrayMaxLength();
        }
    }
}

